/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;

public class RenameDialog
extends Dialog {
    private IWorkbenchSite site;
    private File[] files = new File[0];
    private Text[] texts;

    protected RenameDialog(IWorkbenchSite site) {
        super(site.getShell());
        this.site = site;
    }

    public boolean isOpened() {
        return this.getShell() != null && !this.getShell().isDisposed();
    }

    protected Point getInitialSize() {
        return new Point(320, 240);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("explorer.convertdialog"));
    }

    public void closeWindow() {
        this.close();
    }

    private String toLabelName(File file) {
        String name = file.getName();
        if (name.toLowerCase().endsWith(".flv")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private String toFileName(String label, File file) {
        String name = file.getName();
        String newName = label;
        if (name.toLowerCase().endsWith(".flv")) {
            newName = String.valueOf(newName) + name.substring(name.length() - 4);
        }
        return newName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite root = (Composite)super.createDialogArea(parent);
        root.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(root, 768);
        Composite composite = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.texts = new Text[this.files.length];
        int i = 0;
        while (i < this.files.length) {
            Label label = new Label(composite, 0);
            String name = this.toLabelName(this.files[i]);
            label.setText(name);
            this.texts[i] = new Text(composite, 0);
            this.texts[i].setText(name);
            this.texts[i].setLayoutData((Object)new GridData(768));
            ++i;
        }
        this.texts[0].selectAll();
        composite.pack();
        sc.setContent((Control)composite);
        sc.setMinSize(composite.getSize().x, composite.getSize().y);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.layout();
        return root;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        int i = 0;
        while (i < this.files.length) {
            File newFile;
            String newName = this.toFileName(this.texts[i].getText(), this.files[i]);
            if (!newName.equals(this.files[i].getName()) && !(newFile = new File(this.files[i].getParent(), newName)).exists()) {
                boolean result = this.files[i].renameTo(newFile);
                ExplorerView.log.info((Object)(String.valueOf(result) + ":rename from " + this.files[i] + " to " + newFile));
            }
            ++i;
        }
        this.close();
    }
}

