/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DirectoryList
extends TableViewer {
    protected ArrayList fileList = new ArrayList();
    protected FilenameFilter filenameFilter;
    protected File baseDirectory;
    protected static Image fileImage;
    protected static Image folderImage;
    static /* synthetic */ Class class$0;

    static {
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileImage = new Image((Device)display, clazz.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/resource/file.png"));
        Display display2 = Display.getCurrent();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        folderImage = new Image((Device)display2, clazz2.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/resource/folder.png"));
    }

    public DirectoryList(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
    }

    public DirectoryList(Composite parent) {
        super(parent);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
    }

    public void updateDirectory() {
        this.fileList.removeAll(this.fileList);
        String[] list = null;
        list = this.filenameFilter != null ? this.baseDirectory.list(this.filenameFilter) : this.baseDirectory.list();
        int i = 0;
        while (i < list.length) {
            this.addFile(new File(this.baseDirectory, list[i]));
            ++i;
        }
    }

    public void openDirectory(String path) {
        this.setBaseDirectory(new File(path));
        this.updateDirectory();
        this.refresh();
    }

    protected void removeFile(String name) {
        File file = new File(this.baseDirectory, name);
        this.fileList.remove(file);
    }

    protected boolean isExist(String[] base, String name) {
        int i = 0;
        while (i < base.length) {
            if (base[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addFile(File file) {
        SimpleView.log.info((Object)("add:" + file.getAbsolutePath()));
        this.fileList.add(file);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public File[] getFileList() {
        return this.fileList.toArray(new File[0]);
    }

    public File[] getSelectionFiles() {
        ISelection selection = this.getSelection();
        return ((IStructuredSelection)selection).toList().toArray(new File[0]);
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return DirectoryList.this.fileList.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((File)obj).getName();
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            File file = (File)obj;
            if (file.isDirectory()) {
                return folderImage;
            }
            return fileImage;
        }
    }
}

