/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ui.FTPInfoDialog;
import jp.sourceforge.akjrcp.util.FTPInfo;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class FTPInfoEditor
extends FieldEditor {
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private TableViewer table;
    private List ftpInfoList;
    private Label label;
    private Composite menus;

    public FTPInfoEditor(String key, String description, Composite parent) {
        super(key, description, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        System.out.println("adjust:" + numColumns);
    }

    private Table getTable(Composite parent) {
        if (this.table == null) {
            this.ftpInfoList = new ArrayList();
            this.table = new TableViewer(parent);
            this.table.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
            this.table.setContentProvider((IContentProvider)new ViewContentProvider());
            this.table.setInput((Object)this.ftpInfoList);
        }
        return this.table.getTable();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabel(parent);
        GridData ld = new GridData();
        ld.horizontalSpan = numColumns;
        label.setLayoutData((Object)ld);
        Table table = this.getTable(parent);
        GridData gd = new GridData(1808);
        System.out.println("col:" + numColumns);
        gd.horizontalSpan = numColumns - 1;
        gd.minimumHeight = 100;
        table.setLayoutData((Object)gd);
        Composite menus = this.getMenus(parent);
        menus.setLayoutData((Object)new GridData());
    }

    private Label getLabel(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 0);
            this.label.setText(this.getLabelText());
        }
        return this.label;
    }

    private Composite getMenus(Composite parent) {
        if (this.menus == null) {
            this.menus = new Composite(parent, 0);
            this.menus.setLayout((Layout)new GridLayout());
            this.newButton = this.createButton(this.menus, Messages.getString("ftpInfo.new"));
            this.editButton = this.createButton(this.menus, Messages.getString("ftpInfo.edit"));
            this.removeButton = this.createButton(this.menus, Messages.getString("ftpInfo.remove"));
        }
        return this.menus;
    }

    public Button createButton(Composite p, String label) {
        Button bt = new Button(p, 0);
        bt.setText(label);
        bt.addSelectionListener((SelectionListener)new ButtonSelect());
        bt.setLayoutData((Object)new GridData());
        return bt;
    }

    public static FTPInfo[] toFTPInfos(String lines) {
        if (lines.length() == 0) {
            return new FTPInfo[0];
        }
        String[] line = lines.split("\n");
        FTPInfo[] infos = new FTPInfo[line.length];
        int i = 0;
        while (i < infos.length) {
            infos[i] = FTPInfoEditor.toFTPInfo(line[i]);
            ++i;
        }
        return infos;
    }

    private String toStoreString(FTPInfo info) {
        String str = "";
        str = String.valueOf(str) + info.getName() + "\t" + info.getHost() + "\t" + info.getUser() + "\t" + info.getPassword() + "\t" + info.getDir() + "\t" + info.getPort();
        return str;
    }

    private static FTPInfo toFTPInfo(String text) {
        FTPInfo info = new FTPInfo();
        String[] values = text.split("\t");
        int i = 0;
        while (i < values.length) {
            if (i == 0) {
                info.setName(values[i]);
            } else if (i == 1) {
                info.setHost(values[i]);
            } else if (i == 2) {
                info.setUser(values[i]);
            } else if (i == 3) {
                info.setPassword(values[i]);
            } else if (i == 4) {
                info.setDir(values[i]);
            } else if (i == 5 && values[i].length() > 0) {
                try {
                    info.setPort(Integer.parseInt(values[i]));
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return info;
    }

    protected void doLoad() {
        FTPInfo[] infos = FTPInfoEditor.toFTPInfos(this.getPreferenceStore().getString(this.getPreferenceName()));
        int i = 0;
        while (i < infos.length) {
            this.ftpInfoList.add(infos[i]);
            ++i;
        }
        this.table.refresh();
    }

    protected void doLoadDefault() {
    }

    private void saveStore() {
        this.setPresentsDefaultValue(false);
        StringBuffer buffer = new StringBuffer();
        FTPInfo[] infos = this.ftpInfoList.toArray(new FTPInfo[0]);
        int i = 0;
        while (i < infos.length) {
            buffer.append(String.valueOf(this.toStoreString(infos[i])) + "\n");
            ++i;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), buffer.toString());
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public class ButtonSelect
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.widget == FTPInfoEditor.this.newButton) {
                FTPInfoDialog dialog = new FTPInfoDialog(FTPInfoEditor.this.getPage().getShell());
                int bt = dialog.open();
                System.out.println(bt);
                if (bt == 0) {
                    FTPInfo info = dialog.getFtpInfo();
                    FTPInfoEditor.this.ftpInfoList.add(info);
                    FTPInfoEditor.this.table.refresh();
                    FTPInfoEditor.this.saveStore();
                }
            } else if (e.widget == FTPInfoEditor.this.editButton) {
                int index = FTPInfoEditor.this.table.getTable().getSelectionIndex();
                FTPInfo info = (FTPInfo)FTPInfoEditor.this.ftpInfoList.get(index);
                FTPInfoDialog dialog = new FTPInfoDialog(FTPInfoEditor.this.getPage().getShell());
                dialog.setFtpInfo(info);
                int bt = dialog.open();
                System.out.println(bt);
                if (bt == 0) {
                    info.copyValue(dialog.getFtpInfo());
                    FTPInfoEditor.this.table.refresh();
                    FTPInfoEditor.this.saveStore();
                }
            } else if (e.widget == FTPInfoEditor.this.removeButton) {
                int index = FTPInfoEditor.this.table.getTable().getSelectionIndex();
                FTPInfoEditor.this.ftpInfoList.remove(FTPInfoEditor.this.ftpInfoList.get(index));
                FTPInfoEditor.this.table.refresh();
                FTPInfoEditor.this.saveStore();
            } else {
                Widget cfr_ignored_0 = e.widget;
                FTPInfoEditor.this.table.getTable();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((FTPInfo)obj).toLabel();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((List)parent).toArray();
        }
    }
}

