/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.part.ViewPart;

public class MPEGConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;
    public static final String TYPE_SELECT = "type_select";
    public static final String AVISYNTH = "avisynth";
    public static final String VIDEO_BITRATE = "video_bitrate";
    public static final String ASPECT_RATIO = "aspect_ratio";
    public static final String MPEGCONVERT = "mpegconvert";

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText("MPEG-Videos");
        tabItem1.setText(Messages.getString("dropsomething.mpegvideo"));
        tabItem1.setControl((Control)new MPEGConvertTab((Composite)tab, 0));
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public class MPEGConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private Label dragHere;
        private CCombo typeSelect;
        private Scale videoBitrateScale;
        private CCombo aspectRatio;
        private Button avisynth;

        public MPEGConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            this.setPreferenceKey(MPEGConvertTabBuilder.MPEGCONVERT);
            SavePreferenceStore savePreference = new SavePreferenceStore();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            this.createDirectoryInfo(composite);
            Composite bitrateSetting = new Composite(composite, 0);
            bitrateSetting.setLayout((Layout)new GridLayout(4, true));
            Label videobitrate = new Label(bitrateSetting, 0);
            this.videoBitrateScale = new Scale(bitrateSetting, 0);
            this.videoBitrateScale.setMaximum(98);
            this.videoBitrateScale.setMinimum(1);
            this.videoBitrateScale.addSelectionListener((SelectionListener)savePreference);
            this.restoreControl((Control)this.videoBitrateScale);
            UpdateVideoBitrateLabel updateVideoBitrateLabel = new UpdateVideoBitrateLabel(videobitrate, this.videoBitrateScale);
            updateVideoBitrateLabel.updateLabel();
            this.typeSelect = new CCombo(composite, 8);
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg1_mp2"));
            this.typeSelect.add(Messages.getString("dvd_720x480_mpeg2_ac3"));
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg2_ac3"));
            this.typeSelect.add(Messages.getString("dvd_720x480_mpeg2_mp2"));
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg2_mp2"));
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg2_ac3_2pass"));
            this.typeSelect.select(0);
            this.typeSelect.addSelectionListener((SelectionListener)savePreference);
            this.avisynth = new Button(composite, 32);
            this.avisynth.setText(Messages.getString("flvconvert.use_avisynth"));
            this.avisynth.setSelection(this.getPreferenceStore().getBoolean("flvconvert.use_avisynth"));
            this.avisynth.setToolTipText(Messages.getString("flvconvert.use_avisynth_tooltip"));
            this.avisynth.addSelectionListener((SelectionListener)savePreference);
            Composite aspectSetting = new Composite(composite, 0);
            aspectSetting.setLayout((Layout)new GridLayout(2, false));
            Label aspectLabel = new Label(aspectSetting, 0);
            aspectLabel.setText(Messages.getString("mpegconvert.aspect"));
            this.aspectRatio = new CCombo(aspectSetting, 8);
            this.aspectRatio.add("4:3");
            this.aspectRatio.add("16:9");
            this.aspectRatio.select(0);
            this.aspectRatio.addSelectionListener((SelectionListener)savePreference);
            this.aspectRatio.setToolTipText(Messages.getString("mpegconvert.aspect_tooltip"));
            this.dragHere = new Label(composite, 0);
            this.dragHere.setLayoutData((Object)new GridData(1808));
            this.restoreControl((Control)this.typeSelect);
            this.restoreControl((Control)this.aspectRatio);
            this.restoreControl((Control)this.avisynth);
            this.setCanConvert(true);
            this.updateStatus();
            return composite;
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                this.avisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.AVISYNTH));
            } else if (control == this.typeSelect) {
                this.selectCombo(this.typeSelect, store.getString(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.TYPE_SELECT));
            } else if (control == this.aspectRatio) {
                this.selectCombo(this.aspectRatio, store.getString(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.ASPECT_RATIO));
            } else if (control == this.videoBitrateScale) {
                System.out.println(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.VIDEO_BITRATE + "," + store.getInt(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.VIDEO_BITRATE));
                this.videoBitrateScale.setSelection(store.getInt(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.VIDEO_BITRATE));
            }
        }

        public void selectCombo(CCombo combo, String value) {
            int s = combo.getItemCount();
            int i = 0;
            while (i < s) {
                if (combo.getItem(i).equals(value)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.AVISYNTH, this.avisynth.getSelection());
            } else if (control == this.typeSelect) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.TYPE_SELECT, this.typeSelect.getItem(this.typeSelect.getSelectionIndex()));
            } else if (control == this.aspectRatio) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.ASPECT_RATIO, this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
            } else if (control == this.videoBitrateScale) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + MPEGConvertTabBuilder.VIDEO_BITRATE, this.videoBitrateScale.getSelection());
            }
        }

        public String toTime(long bps, long maxMega) {
            String sstring;
            String mstring;
            long bytes = bps / 8L;
            long second = maxMega * 1024L * 1024L / bytes;
            long hour = second / 3600L;
            long min = (second %= 3600L) / 60L;
            long sec = second % 60L;
            String hstring = "" + hour;
            if (hstring.length() < 2) {
                hstring = "0" + hstring;
            }
            if ((mstring = "" + min).length() < 2) {
                mstring = "0" + mstring;
            }
            if ((sstring = "" + sec).length() < 2) {
                sstring = "0" + sstring;
            }
            return String.valueOf(hstring) + ":" + mstring + ":" + sstring;
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            FFMpegPreference preference = this.ffmpegExecuter.getFfmpegPreference();
            preference.setFfmpegPath(ffmpegPath);
            preference.setExtension("mpg");
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
            this.ffmpegExecuter.setUseAvisynth(this.avisynth.getSelection());
            int videoBitrate = this.videoBitrateScale.getSelection() * 100;
            int audioBitrate = 256;
            String selectlabel = this.typeSelect.getItem(this.typeSelect.getSelectionIndex());
            if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg1_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg1video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setVideoMaxBitrate(videoBitrate);
                preference.setVideoMinBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_720x480_mpeg2_ac3"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("720x480");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("ac3");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg2_ac3"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("ac3");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg2_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_720x480_mpeg2_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("720x480");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg2_ac3_2pass"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect(this.aspectRatio.getItem(this.aspectRatio.getSelectionIndex()));
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("ac3");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
                preference.setTwoPassEncode(true);
            }
            if (videoBitrate > 9000) {
                preference.setVideoMaxBitrate(videoBitrate);
            }
        }

        public void afterConvert() {
        }

        public boolean isCanConvert() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            return FFMpegUtils.isFFMpegAvailable(ffmpegPath);
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MPEGConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class UpdateVideoBitrateLabel
        implements SelectionListener {
            private Label label;
            private Scale scale;

            public UpdateVideoBitrateLabel(Label label, Scale scale) {
                this.label = label;
                this.scale = scale;
                scale.addSelectionListener((SelectionListener)this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                this.updateLabel();
            }

            public void updateLabel() {
                int value = this.scale.getSelection();
                this.label.setText(this.toLabel(value));
            }

            public String toLabel(int value) {
                String label = String.valueOf(Messages.getString("mpegconver.video_bitrate")) + " ";
                label = String.valueOf(label) + value * 100 + " k/bps";
                double mega = ((double)value * 100.0 + 256.0) * 1000.0 / 8.0 / 1024.0 / 1024.0;
                int mega_hour = (int)(mega * 60.0 * 60.0);
                String tmpV = "" + mega_hour;
                String description = "";
                description = String.valueOf(description) + "15 " + Messages.getString("MPEGConvertTab.minute") + " = " + (int)(mega * 15.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "30 " + Messages.getString("MPEGConvertTab.minute") + " = " + (int)(mega * 30.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "45 " + Messages.getString("MPEGConvertTab.minute") + " = " + (int)(mega * 45.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "1 " + Messages.getString("MPEGConvertTab.hour") + " = " + tmpV + "MB" + "\n";
                description = String.valueOf(description) + "1 " + Messages.getString("MPEGConvertTab.hour") + " " + 30 + " " + Messages.getString("MPEGConvertTab.minute") + " = " + (int)(mega * 90.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "1 " + Messages.getString("MPEGConvertTab.hour") + " " + 45 + " " + Messages.getString("MPEGConvertTab.minute") + " = " + (int)(mega * 105.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "2 " + Messages.getString("MPEGConvertTab.hour") + " = " + (int)(mega * 120.0 * 60.0) + "MB" + "\n";
                description = String.valueOf(description) + "4.4G DVD = " + MPEGConvertTab.this.toTime(MPEGConvertTab.this.videoBitrateScale.getSelection() * 1000 * 100 + 256000, 4403L);
                this.scale.setToolTipText(description);
                return label;
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
            }

            public void startConvert(File file) {
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:mpeg]" + file.getAbsolutePath() + "\n\n");
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:mpeg]" + message + "," + file.getAbsolutePath() + "\n\n");
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(MPEGConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

