/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import jp.sourceforge.akjrcp.audio.MpegAudioFormatUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MP3FFMpegPreference
extends FFMpegPreference {
    public static Log log;
    private boolean forceConvert = false;
    private int defaultBitrate = 128;
    private int convertChannel = 2;
    private int convertFramerate = 44100;
    private int convertBitrate = 128;
    private boolean useCopy = true;
    private String[] ignoreBitrateFormat = new String[]{"wav"};
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ffmpeg.MP3FFMpegPreference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public int getConvertBitrate() {
        return this.convertBitrate;
    }

    public void setConvertBitrate(int convertBitrate) {
        this.convertBitrate = convertBitrate;
    }

    public int getConvertChannel() {
        return this.convertChannel;
    }

    public void setConvertChannel(int convertChannel) {
        this.convertChannel = convertChannel;
    }

    public int getConvertFramerate() {
        return this.convertFramerate;
    }

    public void setConvertFramerate(int convertFramerate) {
        this.convertFramerate = convertFramerate;
    }

    public int getDefaultBitrate() {
        return this.defaultBitrate;
    }

    public void setDefaultBitrate(int defaultBitrate) {
        this.defaultBitrate = defaultBitrate;
    }

    public boolean isForceConvert() {
        return this.forceConvert;
    }

    public void setForceConvert(boolean forceConvert) {
        this.forceConvert = forceConvert;
    }

    public boolean isUseCopy() {
        return this.useCopy;
    }

    public void setUseCopy(boolean useCopy) {
        this.useCopy = useCopy;
    }

    private boolean isCanUseBitrate(String extension) {
        int i = 0;
        while (i < this.ignoreBitrateFormat.length) {
            if (extension.toLowerCase().equals(this.ignoreBitrateFormat[i].toLowerCase())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] toCommand(String input, String avsInput, String output) {
        int bitrate;
        int inputFramerate;
        String inputType = PathnameUtils.getExtension(input);
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        this.setEnableVideo(false);
        FLVInfomation info = parser.parseFile(new File(input));
        if (!info.isHaveAudio()) {
            if (avsInput == null) {
                log.warn((Object)"no aduio stream");
                return null;
            }
            info = parser.parseFile(new File(avsInput));
            if (!info.isHaveAudio()) {
                log.warn((Object)"no aduio stream even in avs");
                return null;
            }
        }
        String inputCodec = info.getAudioCodec();
        int inputChannel = info.getAudioChannel();
        if (inputChannel == 0) {
            log.info((Object)"input channel must not 0");
        }
        if ((inputFramerate = info.getAudioRate()) == 0) {
            log.info((Object)"input inputFramerate must not 0");
        }
        if ((bitrate = info.getAudioBitrate()) == 0) {
            log.warn((Object)"input bitrate must not 0");
            bitrate = this.defaultBitrate;
        }
        if (inputChannel == 0 || inputFramerate == 0) {
            if (avsInput != null) {
                info = parser.parseFile(new File(avsInput));
                inputChannel = info.getAudioChannel();
                if (inputChannel == 0) {
                    log.warn((Object)"inputAvs channel must not 0");
                    return null;
                }
                inputFramerate = info.getAudioRate();
                if (inputFramerate == 0) {
                    log.warn((Object)"inputAvs inputFramerate must not 0");
                    return null;
                }
            } else {
                log.warn((Object)(String.valueOf(inputChannel) + "," + inputFramerate + " there are no avs and not supported codec"));
                return null;
            }
        }
        if (this.forceConvert) {
            this.setAudioCodec("mp3");
            int tmpFramerate = this.convertFramerate == -1 ? inputFramerate : this.convertFramerate;
            this.setAudioRate(tmpFramerate);
            int[] supportedBitrate = MpegAudioFormatUtil.getAvailableMP3Bitrate(inputFramerate);
            int tmpBitrate = this.convertBitrate == -1 ? MpegAudioFormatUtil.getSimilarValue(supportedBitrate, bitrate) : MpegAudioFormatUtil.getSimilarValue(supportedBitrate, this.convertBitrate);
            this.setAudioBitrate(tmpBitrate);
            int tmpChannel = this.convertChannel == -1 ? inputChannel : this.convertChannel;
            this.setAudioChannel(tmpChannel);
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), tmpBitrate));
        } else if (this.useCopy && inputCodec.equals("mp3")) {
            this.setAudioCodec("copy");
            avsInput = null;
            int audioB = info.getAudioBitrate();
            if (audioB == 0) {
                audioB = 128;
            }
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), audioB));
        } else {
            this.setAudioCodec("mp3");
            this.setAudioRate(inputFramerate);
            int[] supportedBitrate = MpegAudioFormatUtil.getAvailableMP3Bitrate(inputFramerate);
            int tmpBitrate = this.isCanUseBitrate(inputType) ? MpegAudioFormatUtil.getSimilarValue(supportedBitrate, bitrate) : MpegAudioFormatUtil.getSimilarValue(supportedBitrate, this.defaultBitrate);
            this.setAudioBitrate(tmpBitrate);
            this.setAudioChannel(inputChannel);
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), tmpBitrate));
        }
        return super.toCommand(input, avsInput, output);
    }
}

