/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.textinsert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextInsertInputStream
extends InputStream {
    private String targetText;
    private String encoding;
    private String insertText;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int REPLACE = 2;
    private int type;
    private boolean doAll;
    private boolean ignore;
    private InputStream input;
    private int[] buffers;
    private int bufferposition;
    private int[] checkbytes;
    private String encode;
    private Log log;
    static /* synthetic */ Class class$0;

    public TextInsertInputStream(InputStream input, String targetText, String insertText, int mode, String encode) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.textinsert.TextInsertInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.input = input;
        this.targetText = targetText;
        this.insertText = insertText;
        this.type = mode;
        this.encode = encode;
        try {
            byte[] bts = targetText.getBytes(encode);
            this.checkbytes = new int[bts.length];
            int i = 0;
            while (i < bts.length) {
                this.checkbytes[i] = bts[i] & 0xFF;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public int read() throws IOException {
        if (this.buffers != null && this.bufferposition < this.buffers.length) {
            int r = this.buffers[this.bufferposition];
            ++this.bufferposition;
            if (this.bufferposition >= this.buffers.length) {
                this.buffers = null;
                this.bufferposition = 0;
            }
            return r;
        }
        int b = this.input.read();
        if (b == -1) {
            return b;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(b);
        int i = 0;
        while (i < this.checkbytes.length) {
            int[] vs;
            if (this.checkbytes[i] == b || this.ignore && Character.toLowerCase(b) == Character.toLowerCase(this.checkbytes[i])) {
                vs = this.toInts(bout.toByteArray());
                this.log.debug((Object)("mutch:" + (char)b));
                if (i == this.checkbytes.length - 1) {
                    this.log.debug((Object)("last:" + (char)b));
                    int[] ins = this.toInts(this.insertText.getBytes(this.encode));
                    if (this.type == 0) {
                        this.buffers = new int[this.checkbytes.length + ins.length];
                        System.arraycopy(ins, 0, this.buffers, 0, ins.length);
                        System.arraycopy(vs, 0, this.buffers, ins.length, vs.length);
                        break;
                    }
                    if (this.type == 1) {
                        this.buffers = new int[this.checkbytes.length + ins.length];
                        System.arraycopy(vs, 0, this.buffers, 0, vs.length);
                        System.arraycopy(ins, 0, this.buffers, vs.length, ins.length);
                        break;
                    }
                    if (this.type != 2) break;
                    this.buffers = ins;
                    break;
                }
            } else {
                this.log.debug((Object)("fail:" + (char)b + ", hope=" + (char)this.checkbytes[i]));
                this.buffers = new int[i + 1];
                vs = this.toInts(bout.toByteArray());
                System.arraycopy(vs, 0, this.buffers, 0, i);
                this.buffers[this.buffers.length - 1] = b;
                break;
            }
            b = this.input.read();
            bout.write(b);
            ++i;
        }
        return this.read();
    }

    private int[] toInts(byte[] bytes) {
        int[] ints = new int[bytes.length];
        int i = 0;
        while (i < ints.length) {
            ints[i] = 0xFF & bytes[i];
            ++i;
        }
        return ints;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

