/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.FolderDescription;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;

public abstract class ResourceDescription {
    public static ResourceDescription fromResource(IResource resource) {
        if (resource.getType() == 4) {
            return new ProjectDescription((IProject)resource);
        }
        if (resource.getType() == 2) {
            return new FolderDescription((IFolder)resource);
        }
        if (resource.getType() == 1) {
            return new FileDescription((IFile)resource);
        }
        throw new IllegalArgumentException();
    }

    public abstract IResource createResourceHandle();

    public abstract String getName();

    public abstract IResource createResource(IProgressMonitor var1) throws CoreException;

    public abstract void createExistentResourceFromHandle(IResource var1, IProgressMonitor var2) throws CoreException;

    public abstract boolean isValid();

    public abstract void recordStateFromHistory(IResource var1, IProgressMonitor var2) throws CoreException;

    public abstract boolean verifyExistence(boolean var1);
}

