/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.akjrcp.text_douga.parser.ColorLine;
import jp.sourceforge.akjrcp.text_douga.parser.CommentLine;
import jp.sourceforge.akjrcp.text_douga.parser.DataLine;
import jp.sourceforge.akjrcp.text_douga.parser.EmptyLine;
import jp.sourceforge.akjrcp.text_douga.parser.FileLine;
import jp.sourceforge.akjrcp.text_douga.parser.PropertyLine;
import jp.sourceforge.akjrcp.text_douga.parser.TextLine;
import jp.sourceforge.akjrcp.text_douga.parser.URLLine;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParserUtils {
    public static Log log = LogFactory.getLog(ParserUtils.class);
    public static final int FILE_UNKNOWN = 0;
    public static final int FILE_VIDEO = 1;
    public static final int FILE_AUDIO = 2;
    public static final int FILE_DIRECTORY = 3;
    public static final int FILE_VIDEO_AUDIO = 4;
    public static final int FILE_IMAGE = 5;
    public static final int FILE_SUBTTILE = 6;
    public static final String[] imgs = new String[]{"png", "gif", "jpg", "jpeg", "bmp"};
    public static final String[] videos = new String[]{"avi", "flv", "mpg", "vob", "wmv", "mp4", "ts", "ogm", "mkv", "m2v", "m1v"};
    public static final String[] audios = new String[]{"mp3", "wav", "aac", "wma", "mp2", "ogg", "au", "ac3", "m2a"};
    public static final String[] subtitle = new String[]{"srt"};
    private static String[] supportedDownloads = new String[]{"mp3", "wav", "ogg", "jpg", "png", "gif", "flv", "avi", "wmv", "mpg"};

    public static String[] toMixFilterExtensions(String[] types) {
        String ret = "";
        int i = 0;
        while (i < types.length) {
            ret = String.valueOf(ret) + "*." + types[i];
            ret = String.valueOf(ret) + ";";
            ++i;
        }
        return new String[]{ret.substring(0, ret.length() - 1)};
    }

    public static int toColor(String hex) {
        String h = hex;
        if (h.startsWith("#")) {
            h = hex.substring(1);
        }
        return Integer.parseInt(h, 16);
    }

    public static String toFilePath(File baseDir, String path) {
        return PathnameUtils.createPath((String)(String.valueOf(baseDir.getAbsolutePath()) + "/"), (String)path);
    }

    public static DataLine[] parseDataLines(File baseDir, String text) {
        ArrayList<DataLine> dataLines = new ArrayList<DataLine>();
        text = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        text = StringUtils.replace((String)text, (String)"\r", (String)"\n");
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(";")) {
                dataLines.add(new CommentLine(lines[i]));
            } else if (lines[i].startsWith("#")) {
                if (ParserUtils.isColorText(lines[i].substring(1))) {
                    int color = ParserUtils.toColor(lines[i]);
                    dataLines.add(new ColorLine(lines[i], color));
                } else {
                    String[] k_v = lines[i].substring(1).split(",");
                    HashMap<String, String> map = new HashMap<String, String>();
                    int j = 0;
                    while (j < k_v.length) {
                        String[] kv = k_v[j].split("=");
                        if (kv.length == 2) {
                            ParserUtils.putMap(map, kv[0], kv[1]);
                        } else if (kv.length == 1) {
                            map.put(kv[0], "1");
                        } else {
                            log.warn((Object)("invalid params:" + lines[i]));
                        }
                        ++j;
                    }
                    dataLines.add(new PropertyLine(lines[i], map));
                }
            } else {
                boolean wpath = PathnameUtils.isWindowsRootPath((String)lines[i]);
                if (lines[i].equals("")) {
                    dataLines.add(new EmptyLine());
                } else if (wpath) {
                    File tmp = new File(lines[i]);
                    if (tmp.exists()) {
                        dataLines.add(new FileLine(lines[i], tmp.getAbsolutePath()));
                    } else {
                        log.warn((Object)("not found:" + lines[i]));
                        dataLines.add(new TextLine(lines[i]));
                    }
                } else if (ParserUtils.isURLLine(lines[i])) {
                    URLLine urlLine = new URLLine(lines[i]);
                    dataLines.add(urlLine);
                } else {
                    String mixed = ParserUtils.toFilePath(baseDir, lines[i]);
                    log.info((Object)("mixed:" + mixed));
                    File tmp = new File(mixed);
                    if (tmp.exists()) {
                        dataLines.add(new FileLine(lines[i], tmp.getAbsolutePath()));
                    } else {
                        dataLines.add(new TextLine(lines[i]));
                    }
                }
            }
            ++i;
        }
        return dataLines.toArray(new DataLine[dataLines.size()]);
    }

    public static void putMap(Map<String, String> map, String key, String value) {
        if ((key = key.toLowerCase()).equals("loop")) {
            if (value.toLowerCase().equals("forever") || value.toLowerCase().equals("foreever")) {
                value = "-1";
            }
        } else if (key.equals("duration") && (value.toLowerCase().equals("forever") || value.toLowerCase().equals("foreever"))) {
            value = "-1";
        }
        map.put(key, value);
    }

    private static boolean isURLLine(String line) {
        if (YoutubeUtils.isYoutubeVideoURL((String)line)) {
            return true;
        }
        if (line.startsWith("http://")) {
            int i = 0;
            while (i < supportedDownloads.length) {
                if (line.toLowerCase().endsWith("." + supportedDownloads[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDrawText(String text) {
        if (text == null) {
            return false;
        }
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        String[] sp = text.split(",");
        return sp[0].toLowerCase().equals("draw");
    }

    public static boolean isColorText(String text) {
        if (text == null) {
            return false;
        }
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        if (text.length() != 6) {
            return false;
        }
        char[] cchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'd', 'f'};
        String test = text.toLowerCase();
        int i = 0;
        while (i < text.length()) {
            boolean much = false;
            int j = 0;
            while (j < cchar.length) {
                if (test.charAt(i) == cchar[j]) {
                    much = true;
                }
                ++j;
            }
            if (!much) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isImageFile(String path) {
        int i = 0;
        while (i < imgs.length) {
            if (path.toLowerCase().endsWith("." + imgs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int getFileType(String path) {
        if (path == null) {
            return 0;
        }
        int type = 0;
        int i = 0;
        while (i < imgs.length) {
            if (path.toLowerCase().endsWith("." + imgs[i])) {
                return 5;
            }
            ++i;
        }
        i = 0;
        while (i < videos.length) {
            if (path.toLowerCase().endsWith("." + videos[i])) {
                return 1;
            }
            ++i;
        }
        i = 0;
        while (i < audios.length) {
            if (path.toLowerCase().endsWith("." + audios[i])) {
                return 2;
            }
            ++i;
        }
        i = 0;
        while (i < subtitle.length) {
            if (path.toLowerCase().endsWith("." + subtitle[i])) {
                return 6;
            }
            ++i;
        }
        if (new File(path).isDirectory()) {
            return 3;
        }
        return type;
    }
}

