/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audio;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.audio.StreamMonitor;

public class SoxStretch {
    private String soxPath = null;
    private String ffmpegPath = null;
    private int bitrate = 128;
    public double[] speeds = new double[]{1.8, 1.6, 1.4, 1.2, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5};

    public static void main(String[] args) {
        SoxStretch stretch = new SoxStretch();
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        String[] list = inputDir.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File f = new File(inputDir, list[i]);
                stretch.makeStretchMP3(f, outputDir);
                ++i;
            }
        }
    }

    public void makeStretchMP3(File input, File outputDir) {
        try {
            int i = 0;
            while (i < this.speeds.length) {
                File tmp = File.createTempFile("xxx", ".wav");
                File tmp2 = File.createTempFile("xxx", ".wav");
                this.exec(new String[]{this.ffmpegPath, "-y", "-i", input.getAbsolutePath(), tmp.getAbsolutePath()});
                String baseName = this.chompExtension(input.getName());
                File mp3output = new File(outputDir, String.valueOf(baseName) + "_" + this.speeds[i] + ".mp3");
                this.exec(new String[]{this.soxPath, tmp.getAbsolutePath(), tmp2.getAbsolutePath(), "stretch", "" + this.speeds[i]});
                this.exec(new String[]{this.ffmpegPath, "-y", "-i", tmp2.getAbsolutePath(), "-ab", "" + this.bitrate, mp3output.getAbsolutePath()});
                tmp.delete();
                tmp2.delete();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exec(String[] args) {
        Runtime runtime = Runtime.getRuntime();
        try {
            int i = 0;
            while (i < args.length) {
                System.out.print("\"" + args[i] + "\" ");
                ++i;
            }
            Process process = runtime.exec(args);
            StreamMonitor monitor = new StreamMonitor(process);
            monitor.startMonitor();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String chompExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }
}

