/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.ui.draw2d.WaveFormFigureCanvas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;

public class WaveFormFigureCanvasAudioPlayer
implements AudioStopper {
    public static Log log = LogFactory.getLog(WaveFormFigureCanvasAudioPlayer.class);
    private WaveFormFigureCanvas waveFormFigureCanvas;
    private File audioFile;
    private WaveFormFigureCanvas.TimeSelection selection;
    private long duration;
    private JavaSoundAudioPlayer player;
    private boolean playMoveSelection;
    private boolean stopped = true;
    private Shell shell;

    public WaveFormFigureCanvasAudioPlayer(Shell shell, WaveFormFigureCanvas waveFormFigureCanvas) {
        this.shell = shell;
        this.waveFormFigureCanvas = waveFormFigureCanvas;
    }

    public void play() {
        if (this.audioFile == null) {
            log.info((Object)"audioFile is null");
            this.stop();
            return;
        }
        if (this.isPlayingAudio() || this.audioFile == null) {
            log.info((Object)"playing");
            this.stop();
            return;
        }
        try {
            WaveUtils.getAudioFormat((File)this.audioFile);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.selection = this.waveFormFigureCanvas.getSelection();
        if (this.selection == null || this.selection.getStart() == 0L && this.selection.getEnd() == 0L) {
            this.selection = new WaveFormFigureCanvas.TimeSelection(this.waveFormFigureCanvas.getCurrentRealValue(), this.waveFormFigureCanvas.getLastPosition());
        }
        log.info((Object)("selection: x=" + this.selection.getStart() + ",y=" + this.selection.getEnd()));
        long starttime = this.selection.getStart();
        long endtime = this.selection.getEnd();
        this.duration = endtime - starttime;
        log.warn((Object)("duration=" + this.duration + ",starttime=" + starttime + ",endtime=" + endtime));
        this.player = new JavaSoundAudioPlayer();
        this.player.setStopper((AudioStopper)this);
        this.player.setAudioListener((AudioListener)new AudioMove());
        Thread t = new Thread(new PlayingAction(this.audioFile, starttime, endtime));
        t.start();
    }

    public void stop() {
        log.trace((Object)"call stop");
        this.stopped = true;
        this.shell.getDisplay().asyncExec((Runnable)new AfterStoppedAction());
        this.playMoveSelection = false;
    }

    public boolean isPlayingAudio() {
        return !this.stopped;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean arg0) {
    }

    public File getAudioFile() {
        return this.audioFile;
    }

    public void setAudioFile(File audioFile) {
        this.audioFile = audioFile;
    }

    private class AfterStoppedAction
    implements Runnable {
        private AfterStoppedAction() {
        }

        public void run() {
        }
    }

    private class PlayingAction
    implements Runnable {
        private File file;
        private long start;
        private long end;

        public PlayingAction(File file, long start, long end) {
            this.file = file;
            this.start = start;
            this.end = end;
        }

        public void run() {
            if (WaveFormFigureCanvasAudioPlayer.this.stopped) {
                log.info((Object)("play-duration:" + (this.end - this.start)));
                WaveFormFigureCanvasAudioPlayer.this.stopped = false;
                try {
                    WaveFormFigureCanvasAudioPlayer.this.player.play(this.file, this.start, this.end);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
            WaveFormFigureCanvasAudioPlayer.this.stop();
        }
    }

    private class MovePositionAction
    implements Runnable {
        private long selection;

        public MovePositionAction(long selection) {
            this.selection = selection;
        }

        public void run() {
            WaveFormFigureCanvasAudioPlayer.this.waveFormFigureCanvas.moveCurrentPosition(this.selection);
        }
    }

    private class AudioMove
    implements AudioListener {
        private AudioMove() {
        }

        public void startPlaying() {
            WaveFormFigureCanvasAudioPlayer.this.playMoveSelection = true;
            WaveFormFigureCanvasAudioPlayer.this.shell.getDisplay().syncExec((Runnable)new MovePositionAction(WaveFormFigureCanvasAudioPlayer.this.selection.getStart()));
            log.info((Object)"start-playing");
            if (WaveFormFigureCanvasAudioPlayer.this.selection.getStart() == -1L) {
                WaveFormFigureCanvasAudioPlayer.this.selection.setStart(0L);
            }
            PlayMove move = new PlayMove(WaveFormFigureCanvasAudioPlayer.this.selection.getStart());
            Thread t = new Thread(move);
            t.start();
        }

        public void stopPlaying() {
            log.trace((Object)"stopplaying");
            WaveFormFigureCanvasAudioPlayer.this.stopped = true;
            WaveFormFigureCanvasAudioPlayer.this.playMoveSelection = false;
        }

        public void finishPlaying() {
            log.trace((Object)"finishplaying");
            WaveFormFigureCanvasAudioPlayer.this.stopped = true;
            WaveFormFigureCanvasAudioPlayer.this.playMoveSelection = false;
        }
    }

    private class PlayMove
    extends Thread {
        int sleeptime = 30;
        long startMillisecond;
        private boolean canceld = false;

        public PlayMove(long start) {
            this.startMillisecond = start;
        }

        public void cancel() {
            this.canceld = true;
        }

        public void run() {
            long start = System.currentTimeMillis();
            log.trace((Object)("playMoveSelection=" + WaveFormFigureCanvasAudioPlayer.this.playMoveSelection + "," + this.canceld));
            while (WaveFormFigureCanvasAudioPlayer.this.playMoveSelection && !this.canceld) {
                try {
                    Thread.sleep(this.sleeptime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long played = System.currentTimeMillis() - start;
                log.trace((Object)("played:" + played + ",duration=" + WaveFormFigureCanvasAudioPlayer.this.duration));
                if (played > WaveFormFigureCanvasAudioPlayer.this.duration) {
                    WaveFormFigureCanvasAudioPlayer.this.shell.getDisplay().syncExec((Runnable)new MovePositionAction(this.toPosition(WaveFormFigureCanvasAudioPlayer.this.duration)));
                    break;
                }
                WaveFormFigureCanvasAudioPlayer.this.shell.getDisplay().syncExec((Runnable)new MovePositionAction(this.toPosition(played)));
            }
        }

        public long toPosition(long time) {
            return this.startMillisecond + time;
        }
    }
}

