/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DefaultFFMpegMonitor;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingAction;
import jp.sourceforge.akjrcp.dropsomething.FFMpegDropSomethingTab;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.GenericParametersEditor;
import jp.sourceforge.akjrcp.ui.GenericParametersEditorDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersEventListener;
import jp.sourceforge.akjrcp.ui.GenericParametersFFMpegPreference;
import jp.sourceforge.akjrcp.ui.GenericParametersOptionEditor;
import jp.sourceforge.akjrcp.ui.GenericParametersSaveDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersTableViewer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFFMpegDropSomething
extends DirectoryBasedDropSomething
implements FFMpegDropSomethingTab {
    protected FileOverwriteControler fileOverwriteControler;
    public static final String AVISYNTH = "avisynth";
    protected GenericParametersFFMpegPreference preference;
    protected GenericParametersTableViewer tableViewer;
    protected GenericParametersOptionEditor editor;
    protected Button saveSetting;
    protected Button newSetting;
    protected FFMpegExecuter ffmpegExecuter;
    protected Label dragHere;
    protected Button avisynth;

    public AbstractFFMpegDropSomething(Composite parent, int style, String key) {
        super(parent, style, key);
    }

    public Composite createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout rootLayout = new GridLayout(1, true);
        rootLayout.marginHeight = 3;
        rootLayout.marginWidth = 5;
        composite.setLayout((Layout)rootLayout);
        Composite listComposite = new Composite(composite, 0);
        GridData listData = new GridData(1808);
        listComposite.setLayoutData((Object)listData);
        GridLayout listLayout = new GridLayout(2, false);
        listLayout.marginHeight = 0;
        listLayout.marginWidth = 0;
        listComposite.setLayout((Layout)listLayout);
        List list = GenericParametersTableViewer.loadList(this.getPreferenceStore().getString(String.valueOf(this.getPreferenceKey()) + "." + "settings_data"));
        GridData gd = new GridData(768);
        gd.heightHint = 60;
        this.tableViewer = new GenericParametersTableViewer(listComposite);
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.setGenericParametersList(list);
        this.tableViewer.addSelectionChangedListener(new SelectChanged());
        Composite buttons = new Composite(listComposite, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.newSetting = new Button(buttons, 0);
        this.newSetting.setText(Messages.getString("h264converter.new"));
        this.newSetting.addSelectionListener((SelectionListener)new GenericNew());
        this.saveSetting = new Button(buttons, 0);
        this.saveSetting.setText(Messages.getString("h264converter.save"));
        this.saveSetting.setEnabled(false);
        this.saveSetting.addSelectionListener((SelectionListener)new GenericSave());
        this.editor = this.makeGenericParameterOptionEditor();
        this.editor.createControls(composite);
        this.editor.addListener(new GenericParametersEventListener(){

            public void updateModified(boolean modified) {
                AbstractFFMpegDropSomething.this.saveSetting.setEnabled(modified);
            }
        });
        this.updateStatus();
        Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceStoreMonitor());
        int defaultSelect = this.getPreferenceStore().getInt(String.valueOf(this.getPreferenceKey()) + "settings_selection_index");
        log.info((Object)("defaultSelect:" + defaultSelect));
        if (this.tableViewer.getTable().getItemCount() > defaultSelect) {
            this.tableViewer.getTable().setSelection(Math.max(0, defaultSelect));
        } else if (this.tableViewer.getTable().getItemCount() > 0) {
            this.tableViewer.getTable().setSelection(0);
        } else {
            log.info((Object)"item is empty");
        }
        this.tableSelectionChanged();
        this.tableViewer.addSelectionChangedListener(new StoreSelect());
        return composite;
    }

    public void tableSelectionChanged() {
        GenericParameters parameters;
        this.saveSetting.setEnabled(false);
        int selection = this.tableViewer.getTable().getSelectionIndex();
        if (selection >= 0) {
            log.info((Object)("table item changed:" + selection));
            parameters = (GenericParameters)this.tableViewer.getTable().getItem(this.tableViewer.getTable().getSelectionIndex()).getData();
        } else {
            parameters = this.makeDefaultGenericParameters();
        }
        Map<String, String> map = parameters.getParameters();
        this.editor.setParameters(map);
        this.saveSetting.setEnabled(false);
    }

    public abstract GenericParameters makeDefaultGenericParameters();

    public abstract GenericParametersOptionEditor makeGenericParameterOptionEditor();

    public void restoreControl(Control control) {
        IPreferenceStore store = this.getPreferenceStore();
        if (control == this.avisynth) {
            this.avisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + AVISYNTH));
        }
    }

    public void selectCombo(CCombo combo, String value) {
        int s = combo.getItemCount();
        int i = 0;
        while (i < s) {
            if (combo.getItem(i).equals(value)) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public void storeControl(Control control) {
        IPreferenceStore store = this.getPreferenceStore();
        if (control == this.avisynth) {
            store.setValue(String.valueOf(this.getPreferenceKey()) + "." + AVISYNTH, this.avisynth.getSelection());
        }
    }

    public String toTime(long bps, long maxMega) {
        String sstring;
        String mstring;
        long bytes = bps / 8L;
        long second = maxMega * 1024L * 1024L / bytes;
        long hour = second / 3600L;
        long min = (second %= 3600L) / 60L;
        long sec = second % 60L;
        String hstring = "" + hour;
        if (hstring.length() < 2) {
            hstring = "0" + hstring;
        }
        if ((mstring = "" + min).length() < 2) {
            mstring = "0" + mstring;
        }
        if ((sstring = "" + sec).length() < 2) {
            sstring = "0" + sstring;
        }
        return String.valueOf(hstring) + ":" + mstring + ":" + sstring;
    }

    public void inconvert(File file) {
        this.ffmpegExecuter.execute(new File[]{file});
    }

    public void updateSettingTable() {
        List list = GenericParametersTableViewer.loadList(Akj_betasPlugin.getDefault().getPreferenceStore().getString(String.valueOf(this.getPreferenceKey()) + "." + "settings_data"));
        this.tableViewer.setGenericParametersList(list);
        if (this.tableViewer.getTable().getItemCount() > 0) {
            this.tableViewer.getTable().setSelection(0);
            this.tableSelectionChanged();
        }
    }

    public void afterConvert() {
    }

    public boolean isCanConvert() {
        String ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
        if (!FFMpegUI.isFFMpegOrPureFFMpegAvailable(ffmpegPath)) {
            this.setCantConvertStatusbarMessage(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
            return false;
        }
        return super.isCanConvert();
    }

    public void cancelConvert() {
        this.ffmpegExecuter.cancel();
    }

    public void updateStatus() {
        if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
            this.setMessage(Messages.getString("dropsomething.drag_folder"));
            this.setCanConvert(true);
        } else {
            this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
            this.setCantConvertStatusbarMessage(Messages.getString("dropsomething.choose_folder"));
            this.setCanConvert(false);
        }
    }

    public void setMessage(String text) {
        if (this.dragHere != null) {
            this.dragHere.setForeground(new Color(null, 64, 255, 64));
            this.dragHere.setText(text);
        }
    }

    public void setErrorMessage(String text) {
        if (this.dragHere != null) {
            this.dragHere.setForeground(new Color(null, 255, 0, 0));
            this.dragHere.setText(text);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return Akj_betasPlugin.getDefault().getPreferenceStore();
    }

    public boolean setFocus() {
        return this.tableViewer.getTable().setFocus();
    }

    public FFMpegExecuter getFFMpegExecuter() {
        return this.ffmpegExecuter;
    }

    public FileOverwriteControler getFileOverWriteControler() {
        if (this.fileOverwriteControler == null) {
            this.fileOverwriteControler = new FileOverwriteControler(this.getViewPart().getViewSite().getShell());
        }
        return this.fileOverwriteControler;
    }

    public void beforeConvert() {
        this.ffmpegExecuter = new FFMpegExecuter();
        Map newMap = this.editor.getParameters();
        GenericParameters setting = new GenericParameters(newMap);
        GenericParameters baseGeneric = null;
        int selection = this.tableViewer.getTable().getSelectionIndex();
        baseGeneric = selection >= 0 ? (GenericParameters)this.tableViewer.getTable().getItem(this.tableViewer.getTable().getSelectionIndex()).getData() : new GenericParameters();
        this.preference = new GenericParametersFFMpegPreference(setting);
        String ffmpegPath = FFMpegUI.getFFmpeg();
        if (ffmpegPath == null) {
            ffmpegPath = FFMpegUI.getPureFFmpeg();
        } else if (FFMpegUI.getPureFFmpeg() != null && FFMpegUI.isUsePureFFMpeg()) {
            String ac = this.preference.getAudioCodec();
            String vc = this.preference.getVideoCodec();
            if (ac == null) {
                ac = FFMpegUtils.getDefaultAudioCodec(this.preference.getFormat(), this.preference.getExtension());
            }
            if (vc == null) {
                vc = FFMpegUtils.getDefaultVideoCodec(this.preference.getFormat(), this.preference.getExtension());
            }
            if (FFMpegUtils.isAudioOnlyExtension(this.preference.getExtension())) {
                log.info((Object)"audio only");
                if (FFMpegUI.isPureFFMpegSupportedAudioCodec(ac)) {
                    ffmpegPath = FFMpegUI.getPureFFmpeg();
                    log.info((Object)"use pure_ffmpeg");
                }
            } else if (!this.preference.isEnableAudio()) {
                log.info((Object)"video only");
                if (vc != null && FFMpegUI.isPureFFMpegSupportedVideoCodec(vc) && FFMpegUI.getPureFFmpeg() != null) {
                    ffmpegPath = FFMpegUI.getPureFFmpeg();
                    log.info((Object)"use pure_ffmpeg");
                }
            } else {
                log.info((Object)"audio and video");
                if (ac != null && FFMpegUI.isPureFFMpegSupportedAudioCodec(ac) && vc != null && FFMpegUI.isPureFFMpegSupportedVideoCodec(vc) && FFMpegUI.getPureFFmpeg() != null) {
                    ffmpegPath = FFMpegUI.getPureFFmpeg();
                    log.info((Object)"use pure_ffmpeg");
                }
            }
        }
        this.preference.setFfmpegPath(ffmpegPath);
        log.info((Object)this.preference);
        this.setHeaderText(this.tableViewer.toLabel(baseGeneric));
        DefaultFFMpegMonitor monitor = new DefaultFFMpegMonitor(this, this.getPreferenceKey());
        String after_action = setting.getParameters().get("AFTER_ACTION");
        if (after_action != null && !after_action.equals("")) {
            try {
                DropsomethingAction action = (DropsomethingAction)Class.forName(after_action).newInstance();
                monitor.setAfterAction(action);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.ffmpegExecuter.setExecuteListener(monitor);
        boolean threads = FFMpegUI.isUseThread();
        if (threads && ("h264".equals(this.preference.getVideoCodec()) || "libx264".equals(this.preference.getVideoCodec()))) {
            this.preference.setThreads(2);
        }
        this.ffmpegExecuter.setFfmpegPreference(this.preference);
        this.ffmpegExecuter.setUseAvisynth(this.avisynth.getSelection());
        this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
        this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
        this.ffmpegExecuter.setBackup(this.backup.getSelection());
        if (!this.samefolder.getSelection()) {
            this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
        }
    }

    public class SelectChanged
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            AbstractFFMpegDropSomething.this.tableSelectionChanged();
        }
    }

    public class GenericNew
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            GenericParametersEditorDialog dialog = new GenericParametersEditorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            int result = dialog.open();
            if (result == 0) {
                GenericParameters newed = AbstractFFMpegDropSomething.this.makeDefaultGenericParameters();
                newed.setName(dialog.getName());
                newed.setComment(dialog.getComment());
                AbstractFFMpegDropSomething.this.tableViewer.getGenericParameters().add(newed);
                AbstractFFMpegDropSomething.this.tableViewer.refresh();
                GenericParameters[] infos = AbstractFFMpegDropSomething.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                String newValue = GenericParametersEditor.toStoreString(infos);
                AbstractFFMpegDropSomething.this.getPreferenceStore().setValue("FFMpegConvert.settings_data", newValue);
                AbstractFFMpegDropSomething.this.tableViewer.getTable().setSelection(AbstractFFMpegDropSomething.this.tableViewer.getTable().getItemCount() - 1);
                AbstractFFMpegDropSomething.this.tableSelectionChanged();
            } else {
                log.info((Object)result);
            }
        }
    }

    public class GenericSave
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            GenericParameters parameter = AbstractFFMpegDropSomething.this.tableViewer.getCurrentSelection();
            GenericParametersSaveDialog dialog = new GenericParametersSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            String oldName = parameter.getName();
            if (parameter == null) {
                dialog.setName(Messages.getString("dropsomething.newsetting"));
            } else {
                String newName = AbstractFFMpegDropSomething.this.tableViewer.copiedName(parameter);
                dialog.setName(newName);
                dialog.setComment(parameter.getComment());
            }
            int ret = dialog.open();
            if (ret == 0) {
                int selection;
                log.info((Object)("Save:" + dialog.isSaveOverwrite()));
                Map newMap = AbstractFFMpegDropSomething.this.editor.getParameters();
                if (dialog.isSaveOverwrite()) {
                    parameter.setParameters(newMap);
                    parameter.setName(oldName);
                    parameter.setComment(dialog.getComment());
                    selection = AbstractFFMpegDropSomething.this.tableViewer.getTable().getSelectionIndex();
                } else {
                    GenericParameters newParam = new GenericParameters(newMap);
                    newParam.setName(dialog.getName());
                    newParam.setComment(dialog.getComment());
                    AbstractFFMpegDropSomething.this.tableViewer.getGenericParameters().add(newParam);
                    AbstractFFMpegDropSomething.this.tableViewer.refresh();
                    selection = AbstractFFMpegDropSomething.this.tableViewer.getTable().getItemCount() - 1;
                }
                GenericParameters[] infos = AbstractFFMpegDropSomething.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                String newValue = GenericParametersEditor.toStoreString(infos);
                AbstractFFMpegDropSomething.this.getPreferenceStore().setValue("FFMpegConvert.settings_data", newValue);
                AbstractFFMpegDropSomething.this.tableViewer.getTable().setSelection(selection);
                AbstractFFMpegDropSomething.this.tableSelectionChanged();
            }
        }
    }

    public class StoreSelect
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            AbstractFFMpegDropSomething.this.getPreferenceStore().setValue(String.valueOf(AbstractFFMpegDropSomething.this.getPreferenceKey()) + "settings_selection_index", AbstractFFMpegDropSomething.this.tableViewer.getTable().getSelectionIndex());
        }
    }

    public class SavePreferenceStore
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractFFMpegDropSomething.this.storeControl((Control)e.getSource());
        }
    }

    public class PreferenceStoreMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals(String.valueOf(AbstractFFMpegDropSomething.this.getPreferenceKey()) + "." + "settings_data")) {
                AbstractFFMpegDropSomething.this.updateSettingTable();
            }
        }
    }
}

