/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;

public class CachedFFMpegFileInfomationParser {
    private Map<String, Data> map = new HashMap<String, Data>();
    private FFMpegFLVParser parser;

    public FFMpegFileInfomation parseFileInfomation(String path) {
        return this.parseFileInfomation(new File(path));
    }

    public CachedFFMpegFileInfomationParser(String ffmpegPath) {
        this.parser = new FFMpegFLVParser(ffmpegPath);
    }

    public FFMpegFileInfomation parseFileInfomation(File file) {
        Data data = this.map.get(file.getAbsolutePath());
        if (data != null && data.isSameFile(file)) {
            return data.getFileInfomation();
        }
        FLVInfomation info = this.parser.parseFile(file);
        data = new Data(file, info);
        this.map.put(file.getAbsolutePath(), data);
        return info;
    }

    private class Data {
        private long lastmodified;
        private long length;
        private FFMpegFileInfomation fileInfomation;
        private String path;

        public Data(File file, FFMpegFileInfomation fileInfomation) {
            this.fileInfomation = fileInfomation;
            this.length = file.length();
            this.lastmodified = file.lastModified();
            this.path = file.getAbsolutePath();
        }

        public FFMpegFileInfomation getFileInfomation() {
            return this.fileInfomation;
        }

        public void setFileInfomation(FFMpegFileInfomation fileInfomation) {
            this.fileInfomation = fileInfomation;
        }

        public long getLastmodified() {
            return this.lastmodified;
        }

        public void setLastmodified(long lastmodifie) {
            this.lastmodified = lastmodifie;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isSameFile(File file) {
            if (!file.getAbsolutePath().equals(this.path)) {
                return false;
            }
            return file.lastModified() == this.lastmodified && this.length == file.length();
        }
    }
}

