/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.IOException;
import java.io.PrintWriter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.PCMPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.util.PrintStreamProcessPrinter;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegPCMPipeReader
implements Runnable {
    public static Log log = LogFactory.getLog(FFMpegPCMPipeReader.class);
    PCMPipeReader wavPipeReader;
    private String[] command;
    private Process process;
    ProcessListener processListener;

    public FFMpegPCMPipeReader(String ffmpegPath, String inputPath, int rate, int channel) {
        this.command = FFMpegCommandUtil.makePCMOutputPipeCommand(ffmpegPath, inputPath, rate, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.command);
            String c = "";
            int i = 0;
            while (i < this.command.length) {
                c = String.valueOf(c) + "\"" + this.command[i] + "\"" + " ";
                ++i;
            }
            log.info((Object)("command:" + c));
            PrintStreamProcessPrinter printer = new PrintStreamProcessPrinter(new PrintWriter(System.out));
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.setMonitorInput(false);
            monitor.startMonitor();
            this.wavPipeReader = new PCMPipeReader(this.process.getInputStream());
            if (this.processListener != null) {
                this.processListener.started();
            }
            try {
                this.process.waitFor();
                FFMpegPCMPipeReader fFMpegPCMPipeReader = this;
                synchronized (fFMpegPCMPipeReader) {
                    this.wavPipeReader.setDone(true);
                }
                if (this.processListener != null) {
                    this.processListener.finished();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void close() throws IOException {
        if (this.wavPipeReader != null) {
            this.wavPipeReader.close();
        }
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public ProcessListener getProcessListener() {
        return this.processListener;
    }

    public void setProcessListener(ProcessListener processListener) {
        this.processListener = processListener;
    }

    public PCMPipeReader getPCMPipeReader() {
        return this.wavPipeReader;
    }
}

