/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import jp.sourceforge.akjrcp.audio.MpegAudioFormatUtil;
import jp.sourceforge.akjrcp.ffmpeg.AdvancedAudioFFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MP3FFMpegPreference
extends AdvancedAudioFFMpegPreference {
    public static Log log = LogFactory.getLog(MP3FFMpegPreference.class);

    public String[] toCommand(FFMpegInput[] inputs, String output) {
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        String path = inputs[inputs.length - 1].getPath();
        int i = inputs.length - 1;
        while (i >= 0) {
            FLVInfomation info = parser.parseFile(new File(inputs[i].getPath()));
            if (info.isHaveAudio()) {
                path = inputs[i].getPath();
                break;
            }
            --i;
        }
        return this.customToCommand(path, null, output);
    }

    public String[] customToCommand(String input, String avsInput, String output) {
        int bitrate;
        int inputFramerate;
        String inputType = PathnameUtils.getExtension(input);
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        this.setEnableVideo(false);
        FLVInfomation info = parser.parseFile(new File(input));
        if (!info.isHaveAudio()) {
            if (avsInput == null) {
                log.warn((Object)"no aduio stream");
                return null;
            }
            info = parser.parseFile(new File(avsInput));
            if (!info.isHaveAudio()) {
                log.warn((Object)"no aduio stream even in avs");
                return null;
            }
        }
        String inputCodec = info.getAudioCodec();
        int inputChannel = info.getAudioChannel();
        if (inputChannel == 0) {
            log.info((Object)"input channel must not 0");
        }
        if ((inputFramerate = info.getAudioRate()) == 0) {
            log.info((Object)"input inputFramerate must not 0");
        }
        if ((bitrate = info.getAudioBitrate()) == 0) {
            log.warn((Object)"input bitrate must not 0");
            bitrate = this.getDefaultBitrate();
        }
        if (inputChannel == 0 || inputFramerate == 0) {
            if (avsInput != null) {
                info = parser.parseFile(new File(avsInput));
                inputChannel = info.getAudioChannel();
                if (inputChannel == 0) {
                    log.warn((Object)"inputAvs channel must not 0");
                    return null;
                }
                inputFramerate = info.getAudioRate();
                if (inputFramerate == 0) {
                    log.warn((Object)"inputAvs inputFramerate must not 0");
                    return null;
                }
            } else {
                log.warn((Object)(String.valueOf(inputChannel) + "," + inputFramerate + " there are no avs and not supported codec"));
                return null;
            }
        }
        if (this.isForceConvert()) {
            this.setAudioCodec("mp3");
            int tmpFramerate = this.getConvertFramerate() == -1 ? inputFramerate : this.getConvertFramerate();
            this.setAudioRate(tmpFramerate);
            int[] supportedBitrate = MpegAudioFormatUtil.getAvailableMP3Bitrate(inputFramerate);
            int tmpBitrate = this.getConvertBitrate() == -1 ? MpegAudioFormatUtil.getSimilarValue(supportedBitrate, bitrate) : MpegAudioFormatUtil.getSimilarValue(supportedBitrate, this.getConvertBitrate());
            this.setAudioBitrate(tmpBitrate);
            int tmpChannel = this.getConvertChannel() == -1 ? inputChannel : this.getConvertChannel();
            this.setAudioChannel(tmpChannel);
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), tmpBitrate));
        } else if (this.isUseCopy() && (inputCodec.equals("mp3") || inputCodec.equals("0x0055"))) {
            this.setAudioCodec("copy");
            avsInput = null;
            int audioB = info.getAudioBitrate();
            if (audioB == 0) {
                audioB = 128;
            }
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), audioB));
        } else {
            this.setAudioCodec("mp3");
            this.setAudioRate(inputFramerate);
            int[] supportedBitrate = MpegAudioFormatUtil.getAvailableMP3Bitrate(inputFramerate);
            int tmpBitrate = this.isCanUseBitrate(inputType) ? MpegAudioFormatUtil.getSimilarValue(supportedBitrate, bitrate) : MpegAudioFormatUtil.getSimilarValue(supportedBitrate, this.getDefaultBitrate());
            this.setAudioBitrate(tmpBitrate);
            this.setAudioChannel(inputChannel);
            this.setGuessSize(MP3FFMpegPreference.toKBytes(info.getDuration(), tmpBitrate));
        }
        if (input == null || output == null) {
            return null;
        }
        FFMpegInput[] inputs = new FFMpegInput[]{avsInput == null ? new FFMpegInput(input) : new FFMpegInput(avsInput)};
        return super.toCommand(inputs, output);
    }
}

