/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp;

import java.io.File;

public class PSPUtils {
    public static final String DIR_PSP = "VIDEO";
    public static final String DIR_VIDEO = "VIDEO";
    public static final String DIR_PICTURE = "PICTURE";
    public static final String DIR_MUSIC = "MUSIC";

    public static File findPSPDrive() {
        File[] roots = File.listRoots();
        int i = roots.length - 1;
        while (i > 0) {
            File tmp = new File(roots[i], "VIDEO");
            if (tmp.exists() && tmp.isDirectory()) {
                return tmp.getParentFile();
            }
            --i;
        }
        return null;
    }

    public static File findVideoFolder() {
        File dir;
        File root = PSPUtils.findPSPDrive();
        if (root != null && (dir = new File(root, "VIDEO")).exists()) {
            return dir;
        }
        return null;
    }

    public static File findPictureFolder() {
        File dir;
        File root = PSPUtils.findPSPDrive();
        if (root != null && (dir = new File(root, DIR_PICTURE)).exists()) {
            return dir;
        }
        return null;
    }

    public static File findMusicFolder() {
        File dir;
        File root = PSPUtils.findPSPDrive();
        if (root != null && (dir = new File(root, DIR_MUSIC)).exists()) {
            return dir;
        }
        return null;
    }

    public static boolean existVideoFolder(File pspDrive) {
        File videoFolder = new File(pspDrive, "VIDEO");
        return videoFolder.exists();
    }

    public static boolean existPictureFolder(File pspDrive) {
        File videoFolder = new File(pspDrive, DIR_PICTURE);
        return videoFolder.exists();
    }

    public static boolean existMusicFolder(File pspDrive) {
        File videoFolder = new File(pspDrive, DIR_MUSIC);
        return videoFolder.exists();
    }
}

