/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.imageconvert;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.psp.imageconvert.AbstractImageChanger;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageTurner
extends AbstractImageChanger {
    public static Log log = LogFactory.getLog(ImageTurner.class);
    public static final int TURN_RIGHT = 0;
    public static final int TURN_LEFT = 1;
    private int turnMode;

    public ImageTurner() {
        this.time = System.currentTimeMillis();
    }

    public void changeImage(String imageFileName, InputStream imageInput, File exportDir) throws IOException {
        if (this.cancel) {
            return;
        }
        BufferedImage baseImage = this.imageLoader.loadImage(imageFileName, imageInput);
        BufferedImage argb = this.toARGB(baseImage);
        baseImage.getGraphics().dispose();
        BufferedImage fit = ImageUtils.fitImage(argb, this.height, this.width);
        argb.getGraphics().dispose();
        BufferedImage turnnedImage = this.turnImage(fit);
        fit.getGraphics().dispose();
        BufferedImage rgb = this.toRGB(turnnedImage);
        turnnedImage.getGraphics().dispose();
        this.saveImage(rgb, imageFileName, exportDir);
        rgb.getGraphics().dispose();
        System.gc();
    }

    public BufferedImage turnImage(BufferedImage img) {
        log.info((Object)(String.valueOf(img.getWidth()) + "," + img.getHeight()));
        BufferedImage ret = new BufferedImage(img.getHeight(), img.getWidth(), 2);
        Graphics2D g2 = (Graphics2D)ret.getGraphics();
        AffineTransform af = new AffineTransform();
        if (this.turnMode == 0) {
            af.setToTranslation(img.getHeight(), 0.0);
            af.rotate(1.5707963267948966);
        } else {
            af.setToTranslation(0.0, img.getWidth());
            af.rotate(4.71238898038469);
        }
        g2.setTransform(af);
        g2.drawImage((Image)img, 0, 0, null);
        return ret;
    }

    public int getTurnMode() {
        return this.turnMode;
    }

    public void setTurnMode(int turnMode) {
        this.turnMode = turnMode;
    }
}

