/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.snack.PitchExecuter;
import jp.sourceforge.akjrcp.ui.draw2d.GraphLabelProvider;
import jp.sourceforge.akjrcp.ui.draw2d.SimpleGraphMemoryPainterDraw2D;
import jp.sourceforge.akjrcp.ui.draw2d.TimeBasedFigure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class PitchViewFigure
extends TimeBasedFigure {
    public static Log log = LogFactory.getLog(PitchViewFigure.class);
    private int dotSize = 4;
    private int offsetY = 0;
    private int offsetX = -this.dotSize;
    private RGB lineColor = ColorConstants.cyan.getRGB();
    private ESPS[] espses;
    private double espsStarted = PitchExecuter.SKIPPED_TIME;
    private double espsTime;
    private int maxPitch = 2400;
    private int minPitch = 0;
    private int canvasHeight = 512;
    private int marginBottom = 0;
    private int marginTop = 128;

    public double getEspsStarted() {
        return this.espsStarted;
    }

    public void setEspsStarted(double espsStarted) {
        this.espsStarted = espsStarted;
    }

    public double getEspsTime() {
        return this.espsTime;
    }

    public void setEspsTime(double espsTime) {
        this.espsTime = espsTime;
    }

    public PitchViewFigure(int arg0, int arg1, double splitFrame) {
        super(arg0, arg1, splitFrame);
        this.setLayoutManager((LayoutManager)new StackLayout());
    }

    public void updateScale() {
    }

    public int calculatePitchToY(double pitch) {
        double per = (double)this.canvasHeight / (double)this.maxPitch;
        return this.getClientArea().height - this.marginBottom - (int)(per * (pitch - (double)this.minPitch));
    }

    public void paintFigure(Graphics g) {
        if (this.espses != null) {
            double time = this.espsStarted;
            g.setForegroundColor(new Color(null, this.lineColor));
            int scrolled = this.getParent().getBounds().x;
            int i = 0;
            while (i < this.espses.length) {
                ESPS esps = this.espses[i];
                if (esps.getPitch() > (double)this.minPitch && esps.getPitch() < (double)this.maxPitch) {
                    int dx = this.calculateTimeToX(time);
                    int dy = this.calculatePitchToY(esps.getPitch());
                    g.drawRectangle(scrolled + dx - this.dotSize / 2, dy - this.dotSize / 2, this.dotSize, this.dotSize);
                }
                time += this.espsTime;
                ++i;
            }
        }
    }

    public RGB getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(RGB lineColor) {
        this.lineColor = lineColor;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public ESPS[] getEspses() {
        return this.espses;
    }

    public void setEspses(ESPS[] espses) {
        this.espses = espses;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int maxPitch) {
        this.maxPitch = maxPitch;
    }

    public static class PitchMemoryFigure
    extends Figure {
        private int graphGrid = 100;
        private int maxPitch = 2400;
        private int minPitch = 0;
        private SimpleGraphMemoryPainterDraw2D painter = new SimpleGraphMemoryPainterDraw2D();

        public PitchMemoryFigure() {
            this.painter.setVerticalGraph(true);
            this.painter.setGraphPlus(false);
            this.painter.setGridPlus(true);
            this.painter.setLabelProvider(new LabelProvider());
            this.painter.setLineColor(ColorConstants.gray);
        }

        public void paintFigure(Graphics g) {
            g.clipRect(new Rectangle(0, 40, this.getClientArea().width, this.getClientArea().height));
            int dh = 512;
            int step = (this.maxPitch - this.minPitch) / this.graphGrid;
            this.painter.setPerMain((double)dh / (double)step);
            this.painter.draw(g, this.getClientArea().x, this.getClientArea().y + this.getClientArea().height, dh);
        }

        public SimpleGraphMemoryPainterDraw2D getPainter() {
            return this.painter;
        }

        public void setPainter(SimpleGraphMemoryPainterDraw2D painter) {
            this.painter = painter;
        }

        public int getMaxPitch() {
            return this.maxPitch;
        }

        public void setMaxPitch(int maxPitch) {
            this.maxPitch = maxPitch;
        }
    }

    public static class LabelProvider
    implements GraphLabelProvider {
        public String getLabel(SimpleGraphMemoryPainterDraw2D painter, int index) {
            String v = "" + index;
            if (v.length() < 2) {
                v = "0" + v;
            }
            if (v.equals("01") || v.equals("10") || v.equals("20")) {
                v = String.valueOf(v) + " khz";
            }
            return v;
        }
    }
}

