/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.ui.draw2d.Zoom;
import jp.sourceforge.akjrcp.ui.draw2d.ZoomChangeListener;

public class DefaultZoom
implements Zoom {
    double[] zoomValues = new double[]{0.0625, 0.125, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0};
    int index = 4;
    int preIndex;
    List zoomListener = new ArrayList();
    boolean wrap;

    public void addZoomChangeListener(ZoomChangeListener listener) {
        this.zoomListener.add(listener);
    }

    public void removeZoomChangeListener(ZoomChangeListener listener) {
        this.zoomListener.remove(listener);
    }

    public void fireZoomUp() {
        ZoomChangeListener[] listener = this.getListeners();
        int i = 0;
        while (i < listener.length) {
            listener[i].zoomUp(this);
            ++i;
        }
    }

    public void fireZoomDown() {
        ZoomChangeListener[] listener = this.getListeners();
        int i = 0;
        while (i < listener.length) {
            listener[i].zoomDown(this);
            ++i;
        }
    }

    public void fireZoomChange() {
        ZoomChangeListener[] listener = this.getListeners();
        int i = 0;
        while (i < listener.length) {
            listener[i].zoomChange(this);
            ++i;
        }
    }

    public synchronized ZoomChangeListener[] getListeners() {
        return this.zoomListener.toArray(new ZoomChangeListener[this.zoomListener.size()]);
    }

    public int getZoomIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public int getPreIndex() {
        return this.preIndex;
    }

    public void setPreIndex(int preIndex) {
        this.preIndex = preIndex;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public double getZoom() {
        return this.zoomValues[this.index];
    }

    public void zoomUp() {
        if (this.index + 1 < this.zoomValues.length) {
            this.setZoomIndex(this.index + 1);
            this.fireZoomUp();
        } else if (this.wrap) {
            this.setZoomIndex(0);
            this.fireZoomDown();
        }
    }

    public void setZoomIndex(int value) {
        this.preIndex = this.index;
        this.index = value;
        this.fireZoomChange();
    }

    public void zoomDown() {
        if (this.index > 0) {
            this.setZoomIndex(this.index - 1);
            this.fireZoomDown();
        } else if (this.wrap) {
            this.setZoomIndex(this.index - 1);
            this.fireZoomUp();
        }
    }

    public double getZoomValue(int index) {
        return this.zoomValues[index];
    }

    public int countZooms() {
        return this.zoomValues.length;
    }

    public double[] getZooms() {
        return this.zoomValues;
    }

    public void setZooms(double[] zooms) {
        this.zoomValues = zooms;
    }
}

