/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.util.ArrayList;

public class JapaneseUtils {
    public static final char HIRAGANA_SMALL_A = '\u3041';
    public static final char HIRAGANA_SMALL_I = '\u3043';
    public static final char HIRAGANA_SMALL_U = '\u3045';
    public static final char HIRAGANA_SMALL_E = '\u3047';
    public static final char HIRAGANA_SMALL_O = '\u3049';
    public static final char HIRAGANA_SMALL_TU = '\u3063';
    public static final char HIRAGANA_SMALL_YA = '\u3083';
    public static final char HIRAGANA_SMALL_YU = '\u3085';
    public static final char HIRAGANA_SMALL_YO = '\u3087';
    public static final char KATAKANA_SMALL_A = '\uff71';
    public static final char KATAKANA_SMALL_I = '\uff72';
    public static final char KATAKANA_SMALL_U = '\uff73';
    public static final char KATAKANA_SMALL_E = '\uff74';
    public static final char KATAKANA_SMALL_O = '\uff75';
    public static final char KATAKANA_SMALL_TU = '\u30c3';
    public static final char KATAKANA_SMALL_YA = '\u30e3';
    public static final char KATAKANA_SMALL_YU = '\u30e5';
    public static final char KATAKANA_SMALL_YO = '\u30e7';
    public static final char[] HAS_SMALL = new char[]{'\u3044', '\u3046', '\u304d', '\u3057', '\u3059', '\u3061', '\u3064', '\u306b', '\u3072', '\u3075', '\u307f', '\u308a', '\u304e', '\u3058', '\u305a', '\u3067', '\u3073', '\u3074'};

    public static boolean isSmallCharacter(char ch) {
        return JapaneseUtils.isSmallHiragana(ch) || JapaneseUtils.isSmallKatakana(ch);
    }

    public static boolean hasSmallCharacter(char parent, char small) {
        if (small == '\u3063' || small == '\u30c3') {
            return true;
        }
        int i = 0;
        while (i < HAS_SMALL.length) {
            if (HAS_SMALL[i] == parent) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] splitSmallCharacter(String text) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < text.length()) {
            String value = "" + text.charAt(i);
            if (i < text.length() - 1 && JapaneseUtils.isSmallCharacter(text.charAt(i + 1)) && JapaneseUtils.hasSmallCharacter(text.charAt(i), text.charAt(i + 1))) {
                value = String.valueOf(value) + text.charAt(i + 1);
                ++i;
            }
            arrayList.add(value);
            ++i;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isSmallKatakana(char ch) {
        if ('\uff71' == ch) {
            return true;
        }
        if ('\uff72' == ch) {
            return true;
        }
        if ('\uff73' == ch) {
            return true;
        }
        if ('\uff74' == ch) {
            return true;
        }
        if ('\uff75' == ch) {
            return true;
        }
        if ('\u30c3' == ch) {
            return true;
        }
        if ('\u30e3' == ch) {
            return true;
        }
        if ('\u30e5' == ch) {
            return true;
        }
        return '\u30e7' == ch;
    }

    public static boolean isSmallHiragana(char ch) {
        if ('\u3041' == ch) {
            return true;
        }
        if ('\u3043' == ch) {
            return true;
        }
        if ('\u3045' == ch) {
            return true;
        }
        if ('\u3047' == ch) {
            return true;
        }
        if ('\u3049' == ch) {
            return true;
        }
        if ('\u3063' == ch) {
            return true;
        }
        if ('\u3083' == ch) {
            return true;
        }
        if ('\u3085' == ch) {
            return true;
        }
        return '\u3087' == ch;
    }
}

