/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.net.URL;

public class PathnameUtils {
    private PathnameUtils() {
    }

    public static String changeExtension(String filename, String newExtension) {
        return String.valueOf(PathnameUtils.removeExtension(filename)) + "." + newExtension;
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getFileName(String filepath) {
        return PathnameUtils.getFileName(filepath, File.separatorChar);
    }

    public static String getFileName(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getParentPath(String filepath) {
        return PathnameUtils.getParentPath(filepath, File.separatorChar);
    }

    public static String getParentPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static boolean isAbsolutePath(String path) {
        if (path.length() < 1) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        return PathnameUtils.isWindowsRootPath(path);
    }

    public static boolean isUpperAndLowerAToZ(char ch) {
        char s = ch;
        return s >= 'A' && s <= 'Z' || s >= 'a' && s <= 'z';
    }

    public static boolean isWindowsRootPath(String path) {
        if (path.length() < 3) {
            return false;
        }
        return PathnameUtils.isUpperAndLowerAToZ(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '\\';
    }

    public static String createPath(String path1, String path2) {
        String fileName;
        String basePath = PathnameUtils.fixBasePath(path1);
        String resultPath = null;
        if (PathnameUtils.isWindowsRootPath(path2)) {
            return path2;
        }
        if (path1.indexOf("/") != -1) {
            resultPath = PathnameUtils.catPath(basePath, path2);
        } else if (path1.indexOf("\\") != -1) {
            String tmpPath1 = path1.replaceAll("\\\\", "/");
            resultPath = PathnameUtils.catPath(tmpPath1, path2);
            resultPath = resultPath.replaceAll("/", "\\\\");
        } else {
            resultPath = path2;
        }
        resultPath = resultPath == null ? ((fileName = PathnameUtils.getFileName(path2, '/')) != null ? "/" + fileName : "/") : PathnameUtils.fixBasePath(resultPath);
        return PathnameUtils.normalize(resultPath);
    }

    public static String getRemainPath(String basePath, String newPath) {
        String ret = newPath;
        if (newPath.startsWith(basePath) && ((ret = newPath.substring(basePath.length())).startsWith("\\") || ret.startsWith("/"))) {
            ret = ret.substring(1);
        }
        return ret;
    }

    private static String fixBasePath(String path) {
        String result = path;
        while (true) {
            int skip = 0;
            if (result.startsWith("../")) {
                skip = 3;
            } else if (result.startsWith("./")) {
                skip = 2;
            }
            if (skip == 0) break;
            result = result.substring(skip);
        }
        if (path.equals(result)) {
            return path;
        }
        return "/" + result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String catPath(String lookupPath, String path) {
        String result = null;
        try {
            int index = lookupPath.lastIndexOf("/");
            String lookup = lookupPath.substring(0, index);
            String pth = path;
            while (true) {
                if (!pth.startsWith("../")) {
                    return new StringBuffer(lookup).append("/").append(pth).toString();
                }
                if (lookup.length() <= 0) return null;
                index = lookup.lastIndexOf("/");
                lookup = lookup.substring(0, index);
                index = pth.indexOf("../") + 3;
                pth = pth.substring(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static File searchFileAroundClass(Class classObject, String fileName) {
        ClassLoader loader = classObject.getClassLoader();
        String path = classObject.getName().replaceAll("\\.", "/");
        URL url = loader.getResource(path = String.valueOf(path) + ".class");
        String classPath = url.toString();
        if (classPath.startsWith("jar:")) {
            int last = classPath.lastIndexOf("!");
            classPath = classPath.substring("jar:".length(), last);
        }
        if (classPath.startsWith("file:/")) {
            File checkFile = new File(classPath.substring("file:/".length())).getParentFile();
            do {
                File tmp;
                if (!(tmp = new File(checkFile, fileName)).exists()) continue;
                return tmp;
            } while ((checkFile = checkFile.getParentFile()) != null);
            return null;
        }
        return null;
    }

    public static String getNonQueryAnchorPath(String path) {
        String anchor = PathnameUtils.getAnchor(path);
        if (anchor == null) {
            String query = PathnameUtils.getQuery(path);
            if (query == null) {
                return path;
            }
            return path.substring(0, path.length() - query.length() - 1);
        }
        String query = PathnameUtils.getQuery(path);
        if (query == null) {
            return path.substring(0, path.length() - anchor.length() - 1);
        }
        return path.substring(0, path.length() - query.length() - anchor.length() - 2);
    }

    public static String getQuery(String path) {
        String anchor = PathnameUtils.getAnchor(path);
        if (anchor == null) {
            int index = path.lastIndexOf("?");
            if (index != -1) {
                return path.substring(index + 1);
            }
        } else {
            int index = path.lastIndexOf("?", path.length() - anchor.length());
            if (index != -1) {
                return path.substring(index + 1, path.length() - anchor.length() - 1);
            }
        }
        return null;
    }

    public static String getAnchor(String path) {
        int index = path.lastIndexOf("#");
        if (index != -1) {
            return path.substring(index + 1);
        }
        return null;
    }

    public static boolean isContainExtension(String path, String[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            if (path.toLowerCase().endsWith("." + extensions[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static File getEmptyFileName(File file) {
        String fileName;
        if (!file.exists()) {
            return file;
        }
        String head = fileName = file.getName();
        int e = fileName.lastIndexOf(".");
        String ext = "";
        if (e != -1) {
            ext = fileName.substring(e);
            head = fileName.substring(0, e);
        }
        int index = 1;
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            String newName = String.valueOf(head) + "(" + index + ")" + ext;
            newFile = new File(file.getParentFile(), newName);
            ++index;
        }
        return newFile;
    }
}

