/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ProgressMonitorUtils {
    public static IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow.getStatusLineManager().getProgressMonitor();
    }

    public static void beginMonitor(IProgressMonitor monitor, String text, int step) {
        ProgressMonitorUtils.beginMonitor(monitor, text, step, true);
    }

    public static void beginMonitor(IProgressMonitor monitor, String text, int step, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorBegin(monitor, text, step));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorBegin(monitor, text, step));
        }
    }

    public static void subtaskMonitor(IProgressMonitor monitor, String text) {
        ProgressMonitorUtils.subtaskMonitor(monitor, text);
    }

    public static void subtaskMonitor(IProgressMonitor monitor, String text, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorSubtask(monitor, text));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorSubtask(monitor, text));
        }
    }

    public static void doneMonitor(IProgressMonitor monitor) {
        ProgressMonitorUtils.doneMonitor(monitor, true);
    }

    public static void doneMonitor(IProgressMonitor monitor, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorDone(monitor));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorDone(monitor));
        }
    }

    public static void workedMonitor(IProgressMonitor monitor, int step) {
        ProgressMonitorUtils.workedMonitor(monitor, step, true);
    }

    public static void workedMonitor(IProgressMonitor monitor, int step, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorWorked(monitor, step));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorWorked(monitor, step));
        }
    }

    private static class ProgressMonitorDone
    implements Runnable {
        IProgressMonitor monitor;

        public ProgressMonitorDone(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    private static class ProgressMonitorBegin
    implements Runnable {
        IProgressMonitor monitor;
        String text;
        int step;

        public ProgressMonitorBegin(IProgressMonitor monitor, String text, int step) {
            this.monitor = monitor;
            this.text = text;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.text, this.step);
        }
    }

    private static class ProgressMonitorWorked
    implements Runnable {
        IProgressMonitor monitor;
        int step;

        public ProgressMonitorWorked(IProgressMonitor monitor, int step) {
            this.monitor = monitor;
            this.step = step;
        }

        public void run() {
            this.monitor.worked(this.step);
        }
    }

    private static class ProgressMonitorSubtask
    implements Runnable {
        IProgressMonitor monitor;
        String text;

        public ProgressMonitorSubtask(IProgressMonitor monitor, String text) {
            this.monitor = monitor;
            this.text = text;
        }

        public void run() {
            this.monitor.subTask(this.text);
        }
    }
}

