/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.dvdtoxvid;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDTitleSet;

public class DVDData {
    private List titleSets = new ArrayList();

    public void open(File dir) {
        this.titleSets = new ArrayList();
        String[] list = dir.list(new VTFFileFilter());
        int i = 0;
        while (i < list.length) {
            int[] nums = DVDData.getVTSNumber(list[i]);
            DVDTitleSet titleset = this.getTitleSet(nums[0]);
            if (titleset == null) {
                titleset = new DVDTitleSet(nums[0]);
                this.titleSets.add(titleset);
            }
            titleset.addFile(new File(dir, list[i]));
            ++i;
        }
        if (this.titleSets.size() == 0 && dir.getAbsolutePath().length() == 3 && new File(dir, "VIDEO_TS").exists()) {
            this.open(new File(dir, "VIDEO_TS"));
        }
    }

    public DVDTitleSet getTitleSet(int index) {
        DVDTitleSet[] titles = this.getTitleSets();
        int i = 0;
        while (i < titles.length) {
            if (titles[i].getIndex() == index) {
                return titles[i];
            }
            ++i;
        }
        return null;
    }

    public static int[] getVTSNumber(String line) {
        String base = line.substring(4, line.length() - 4);
        String[] nums = base.split("_");
        int[] ret = new int[]{Integer.parseInt(nums[0]), Integer.parseInt(nums[1])};
        return ret;
    }

    public DVDTitleSet[] getTitleSets() {
        return this.titleSets.toArray(new DVDTitleSet[this.titleSets.size()]);
    }

    public class VTFFileFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toUpperCase().endsWith(".VOB") && arg1.toUpperCase().startsWith("VTS_");
        }
    }
}

