/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.youtubedl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ui.DirectoryPathCombo;
import jp.sourceforge.akjrcp.ui.EditableListData;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.ProgressAndQuee;
import jp.sourceforge.akjrcp.ui.SimpleEditableListData;
import jp.sourceforge.akjrcp.ui.URLBasedExecuterListener;
import jp.sourceforge.akjrcp.util.ClipboardUtil;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.util.YoutubeDLExecuter;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import jp.sourceforge.akjrcp.youtubedl.YoutubeDLListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class YoutubeDLView
extends ViewPart {
    public static Log log = LogFactory.getLog(YoutubeDLView.class);
    public static final String ID = YoutubeDLView.class.getName();
    Composite composite;
    Text urlLine;
    public static List<YoutubeDLListener> youtubeDLListeners = new ArrayList<YoutubeDLListener>();
    private int sleeptime = 3;
    private boolean downloading;
    private EditableListData currentData;
    private String userText;
    private String passwordText;
    private Button execButton;
    private boolean cancelling;
    private YoutubeDLExecuter youtubeExecuter;
    public static String KEY = "teaspi12-59";
    private File exportDir;
    private DirectoryPathCombo pathCombo;
    private IProgressMonitor progressMonitor;
    private Button renameFile;
    private boolean rename;
    private Text user;
    private Text password;
    private ProgressAndQuee progressAndQuee;

    public void setUrl(String url) {
        this.urlLine.setText(url);
    }

    public void createPartControl(Composite root) {
        CTabFolder tab = new CTabFolder(root, 0);
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("youtubedl.main"));
        Composite parent = new Composite((Composite)tab, 0);
        tabItem1.setControl((Control)parent);
        tab.setSelection(0);
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite split2 = new Composite(parent, 0);
        split2.setLayout((Layout)new GridLayout(2, false));
        Composite renameAndExec = new Composite(split2, 0);
        renameAndExec.setLayout((Layout)new GridLayout(1, false));
        this.renameFile = new Button(renameAndExec, 32);
        this.renameFile.setText(Messages.getString("youtubedl.rename_file"));
        this.renameFile.setToolTipText(Messages.getString("youtubedl.rename_file_tooltip"));
        this.renameFile.setSelection(PlatformUI.getPreferenceStore().getBoolean("youtubedl.rename_file"));
        this.renameFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.storeValue(e.getSource());
                YoutubeDLView.this.rename = YoutubeDLView.this.renameFile.getSelection();
            }
        });
        Group compo2 = new Group(split2, 0);
        compo2.setLayout((Layout)new GridLayout(1, false));
        compo2.setText(Messages.getString("youtubedl.group_download"));
        this.pathCombo = new DirectoryPathCombo((Composite)compo2, 0, Akj_betasPlugin.getDefault().getPreferenceStore(), "explorer.paths", ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/opendir.gif"), ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/showin.gif"));
        Composite dlGroup = new Composite(parent, 0);
        dlGroup.setLayout((Layout)new GridLayout(2, false));
        this.execButton = new Button(dlGroup, 0);
        this.execButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.addURL(YoutubeDLView.this.urlLine.getText());
                YoutubeDLView.this.urlLine.setText("");
            }
        });
        this.execButton.setText(Messages.getString("youtubedl.exec"));
        Group compo = new Group(dlGroup, 0);
        compo.setText(Messages.getString("youtubedl.group_url"));
        compo.setLayout((Layout)new GridLayout(2, false));
        Button pasteButton = new Button((Composite)compo, 0);
        pasteButton.setImage(ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/url_clipboard.gif"));
        pasteButton.setAlignment(0x1000000);
        pasteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.pasteAction();
            }
        });
        GridData labelData = new GridData();
        labelData.minimumWidth = 32;
        labelData.minimumHeight = 32;
        labelData.grabExcessHorizontalSpace = true;
        labelData.grabExcessVerticalSpace = true;
        pasteButton.setLayoutData((Object)labelData);
        pasteButton.setToolTipText(Messages.getString("youtubedl.paste_clipboard"));
        GridData urlData = new GridData();
        urlData.minimumWidth = 500;
        urlData.minimumHeight = 24;
        urlData.grabExcessHorizontalSpace = true;
        urlData.grabExcessVerticalSpace = false;
        this.urlLine = new Text((Composite)compo, 0);
        this.urlLine.setFont(new Font(null, "MS-Mincho", 12, 0));
        this.urlLine.setLayoutData((Object)urlData);
        this.urlLine.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                YoutubeDLView.this.execButton.setEnabled(YoutubeUtils.isYoutubeVideoURL(YoutubeDLView.this.urlLine.getText()));
            }
        });
        this.pathCombo.updatePaths();
        if (!this.isYoutubeDLExist()) {
            Akj_betasPlugin.getDefault().getProcessPrinter().printError(String.valueOf(Messages.getString("youtubedl.error_no_youtubedl")) + "\n");
        }
        try {
            this.pasteAction();
        }
        catch (Exception exception) {
            log.warn((Object)"paste faild");
        }
        Group compo3 = new Group(parent, 0);
        compo3.setLayout((Layout)new GridLayout(4, true));
        Label userLabel = new Label((Composite)compo3, 0);
        userLabel.setText(Messages.getString("youtubedl.userID"));
        this.user = new Text((Composite)compo3, 0);
        this.user.setLayoutData((Object)new GridData(768));
        Label passwordLabel = new Label((Composite)compo3, 0);
        passwordLabel.setText(Messages.getString("youtubedl.password"));
        this.password = new Text((Composite)compo3, 0x400000);
        this.password.setLayoutData((Object)new GridData(768));
        this.user.setText(Akj_betasPlugin.getDefault().getPreferenceStore().getString("youtubedl.user"));
        String passwordText = YoutubeDLView.decrypteValue(KEY, Akj_betasPlugin.getDefault().getPreferenceStore().getString("youtubedl.password"));
        if (passwordText != null) {
            this.password.setText(passwordText);
        }
        this.getSite().getPage().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                log.trace((Object)"deactivate");
                if (!YoutubeDLView.this.user.isDisposed()) {
                    Akj_betasPlugin.getDefault().getPreferenceStore().setValue("youtubedl.user", YoutubeDLView.this.user.getText());
                    try {
                        if (YoutubeDLView.this.password.getText().length() == 0) {
                            Akj_betasPlugin.getDefault().getPreferenceStore().setValue("youtubedl.password", "");
                        } else {
                            String passwordValue = YoutubeDLView.encryptValue(KEY, YoutubeDLView.this.password.getText());
                            Akj_betasPlugin.getDefault().getPreferenceStore().setValue("youtubedl.password", passwordValue);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        });
        CTabItem tabItem2 = new CTabItem(tab, 0);
        tabItem2.setText(Messages.getString("youtubedl.download"));
        this.progressAndQuee = new ProgressAndQuee((Composite)tab, 0);
        tabItem2.setControl((Control)this.progressAndQuee);
        this.progressAndQuee.getCancelAllButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.cancelling = true;
                YoutubeDLView.this.progressAndQuee.getEditableList().removeAll();
                if (YoutubeDLView.this.youtubeExecuter != null) {
                    YoutubeDLView.this.youtubeExecuter.cancel();
                }
            }
        });
        this.progressAndQuee.getCancelButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (YoutubeDLView.this.youtubeExecuter != null) {
                    YoutubeDLView.this.youtubeExecuter.cancel();
                }
            }
        });
        this.progressAndQuee.getCancelButton().setEnabled(false);
        this.progressAndQuee.getCancelAllButton().setEnabled(false);
    }

    public void addURL(String url) {
        if (this.isAlreadyDownloading(url)) {
            log.info((Object)("already download:" + url));
            return;
        }
        try {
            String label;
            SimpleEditableListData data = new SimpleEditableListData();
            if (!this.password.getText().equals("") && !this.password.getText().equals("")) {
                label = YoutubeUtils.getTitle(new URL(url));
                if (label.equals("Broadcast Yourself")) {
                    label = YoutubeUtils.getId(new URL(url));
                }
            } else {
                label = YoutubeUtils.getTitle(new URL(url));
            }
            data.setLabel(label);
            data.setValue(url);
            log.warn((Object)("addData:" + data.getLabel() + "," + data.getValue()));
            this.progressAndQuee.addData(data);
            log.warn((Object)("dataSize:" + this.progressAndQuee.getEditableList().countDatas()));
            if (!this.downloading) {
                this.startDownload();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void startDownload() {
        this.cancelling = false;
        new StartDownload().start();
    }

    public boolean isAlreadyDownloading(String url) {
        if (this.currentData != null && this.currentData.getValue().equals(url)) {
            return true;
        }
        EditableListData[] datas = this.progressAndQuee.getEditableList().getDatas();
        int i = 0;
        while (i < datas.length) {
            if (datas[i].getValue().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String encryptValue(String key, String value) {
        try {
            String ret = "";
            SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, sksSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            int i = 0;
            while (i < encrypted.length) {
                ret = String.valueOf(ret) + encrypted[i];
                if (i != encrypted.length - 1) {
                    ret = String.valueOf(ret) + ",";
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypteValue(String key, String value) {
        String[] tmps;
        block4: {
            tmps = value.split(",");
            if (tmps.length != 0) break block4;
            return null;
        }
        try {
            byte[] encrypted = new byte[tmps.length];
            int i = 0;
            while (i < tmps.length) {
                encrypted[i] = Byte.parseByte(tmps[i]);
                ++i;
            }
            SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, sksSpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return new String(decrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void pasteAction() {
        String[] lines;
        String text = ClipboardUtil.getCurrentText(PlatformUI.getWorkbench().getDisplay());
        if (text != null && YoutubeUtils.isYoutubeVideoURL((lines = text.split("\n"))[0])) {
            this.urlLine.setText(lines[0]);
        }
    }

    public void storeValue(Object object) {
        if (object == this.renameFile) {
            PlatformUI.getPreferenceStore().setValue("youtubedl.rename_file", this.renameFile.getSelection());
        }
    }

    public boolean isYoutubeDLExist() {
        String python = PlatformUI.getPreferenceStore().getString("youtubedl.path_python");
        String dl_py = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.py");
        String dl_exe = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.exe");
        if (python.length() > 0 && new File(python).exists() && dl_py.length() > 0 && new File(dl_py).exists()) {
            return true;
        }
        return dl_exe.length() > 0 && new File(dl_exe).exists();
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    public void setFocus() {
        this.urlLine.setFocus();
    }

    public class POPData
    extends Thread {
        public void run() {
            YoutubeDLView.this.currentData = YoutubeDLView.this.progressAndQuee.getEditableList().popData();
        }
    }

    public class BeforeExecute
    extends Thread {
        public void run() {
            YoutubeDLView.this.progressAndQuee.getCancelAllButton().setEnabled(true);
            YoutubeDLView.this.progressAndQuee.getCancelButton().setEnabled(true);
            YoutubeDLView.this.exportDir = YoutubeDLView.this.pathCombo.getSelectedDirectory();
            YoutubeDLView.this.progressAndQuee.setHeaderLabelText(YoutubeDLView.this.currentData.getLabel());
            YoutubeDLView.this.progressMonitor = ProgressMonitorUtils.getProgressMonitor();
            YoutubeDLView.this.userText = YoutubeDLView.this.user.getText();
            YoutubeDLView.this.passwordText = YoutubeDLView.this.password.getText();
        }
    }

    public class AfterExecute
    extends Thread {
        public void run() {
            YoutubeDLView.this.progressAndQuee.getCancelAllButton().setEnabled(false);
            YoutubeDLView.this.progressAndQuee.getCancelButton().setEnabled(false);
            YoutubeDLView.this.progressAndQuee.setHeaderLabelText("");
            YoutubeDLView.this.progressAndQuee.getProgressBar().setSelection(0);
        }
    }

    public class StartDownload
    extends Thread {
        public void run() {
            YoutubeDLView.this.downloading = true;
            log.info((Object)("StartDownload:" + YoutubeDLView.this.progressAndQuee.getEditableList().countDatas()));
            while (YoutubeDLView.this.progressAndQuee.getEditableList().countDatas() > 0) {
                if (YoutubeDLView.this.cancelling) {
                    log.warn((Object)"cancell all");
                    break;
                }
                log.info((Object)("datas:" + YoutubeDLView.this.progressAndQuee.getEditableList().countDatas()));
                YoutubeDLView.this.getSite().getShell().getDisplay().syncExec((Runnable)new POPData());
                if (YoutubeDLView.this.currentData != null) {
                    YoutubeDLView.this.getSite().getShell().getDisplay().syncExec((Runnable)new BeforeExecute());
                    log.info((Object)YoutubeDLView.this.currentData);
                    YoutubeDLView.this.youtubeExecuter = new YoutubeDLExecuter();
                    YoutubeDLView.this.youtubeExecuter.setExportDir(YoutubeDLView.this.exportDir.getAbsolutePath());
                    String python = PlatformUI.getPreferenceStore().getString("youtubedl.path_python");
                    String dl_py = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.py");
                    String dl_exe = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.exe");
                    boolean setPath = false;
                    if (python.length() > 0 && new File(python).exists() && dl_py.length() > 0 && new File(dl_py).exists()) {
                        YoutubeDLView.this.youtubeExecuter.setPythonPath(python);
                        YoutubeDLView.this.youtubeExecuter.setYoutubeDLPath(dl_py);
                        setPath = true;
                    }
                    if (!setPath) {
                        if (dl_exe.length() > 0 && new File(dl_exe).exists()) {
                            YoutubeDLView.this.youtubeExecuter.setYoutubeDLPath(dl_exe);
                            setPath = true;
                        } else {
                            log.warn((Object)"youtube-dl not found");
                        }
                    }
                    if (!YoutubeDLView.this.userText.equals("")) {
                        YoutubeDLView.this.youtubeExecuter.setUser(YoutubeDLView.this.userText);
                    }
                    if (!YoutubeDLView.this.passwordText.equals("")) {
                        YoutubeDLView.this.youtubeExecuter.setPassword(YoutubeDLView.this.passwordText);
                    }
                    YoutubeDLView.this.youtubeExecuter.setRenameFile(YoutubeDLView.this.rename);
                    YoutubeDLView.this.youtubeExecuter.setExecuteListener(new DLMonitor());
                    try {
                        YoutubeDLView.this.youtubeExecuter.execute(new URL[]{new URL((String)YoutubeDLView.this.currentData.getValue())});
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                YoutubeDLView.this.currentData = null;
                if (YoutubeDLView.this.progressAndQuee.getEditableList().countDatas() <= 0) continue;
                try {
                    log.warn((Object)("wait download:" + YoutubeDLView.this.sleeptime));
                    Thread.sleep(YoutubeDLView.this.sleeptime * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            YoutubeDLView.this.getSite().getShell().getDisplay().syncExec((Runnable)new AfterExecute());
            YoutubeDLView.this.downloading = false;
        }
    }

    public class OverwriteCheck
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            FileOverwriteControler controler;
            boolean r;
            File f = new File(event.getFilePath());
            if (f.exists() && !(r = (controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).canOverwrite(f))) {
                ((FileDirChoicer)((Object)event.getSource())).removePath();
            }
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class UpdateExplorer
    extends Thread {
        public void run() {
            int i = 0;
            while (i < youtubeDLListeners.size()) {
                youtubeDLListeners.get(i).downloaded("");
                ++i;
            }
        }
    }

    public class ProgressWorked
    extends Thread {
        private int value;

        public ProgressWorked(int value) {
            this.value = value;
        }

        public void run() {
            YoutubeDLView.this.progressAndQuee.getProgressBar().setSelection(this.value);
        }
    }

    public class DLMonitor
    implements URLBasedExecuterListener {
        int lastprocess = 0;

        public void afterConvert() {
        }

        public void beforeConvert() {
        }

        public void endConvert(URL url) {
            ProgressMonitorUtils.doneMonitor(YoutubeDLView.this.progressMonitor, true);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateExplorer());
        }

        public void faildConvert(URL url, String message) {
            ProgressMonitorUtils.doneMonitor(YoutubeDLView.this.progressMonitor, true);
            YoutubeDLView.this.setStatusValue(Messages.getString("youtubedl.faild"));
            Akj_betasPlugin.getDefault().getProcessPrinter().printError(Messages.getString("youtubedl.faild.detail"));
        }

        public void printProcess(String line) {
            if (YoutubeDLExecuter.isProgressLine(line)) {
                int value = YoutubeDLExecuter.getProgressPersent(line);
                int add = value - this.lastprocess;
                if (add > 0) {
                    ProgressMonitorUtils.workedMonitor(YoutubeDLView.this.progressMonitor, add, true);
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressWorked(value));
                }
                this.lastprocess = value;
            } else {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(line);
            }
        }

        public void startConvert(URL url) {
            ProgressMonitorUtils.beginMonitor(YoutubeDLView.this.progressMonitor, "Download:" + url.toString(), 100, true);
            this.lastprocess = 0;
        }
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)YoutubeDLView.this.getViewSite().getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }
}

