/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.verifier.Base64;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.DigestedInputStream;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class SignedBundleFile
extends BundleFile
implements CertificateVerifier {
    static MessageDigest md5;
    static MessageDigest sha1;
    private static final String MF_ENTRY_NEWLN_NAME = "\nName: ";
    private static final String MF_ENTRY_NAME = "Name: ";
    private static final String MF_DIGEST_PART = "-Digest: ";
    private static final String digestManifestSearch = "-Digest-Manifest: ";
    private static final int digestManifestSearchLen;
    private static final String[] EMPTY_STRING;
    private BundleFile bundleFile;
    CertificateChain[] chains;
    Hashtable digests4entries;
    Hashtable results4entries;
    String manifestSHAResult = null;
    String manifestMD5Result = null;
    boolean certsInitialized = false;

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        digestManifestSearchLen = digestManifestSearch.length();
        EMPTY_STRING = new String[0];
    }

    SignedBundleFile() {
    }

    SignedBundleFile(CertificateChain[] chains, Hashtable digests4entries, Hashtable results4entries, String manifestMD5Result, String manifestSHAResult) {
        this.chains = chains;
        this.digests4entries = digests4entries;
        this.results4entries = results4entries;
        this.manifestMD5Result = manifestMD5Result;
        this.manifestSHAResult = manifestSHAResult;
        this.certsInitialized = true;
    }

    private void populateManifest(byte[] mfBuf) {
        String mfStr = new String(mfBuf);
        int entryStartOffset = mfStr.indexOf(MF_ENTRY_NEWLN_NAME);
        while (entryStartOffset != -1 && entryStartOffset < mfStr.length()) {
            String[] digestLines;
            int entryEndOffset = mfStr.indexOf(MF_ENTRY_NEWLN_NAME, entryStartOffset + 1);
            if (entryEndOffset == -1) {
                entryEndOffset = mfStr.length();
            }
            String entryStr = mfStr.substring(entryStartOffset + 1, entryEndOffset);
            String entryName = this.getName(entryStr = this.stripContinuations(entryStr));
            if (entryName != null && (digestLines = this.getDigestLines(entryStr)) != null) {
                MessageDigest[] digestList = this.getDigestList(digestLines);
                byte[][] digestResultsList = this.getDigestResultsList(digestLines);
                if (digestList != null && digestResultsList != null && digestList.length != digestResultsList.length) {
                    throw new RuntimeException("digest and digest results were different counts..");
                }
                if (entryName != null && digestList != null && digestResultsList != null) {
                    if (this.digests4entries == null) {
                        this.digests4entries = new Hashtable(10);
                        this.results4entries = new Hashtable(10);
                    }
                    if (!this.digests4entries.contains(entryName)) {
                        this.digests4entries.put(entryName, digestList);
                        this.results4entries.put(entryName, digestResultsList);
                    }
                }
            }
            entryStartOffset = entryEndOffset;
        }
    }

    private String stripContinuations(String entry) {
        if (entry.indexOf("\n ") < 0) {
            return entry;
        }
        StringBuffer buffer = new StringBuffer(entry.length());
        int cont = entry.indexOf("\n ");
        int start = 0;
        while (cont >= 0) {
            buffer.append(entry.substring(start, cont - 1));
            start = cont + 2;
            int n = cont = cont + 2 < entry.length() ? entry.indexOf("\n ", cont + 2) : -1;
        }
        if (start < entry.length()) {
            buffer.append(entry.substring(start));
        }
        return buffer.toString();
    }

    private String getName(String manifestEntry) {
        int nameStart = manifestEntry.indexOf(MF_ENTRY_NAME);
        if (nameStart == -1) {
            return null;
        }
        int nameEnd = manifestEntry.indexOf(10, nameStart);
        if (nameEnd == -1) {
            return null;
        }
        if (manifestEntry.charAt(nameEnd - 1) == '\r') {
            --nameEnd;
        }
        if ((nameStart += MF_ENTRY_NAME.length()) >= nameEnd) {
            return null;
        }
        return manifestEntry.substring(nameStart, nameEnd);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getDigestLines(String manifestEntry) {
        digestLines = new String[1];
        numFound = 0;
        indexDigest = manifestEntry.indexOf("-Digest: ");
        if (indexDigest != -1) ** GOTO lbl28
        return null;
lbl-1000:
        // 1 sources

        {
            indexStart = manifestEntry.lastIndexOf(10, indexDigest);
            if (indexStart == -1) {
                return null;
            }
            indexEnd = manifestEntry.indexOf(10, indexDigest);
            if (indexEnd == -1) {
                return null;
            }
            indexEndToUse = indexEnd;
            if (manifestEntry.charAt(indexEndToUse - 1) == '\r') {
                --indexEndToUse;
            }
            if ((indexStartToUse = indexStart + 1) >= indexEndToUse) {
                return null;
            }
            digestLine = manifestEntry.substring(indexStartToUse, indexEndToUse);
            if (digestLine.startsWith("MD5") || digestLine.startsWith("SHA1")) {
                if (++numFound == 2) {
                    tempDigestLines = digestLines;
                    digestLines = new String[]{tempDigestLines[0], digestLine};
                } else if (numFound == 1) {
                    digestLines[0] = digestLine;
                } else {
                    return null;
                }
            }
            indexDigest = manifestEntry.indexOf("-Digest: ", indexEnd);
lbl28:
            // 2 sources

            ** while (indexDigest != -1)
        }
lbl29:
        // 1 sources

        return numFound == 0 ? null : digestLines;
    }

    private MessageDigest[] getDigestList(String[] digestLines) {
        MessageDigest[] mdList = new MessageDigest[digestLines.length];
        int i = 0;
        while (i < digestLines.length) {
            String sDigestLine = digestLines[i];
            int indexDigest = sDigestLine.indexOf(MF_DIGEST_PART);
            String sDigestAlgType = sDigestLine.substring(0, indexDigest);
            if (sDigestAlgType.equals("MD5")) {
                mdList[i] = md5;
            } else if (sDigestAlgType.equals("SHA1")) {
                mdList[i] = sha1;
            } else {
                mdList = null;
                break;
            }
            ++i;
        }
        return mdList;
    }

    private byte[][] getDigestResultsList(String[] digestLines) {
        byte[][] resultsList = new byte[digestLines.length][];
        int i = 0;
        while (i < digestLines.length) {
            String sDigestLine = digestLines[i];
            int indexDigest = sDigestLine.indexOf(MF_DIGEST_PART);
            if ((indexDigest += MF_DIGEST_PART.length()) >= sDigestLine.length()) {
                resultsList = null;
                break;
            }
            String sResult = sDigestLine.substring(indexDigest);
            try {
                resultsList[i] = Base64.decode(sResult.getBytes());
            }
            catch (Throwable throwable) {
                resultsList = null;
                break;
            }
            ++i;
        }
        return resultsList;
    }

    private static int readFully(InputStream is, byte[] b) throws IOException {
        int rc;
        int count = b.length;
        int offset = 0;
        while ((rc = is.read(b, offset, count)) > 0) {
            count -= rc;
            offset += rc;
        }
        return offset;
    }

    byte[] readIntoArray(BundleEntry be) throws IOException {
        byte[] b;
        int size = (int)be.getSize();
        InputStream is = be.getInputStream();
        int rc = SignedBundleFile.readFully(is, b = new byte[size]);
        if (rc != size) {
            throw new IOException("Couldn't read all of " + be.getName() + ": " + rc + " != " + size);
        }
        return b;
    }

    void setBundleFile(BundleFile bundleFile) throws IOException {
        this.bundleFile = bundleFile;
        if (this.certsInitialized) {
            return;
        }
        ArrayList<PKCS7Processor> chainList = new ArrayList<PKCS7Processor>();
        BundleEntry be = bundleFile.getEntry("META-INF/MANIFEST.MF");
        if (be == null) {
            return;
        }
        byte[] manifestBytes = this.readIntoArray(be);
        Enumeration en = bundleFile.getEntryPaths("META-INF/");
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!name.endsWith(".DSA") && !name.endsWith(".RSA") || name.indexOf(47) != name.lastIndexOf(47)) continue;
            be = bundleFile.getEntry(name);
            byte[] pkcs7Bytes = this.readIntoArray(be);
            int dotIndex = name.lastIndexOf(46);
            be = bundleFile.getEntry(String.valueOf(name.substring(0, dotIndex)) + ".SF");
            byte[] sfBytes = this.readIntoArray(be);
            if (!this.checkManifestDigest(manifestBytes, sfBytes)) continue;
            PKCS7Processor chain = null;
            try {
                chain = new PKCS7Processor(pkcs7Bytes, 0, pkcs7Bytes.length, sfBytes, 0, sfBytes.length);
            }
            catch (Exception e) {
                SignedBundleHook.log("Invalid or untrusted certificate: " + bundleFile.getBaseFile(), 2, e);
                continue;
            }
            if (chain == null || chain.getSigner() == null) continue;
            chainList.add(chain);
        }
        CertificateChain[] certificateChainArray = this.chains = chainList.size() == 0 ? null : chainList.toArray(new CertificateChain[chainList.size()]);
        if (this.chains != null) {
            this.populateManifest(manifestBytes);
        }
    }

    private boolean checkManifestDigest(byte[] manifestBytes, byte[] sfBytes) {
        String sf = new String(sfBytes);
        sf = this.stripContinuations(sf);
        boolean foundDigest = false;
        int off = sf.indexOf(digestManifestSearch);
        while (off != -1) {
            int start = sf.lastIndexOf(10, off);
            String result = null;
            if (start != -1) {
                String digestName = sf.substring(start + 1, off);
                if (digestName.equals("MD5")) {
                    if (this.manifestMD5Result == null) {
                        this.manifestMD5Result = this.calculateDigest(md5, manifestBytes);
                    }
                    result = this.manifestMD5Result;
                } else if (digestName.equals("SHA1")) {
                    if (this.manifestSHAResult == null) {
                        this.manifestSHAResult = this.calculateDigest(sha1, manifestBytes);
                    }
                    result = this.manifestSHAResult;
                }
                if (result == null || !sf.startsWith(result, off += digestManifestSearchLen)) {
                    foundDigest = false;
                    break;
                }
                foundDigest = true;
            }
            off = sf.indexOf(digestManifestSearch, off);
        }
        return foundDigest;
    }

    private String calculateDigest(MessageDigest digest, byte[] bytes) {
        String result;
        try {
            digest = (MessageDigest)digest.clone();
            result = new String(Base64.encode(digest.digest(bytes)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(String.valueOf(digest.getAlgorithm()) + " doesn't support clone()");
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        ZipBundleFile jf = new ZipBundleFile(new File(args[0]), null);
        SignedBundleFile sr = new SignedBundleFile();
        sr.setBundleFile(jf);
        Enumeration en = sr.getEntryPaths("/");
        while (en.hasMoreElements()) {
            String filePath = (String)en.nextElement();
            System.out.println("main(): " + filePath);
            if (filePath.indexOf(47) != -1) continue;
            BundleEntry be = sr.getEntry(filePath);
            InputStream is = be.getInputStream();
            is.skip(be.getSize());
            is.read();
            is.close();
        }
        if (!sr.isSigned()) {
            System.out.println("No signers present");
        } else {
            CertificateChain[] chains = sr.getChains();
            int i = 0;
            while (i < chains.length) {
                System.out.println(chains[i].getChain());
                ++i;
            }
        }
        System.out.println("Done");
    }

    public File getFile(String path, boolean nativeCode) {
        return this.bundleFile.getFile(path, nativeCode);
    }

    public BundleEntry getEntry(String path) {
        BundleEntry be = this.bundleFile.getEntry(path);
        if (be == null) {
            if (this.digests4entries != null && this.digests4entries.get(path) == null) {
                return null;
            }
            throw new RuntimeException("A file has been removed from the bundle: " + this.getBaseFile().toString() + " : " + path);
        }
        if (be.getName().startsWith("META-INF/")) {
            return be;
        }
        if (!this.isSigned()) {
            return be;
        }
        return new SignedBundleEntry(be);
    }

    public Enumeration getEntryPaths(String path) {
        return this.bundleFile.getEntryPaths(path);
    }

    public void close() throws IOException {
        this.bundleFile.close();
    }

    public void open() throws IOException {
        this.bundleFile.open();
    }

    public boolean containsDir(String dir) {
        return this.bundleFile.containsDir(dir);
    }

    boolean matchDNChain(String pattern) {
        CertificateChain[] matchChains = this.getChains();
        int i = 0;
        while (i < matchChains.length) {
            if (matchChains[i].isTrusted() && DNChainMatching.match(matchChains[i].getChain(), pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File getBaseFile() {
        return this.bundleFile.getBaseFile();
    }

    public String[] verifyContent() {
        if (!this.isSigned()) {
            return EMPTY_STRING;
        }
        ArrayList<String> corrupted = new ArrayList<String>(0);
        Enumeration entries = this.digests4entries.keys();
        while (entries.hasMoreElements()) {
            String name = (String)entries.nextElement();
            BundleEntry entry = this.getEntry(name);
            if (entry == null) {
                corrupted.add(name);
                continue;
            }
            try {
                entry.getBytes();
            }
            catch (IOException iOException) {
                corrupted.add(name);
            }
        }
        return corrupted.size() == 0 ? EMPTY_STRING : corrupted.toArray(new String[corrupted.size()]);
    }

    public CertificateChain[] getChains() {
        if (!this.isSigned()) {
            return new CertificateChain[0];
        }
        return this.chains;
    }

    public boolean isSigned() {
        return this.chains != null;
    }

    class SignedBundleEntry
    extends BundleEntry {
        BundleEntry nestedEntry;

        SignedBundleEntry(BundleEntry nestedEntry) {
            this.nestedEntry = nestedEntry;
        }

        public InputStream getInputStream() throws IOException {
            MessageDigest[] digests;
            String name = this.getName();
            MessageDigest[] messageDigestArray = digests = SignedBundleFile.this.digests4entries == null ? null : (MessageDigest[])SignedBundleFile.this.digests4entries.get(name);
            if (digests == null) {
                return null;
            }
            byte[][] results = (byte[][])SignedBundleFile.this.results4entries.get(name);
            return new DigestedInputStream(this.nestedEntry.getInputStream(), digests, results, this.nestedEntry.getSize());
        }

        public long getSize() {
            return this.nestedEntry.getSize();
        }

        public String getName() {
            return this.nestedEntry.getName();
        }

        public long getTime() {
            return this.nestedEntry.getTime();
        }

        public URL getLocalURL() {
            return this.nestedEntry.getLocalURL();
        }

        public URL getFileURL() {
            return this.nestedEntry.getFileURL();
        }
    }
}

