/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.commons.util.UtilMessages;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class FileNameUtils {
    public static final String LOCAL_NAME_DESKTOP = UtilMessages.getString("desktop");
    public static final String LOCAL_NAME_MY_DOCUMENTS = UtilMessages.getString("my_documents");
    public static final String LOCAL_NAME_MY_PICTURE = UtilMessages.getString("my_pictures");
    public static final String LOCAL_NAME_MUSIC = UtilMessages.getString("music");
    public static final String LOCAL_NAME_VIDEOS = UtilMessages.getString("videos");
    public static final String LOCAL_NAME_MY_MUSIC = UtilMessages.getString("my_music");
    public static final String LOCAL_NAME_MY_VIDEOS = UtilMessages.getString("my_videos");
    public static final String LOCAL_NAME_DOCUMENTS = UtilMessages.getString("documents");
    public static final String LOCAL_NAME_PICTURE = UtilMessages.getString("pictures");
    public static String OS_NAME = System.getProperty("os.name");
    public static final String WINDOWS_VISTA = "Windows Vista";

    public static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static String getZipEntryFileName(String string) {
        String string2 = "/";
        String[] stringArray = string.split(string2);
        return stringArray[stringArray.length - 1];
    }

    public static String getZipEntryDirectoryName(String string) {
        String string2 = "/";
        String[] stringArray = string.split(string2);
        String string3 = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string3 = string3 + stringArray[i] + string2;
        }
        return string3;
    }

    public static String getExtension(String string) {
        String string2;
        if (string.lastIndexOf(".") == -1) {
            string2 = "";
        } else {
            int n = string.lastIndexOf(".");
            string2 = string.substring(n + 1, string.length());
        }
        return string2;
    }

    public static String getNotFoundFileName(File file) {
        String string = FileNameUtils.getExtension(file.getName());
        File file2 = null;
        String string2 = null;
        if (file.getName().lastIndexOf(".") == -1) {
            string2 = file.getName();
        } else {
            int n = file.getName().lastIndexOf(".");
            string2 = file.getName().substring(0, n);
        }
        String string3 = string2;
        if (!string.equals("")) {
            string3 = string3 + "." + string;
        }
        file2 = new File(file.getParent(), string3);
        int n = 1;
        Pattern pattern = Pattern.compile("(^.*)\\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        while (file2.exists()) {
            String string4 = "(" + n + ")";
            String string5 = string2 + string4;
            if (!string.equals("")) {
                string5 = string5 + "." + string;
            }
            file2 = new File(file.getParent(), string5);
            ++n;
        }
        return file2.getAbsolutePath();
    }

    public static String getChangedExtensionName(File file, String string) {
        return FileNameUtils.getChangedExtensionName(file, string, false);
    }

    public static String getRemovedExtensionName(String string) {
        String string2;
        if (string.lastIndexOf(".") == -1) {
            string2 = string;
        } else {
            int n = string.lastIndexOf(".");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getChangedExtensionName(String string, String string2) {
        String string3;
        if (string.lastIndexOf(".") == -1) {
            string3 = string;
        } else {
            int n = string.lastIndexOf(".");
            string3 = string.substring(0, n);
        }
        return string3 + "." + string2;
    }

    public static String getChangedExtensionName(File file, String string, boolean bl) {
        File file2 = null;
        String string2 = null;
        if (file.getName().lastIndexOf(".") == -1) {
            string2 = file.getName();
        } else {
            int n = file.getName().lastIndexOf(".");
            string2 = file.getName().substring(0, n);
        }
        String string3 = string2;
        if (!string.equals("")) {
            string3 = string3 + "." + string;
        }
        file2 = new File(file.getParent(), string3);
        int n = 1;
        if (!bl) {
            while (file2.exists()) {
                String string4 = "(" + n + ")";
                String string5 = string2 + string4;
                if (!string.equals("")) {
                    string5 = string5 + "." + string;
                }
                file2 = new File(file.getParent(), string5);
                ++n;
            }
        }
        return file2.getAbsolutePath();
    }

    public static boolean isSafeFileName(String string) {
        String string2 = ":;,*?\"<>|?";
        for (int i = 0; i < string2.length(); ++i) {
            if (string.indexOf(string2.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static String toSafeJPName(String string) {
        String string2 = ":;,*?\"<>|?";
        String string3 = "\uff1a\uff1b\u3001\uff0a\uff1f\uffe5\u201d\uff1c\uff1e\uff5c\uff1f";
        String string4 = string;
        string4 = StringUtils.replaceChars((String)string4, (String)string2, (String)string3);
        string4 = StringUtils.replace((String)string4, (String)"\t", (String)" ");
        string4 = StringUtils.replace((String)string4, (String)"\r", (String)" ");
        string4 = StringUtils.replace((String)string4, (String)"\n", (String)" ");
        return string4;
    }

    public static boolean changeExtension(File file, String string) {
        return file.renameTo(new File(FileNameUtils.getChangedExtensionName(file, string)));
    }

    public static File makeBackupFile(File file, String string) {
        int n = 1;
        String string2 = FileNameUtils.getRemovedExtensionName(file.getName());
        String string3 = FileNameUtils.getExtension(file.getName());
        File file2 = new File(file.getParentFile(), string2 + "." + string + "(" + FileNameUtils.digited(n) + ")." + string3);
        while (file2.exists()) {
            file2 = new File(file.getParentFile(), string2 + "." + string + "(" + FileNameUtils.digited(n) + ")." + string3);
            ++n;
        }
        return file2;
    }

    public static File makeBackupFileWithHeader(File file, String string) {
        int n = 1;
        String string2 = FileNameUtils.getRemovedExtensionName(file.getName());
        String string3 = FileNameUtils.getExtension(file.getName());
        File file2 = new File(file.getParentFile(), string2 + "." + string + "(" + FileNameUtils.digited(n) + ")." + string3);
        while (file2.exists()) {
            file2 = new File(file.getParentFile(), "(" + FileNameUtils.digited(n) + ")" + string + string2 + "." + string3);
            ++n;
        }
        return file2;
    }

    public static String digited(int n) {
        int n2 = 4;
        String string = "" + n;
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static String digited(int n, int n2) {
        String string = "" + n;
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static boolean isAsciiFileName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static boolean isWaveFile(String string) {
        return string.toLowerCase().endsWith(".wav") || string.toLowerCase().endsWith(".wave");
    }

    public static String shortenFileName(String string) {
        String string2 = string;
        if (SystemUtils.IS_OS_WINDOWS_XP) {
            if (string.startsWith(FileNameUtils.getDesktopPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getDesktopPath(), (String)LOCAL_NAME_DESKTOP);
            } else if (string.startsWith(FileNameUtils.getMyPicturesPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyPicturesPath(), (String)LOCAL_NAME_MY_PICTURE);
            } else if (string.startsWith(FileNameUtils.getMyVideoPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyVideoPath(), (String)LOCAL_NAME_MY_VIDEOS);
            } else if (string.startsWith(FileNameUtils.getMyMusicPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyMusicPath(), (String)LOCAL_NAME_MY_MUSIC);
            } else if (string.startsWith(FileNameUtils.getMyDocumentsPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyDocumentsPath(), (String)LOCAL_NAME_MY_DOCUMENTS);
            }
        } else if (FileNameUtils.isVista()) {
            if (string.startsWith(FileNameUtils.getDesktopPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getDesktopPath(), (String)LOCAL_NAME_DESKTOP);
            } else if (string.startsWith(FileNameUtils.getMyPicturesPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyPicturesPath(), (String)LOCAL_NAME_PICTURE);
            } else if (string.startsWith(FileNameUtils.getMyVideoPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyVideoPath(), (String)LOCAL_NAME_VIDEOS);
            } else if (string.startsWith(FileNameUtils.getMyMusicPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyMusicPath(), (String)LOCAL_NAME_MUSIC);
            } else if (string.startsWith(FileNameUtils.getMyDocumentsPath())) {
                string2 = StringUtils.replaceOnce((String)string, (String)FileNameUtils.getMyDocumentsPath(), (String)LOCAL_NAME_DOCUMENTS);
            }
        }
        return string2;
    }

    public static String getDesktopPath() {
        if (FileNameUtils.isVista()) {
            return System.getProperty("user.home") + "\\" + "Desktop";
        }
        return System.getProperty("user.home") + "\\" + LOCAL_NAME_DESKTOP;
    }

    public static boolean isVista() {
        if (OS_NAME == null) {
            OS_NAME = System.getProperty("os.name");
        }
        return OS_NAME.indexOf(WINDOWS_VISTA) != -1;
    }

    public static String getMyDocumentsPath() {
        if (FileNameUtils.isVista()) {
            return System.getProperty("user.home") + "\\Documents";
        }
        return System.getProperty("user.home") + "\\My Documents";
    }

    public static String getMyPicturesPath() {
        if (FileNameUtils.isVista()) {
            return System.getProperty("user.home") + "\\Pictures";
        }
        return System.getProperty("user.home") + "\\My Documents\\My Pictures";
    }

    public static String getMyMusicPath() {
        if (FileNameUtils.isVista()) {
            return System.getProperty("user.home") + "\\Music";
        }
        return System.getProperty("user.home") + "\\My Documents\\My Music";
    }

    public static String getMyVideoPath() {
        if (FileNameUtils.isVista()) {
            return System.getProperty("user.home") + "\\Videos";
        }
        return System.getProperty("user.home") + "\\My Documents\\My Videos";
    }
}

