/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.util;

import java.util.ArrayList;

public class JapaneseUtils {
    public static final char HIRAGANA_SMALL_A = '\u3041';
    public static final char HIRAGANA_SMALL_I = '\u3043';
    public static final char HIRAGANA_SMALL_U = '\u3045';
    public static final char HIRAGANA_SMALL_E = '\u3047';
    public static final char HIRAGANA_SMALL_O = '\u3049';
    public static final char HIRAGANA_SMALL_TU = '\u3063';
    public static final char HIRAGANA_SMALL_YA = '\u3083';
    public static final char HIRAGANA_SMALL_YU = '\u3085';
    public static final char HIRAGANA_SMALL_YO = '\u3087';
    public static final char KATAKANA_SMALL_A = '\uff71';
    public static final char KATAKANA_SMALL_I = '\uff72';
    public static final char KATAKANA_SMALL_U = '\uff73';
    public static final char KATAKANA_SMALL_E = '\uff74';
    public static final char KATAKANA_SMALL_O = '\uff75';
    public static final char KATAKANA_SMALL_TU = '\u30c3';
    public static final char KATAKANA_SMALL_YA = '\u30e3';
    public static final char KATAKANA_SMALL_YU = '\u30e5';
    public static final char KATAKANA_SMALL_YO = '\u30e7';
    public static final char HIRAGANA_SMALL_WA = '\u308e';
    public static final char HIRAGANA_A = '\u3042';
    public static final char HIRAGANA_I = '\u3044';
    public static final char HIRAGANA_U = '\u3046';
    public static final char HIRAGANA_E = '\u3048';
    public static final char HIRAGANA_O = '\u304a';
    protected static final char[] CONSONANTS_A = new char[]{'\u3042', '\u3044', '\u3046', '\u3048', '\u304a', '\u3041', '\u3043', '\u3045', '\u3047', '\u3049', '\u3083'};
    public static final char CONSONANT_A = '\u3042';
    public static final char HIRAGANA_KA = '\u304b';
    public static final char HIRAGANA_GA = '\u304c';
    public static final char HIRAGANA_KI = '\u304d';
    public static final char HIRAGANA_GI = '\u304e';
    public static final char HIRAGANA_KU = '\u304f';
    public static final char HIRAGANA_GU = '\u3050';
    public static final char HIRAGANA_KE = '\u3051';
    public static final char HIRAGANA_GE = '\u3052';
    public static final char HIRAGANA_KO = '\u3053';
    public static final char HIRAGANA_GO = '\u3054';
    protected static final char[] CONSONANTS_K = new char[]{'\u304b', '\u304d', '\u304f', '\u3051', '\u3053'};
    public static final char CONSONANT_K = '\u304b';
    protected static final char[] CONSONANTS_G = new char[]{'\u304c', '\u304e', '\u3050', '\u3052', '\u3054'};
    public static final char CONSONANT_G = '\u304c';
    public static final char HIRAGANA_SA = '\u3055';
    public static final char HIRAGANA_ZA = '\u3056';
    public static final char HIRAGANA_SI = '\u3057';
    public static final char HIRAGANA_ZI = '\u3058';
    public static final char HIRAGANA_SU = '\u3059';
    public static final char HIRAGANA_ZU = '\u305a';
    public static final char HIRAGANA_SE = '\u305b';
    public static final char HIRAGANA_ZE = '\u305c';
    public static final char HIRAGANA_SO = '\u305d';
    public static final char HIRAGANA_ZO = '\u305e';
    protected static final char[] CONSONANTS_S = new char[]{'\u3055', '\u3057', '\u3059', '\u305b', '\u305d'};
    public static final char CONSONANT_S = '\u3055';
    protected static final char[] CONSONANTS_Z = new char[]{'\u3056', '\u3058', '\u305a', '\u305c', '\u305e'};
    public static final char CONSONANT_Z = '\u3056';
    public static final char HIRAGANA_TA = '\u305f';
    public static final char HIRAGANA_DA = '\u3060';
    public static final char HIRAGANA_TI = '\u3061';
    public static final char HIRAGANA_DI = '\u3062';
    public static final char HIRAGANA_TU = '\u3064';
    public static final char HIRAGANA_DU = '\u3065';
    public static final char HIRAGANA_TE = '\u3066';
    public static final char HIRAGANA_DE = '\u3067';
    public static final char HIRAGANA_TO = '\u3068';
    public static final char HIRAGANA_DO = '\u3069';
    protected static final char[] CONSONANTS_T = new char[]{'\u305f', '\u3061', '\u3064', '\u3066', '\u3068', '\u3063'};
    public static final char CONSONANT_T = '\u305f';
    protected static final char[] CONSONANTS_D = new char[]{'\u3060', '\u3062', '\u3065', '\u3067', '\u3069'};
    public static final char CONSONANT_D = '\u3060';
    public static final char HIRAGANA_NA = '\u306a';
    public static final char HIRAGANA_NI = '\u306b';
    public static final char HIRAGANA_NU = '\u306c';
    public static final char HIRAGANA_NE = '\u306d';
    public static final char HIRAGANA_NO = '\u306e';
    protected static final char[] CONSONANTS_N = new char[]{'\u306a', '\u306b', '\u306c', '\u306d', '\u306e'};
    public static final char CONSONANT_N = '\u306a';
    public static final char HIRAGANA_HA = '\u306f';
    public static final char HIRAGANA_BA = '\u3070';
    public static final char HIRAGANA_PA = '\u3071';
    public static final char HIRAGANA_HI = '\u3072';
    public static final char HIRAGANA_BI = '\u3073';
    public static final char HIRAGANA_PI = '\u3074';
    public static final char HIRAGANA_FU = '\u3075';
    public static final char HIRAGANA_BU = '\u3076';
    public static final char HIRAGANA_PU = '\u3077';
    public static final char HIRAGANA_HE = '\u3078';
    public static final char HIRAGANA_BE = '\u3079';
    public static final char HIRAGANA_PE = '\u307a';
    public static final char HIRAGANA_HO = '\u307b';
    public static final char HIRAGANA_BO = '\u307c';
    public static final char HIRAGANA_PO = '\u307d';
    protected static final char[] CONSONANTS_H = new char[]{'\u306f', '\u3072', '\u3075', '\u3078', '\u307b'};
    public static final char CONSONANT_H = '\u306f';
    protected static final char[] CONSONANTS_B = new char[]{'\u3070', '\u3073', '\u3076', '\u3079', '\u307c'};
    public static final char CONSONANT_B = '\u3070';
    protected static final char[] CONSONANTS_P = new char[]{'\u3071', '\u3074', '\u3077', '\u307a', '\u307d'};
    public static final char CONSONANT_P = '\u3071';
    public static final char HIRAGANA_MA = '\u307e';
    public static final char HIRAGANA_MI = '\u307f';
    public static final char HIRAGANA_MU = '\u3080';
    public static final char HIRAGANA_ME = '\u3081';
    public static final char HIRAGANA_MO = '\u3082';
    protected static final char[] CONSONANTS_M = new char[]{'\u307e', '\u307f', '\u3080', '\u3081', '\u3082'};
    public static final char CONSONANT_M = '\u307e';
    public static final char HIRAGANA_YA = '\u3084';
    public static final char HIRAGANA_YU = '\u3086';
    public static final char HIRAGANA_YO = '\u3088';
    protected static final char[] CONSONANTS_Y = new char[]{'\u3084', '\u3086', '\u3088', '\u3083', '\u3085', '\u3087'};
    public static final char CONSONANT_Y = '\u3084';
    public static final char HIRAGANA_RA = '\u3089';
    public static final char HIRAGANA_RI = '\u308a';
    public static final char HIRAGANA_RU = '\u308b';
    public static final char HIRAGANA_RE = '\u308c';
    public static final char HIRAGANA_RO = '\u308d';
    protected static final char[] CONSONANTS_R = new char[]{'\u3089', '\u308a', '\u308b', '\u308c', '\u308d'};
    public static final char CONSONANT_R = '\u3089';
    public static final char HIRAGANA_WA = '\u308f';
    public static final char HIRAGANA_WI = '\u3090';
    public static final char HIRAGANA_WE = '\u3091';
    public static final char HIRAGANA_WO = '\u3092';
    protected static final char[] CONSONANTS_W = new char[]{'\u308f', '\u3090', '\u3091', '\u3092', '\u308e'};
    public static final char CONSONANT_W = '\u308f';
    public static final char HIRAGANA_NN = '\u3093';
    protected static final char[] CONSONANTS_NN = new char[]{'\u3093'};
    public static final char CONSONANT_NN = '\u3093';
    public static final char[] VOWELS_A = new char[]{'\u3041', '\u3083', '\u308e', '\u3042', '\u304b', '\u304c', '\u304c', '\u3055', '\u3056', '\u305f', '\u3060', '\u306a', '\u306f', '\u3070', '\u3071', '\u307e', '\u3084', '\u3089', '\u308f'};
    public static final char[] VOWELS_I = new char[]{'\u3043', '\u3044', '\u304d', '\u304e', '\u3057', '\u3058', '\u3061', '\u3062', '\u306b', '\u3072', '\u3073', '\u3074', '\u307f', '\u308a', '\u3090'};
    public static final char[] VOWELS_U = new char[]{'\u3045', '\u3063', '\u3085', '\u3046', '\u304f', '\u3050', '\u3059', '\u305a', '\u3064', '\u3065', '\u306c', '\u3075', '\u3076', '\u3077', '\u3080', '\u3086', '\u308b'};
    public static final char[] VOWELS_E = new char[]{'\u3047', '\u3048', '\u3051', '\u3052', '\u305b', '\u305c', '\u3066', '\u3067', '\u306d', '\u3078', '\u3079', '\u307a', '\u3081', '\u308c', '\u3091'};
    public static final char[] VOWELS_O = new char[]{'\u3049', '\u3087', '\u304a', '\u3053', '\u3054', '\u305d', '\u305e', '\u3068', '\u3069', '\u306e', '\u307b', '\u307c', '\u307d', '\u3082', '\u3088', '\u308d', '\u3092'};
    public static final char[] HAS_SMALL = new char[]{'\u3044', '\u3046', '\u304d', '\u3057', '\u3059', '\u3061', '\u3066', '\u306b', '\u3072', '\u3075', '\u307f', '\u308a', '\u304e', '\u3058', '\u305a', '\u3067', '\u30c0', '\u3073', '\u3074'};

    public static boolean isSmallCharacter(char c) {
        return JapaneseUtils.isSmallHiragana(c) || JapaneseUtils.isSmallKatakana(c);
    }

    public static boolean hasSmallCharacter(char c, char c2) {
        if (c2 == '\u3063' || c2 == '\u30c3') {
            return true;
        }
        for (int i = 0; i < HAS_SMALL.length; ++i) {
            if (HAS_SMALL[i] != c) continue;
            return true;
        }
        return false;
    }

    public static String[] splitSmallCharacter(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = "" + string.charAt(i);
            if (i < string.length() - 1 && JapaneseUtils.isSmallCharacter(string.charAt(i + 1)) && JapaneseUtils.hasSmallCharacter(string.charAt(i), string.charAt(i + 1))) {
                string2 = string2 + string.charAt(i + 1);
                ++i;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isSmallKatakana(char c) {
        if ('\uff71' == c) {
            return true;
        }
        if ('\uff72' == c) {
            return true;
        }
        if ('\uff73' == c) {
            return true;
        }
        if ('\uff74' == c) {
            return true;
        }
        if ('\uff75' == c) {
            return true;
        }
        if ('\u30c3' == c) {
            return true;
        }
        if ('\u30e3' == c) {
            return true;
        }
        if ('\u30e5' == c) {
            return true;
        }
        return '\u30e7' == c;
    }

    public static boolean isSmallHiragana(char c) {
        if ('\u3041' == c) {
            return true;
        }
        if ('\u3043' == c) {
            return true;
        }
        if ('\u3045' == c) {
            return true;
        }
        if ('\u3047' == c) {
            return true;
        }
        if ('\u3049' == c) {
            return true;
        }
        if ('\u3063' == c) {
            return true;
        }
        if ('\u3083' == c) {
            return true;
        }
        if ('\u3085' == c) {
            return true;
        }
        return '\u3087' == c;
    }

    public static char getHiraganaConsonant(char c) {
        int n;
        for (n = 0; n < CONSONANTS_A.length; ++n) {
            if (CONSONANTS_A[n] != c) continue;
            return '\u3042';
        }
        for (n = 0; n < CONSONANTS_K.length; ++n) {
            if (CONSONANTS_K[n] != c) continue;
            return '\u304b';
        }
        for (n = 0; n < CONSONANTS_G.length; ++n) {
            if (CONSONANTS_G[n] != c) continue;
            return '\u304c';
        }
        for (n = 0; n < CONSONANTS_S.length; ++n) {
            if (CONSONANTS_S[n] != c) continue;
            return '\u3055';
        }
        for (n = 0; n < CONSONANTS_Z.length; ++n) {
            if (CONSONANTS_Z[n] != c) continue;
            return '\u3056';
        }
        for (n = 0; n < CONSONANTS_T.length; ++n) {
            if (CONSONANTS_T[n] != c) continue;
            return '\u305f';
        }
        for (n = 0; n < CONSONANTS_D.length; ++n) {
            if (CONSONANTS_D[n] != c) continue;
            return '\u3060';
        }
        for (n = 0; n < CONSONANTS_N.length; ++n) {
            if (CONSONANTS_N[n] != c) continue;
            return '\u306a';
        }
        for (n = 0; n < CONSONANTS_H.length; ++n) {
            if (CONSONANTS_H[n] != c) continue;
            return '\u306f';
        }
        for (n = 0; n < CONSONANTS_P.length; ++n) {
            if (CONSONANTS_P[n] != c) continue;
            return '\u3071';
        }
        for (n = 0; n < CONSONANTS_B.length; ++n) {
            if (CONSONANTS_B[n] != c) continue;
            return '\u3070';
        }
        for (n = 0; n < CONSONANTS_M.length; ++n) {
            if (CONSONANTS_M[n] != c) continue;
            return '\u307e';
        }
        for (n = 0; n < CONSONANTS_Y.length; ++n) {
            if (CONSONANTS_Y[n] != c) continue;
            return '\u3084';
        }
        for (n = 0; n < CONSONANTS_R.length; ++n) {
            if (CONSONANTS_R[n] != c) continue;
            return '\u3089';
        }
        for (n = 0; n < CONSONANTS_W.length; ++n) {
            if (CONSONANTS_W[n] != c) continue;
            return '\u308f';
        }
        for (n = 0; n < CONSONANTS_NN.length; ++n) {
            if (CONSONANTS_NN[n] != c) continue;
            return '\u3093';
        }
        return '\u0000';
    }

    public static char getHiraganaVowel(char c) {
        int n;
        if (c == '\u3093') {
            return '\u3093';
        }
        for (n = 0; n < VOWELS_A.length; ++n) {
            if (VOWELS_A[n] != c) continue;
            return '\u3042';
        }
        for (n = 0; n < VOWELS_I.length; ++n) {
            if (VOWELS_I[n] != c) continue;
            return '\u3044';
        }
        for (n = 0; n < VOWELS_U.length; ++n) {
            if (VOWELS_U[n] != c) continue;
            return '\u3046';
        }
        for (n = 0; n < VOWELS_E.length; ++n) {
            if (VOWELS_E[n] != c) continue;
            return '\u3048';
        }
        for (n = 0; n < VOWELS_O.length; ++n) {
            if (VOWELS_O[n] != c) continue;
            return '\u304a';
        }
        return '\u0000';
    }
}

