/*
 * Decompiled with CFR 0.152.
 */
package md5reader.defs;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import md5reader.defs.DefStore;
import md5reader.defs.ModelDEFReader;

public class PakLoader {
    private static final Map TYPEMAP = new HashMap();

    public static DefStore loadPak(File[] files) throws IOException {
        DefStore defs = new DefStore();
        ModelDEFReader reader = new ModelDEFReader(defs, (Reader)null);
        for (int i = 0; i < files.length; ++i) {
            ZipFile zip = new ZipFile(files[i]);
            defs.addZipFile(zip);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith("def/") && !name.startsWith("materials/") && !name.startsWith("skins/")) continue;
                String suffix = "";
                int pos = name.lastIndexOf(46);
                if (pos >= 0) {
                    suffix = name.substring(pos + 1);
                }
                reader.setDefaultType((String)TYPEMAP.get(suffix));
                reader.setInputStream(zip.getInputStream(entry));
                reader.scan();
            }
        }
        return defs;
    }

    static {
        TYPEMAP.put("mtr", "material");
        TYPEMAP.put("skin", "skin");
    }
}

