/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import model.SkeletalKeyFrame;
import util.file.FileUtils;

public class Skeleton
implements Externalizable {
    private int jointCount;
    private String[] jointNames;
    private int[] parents;
    private SkeletalKeyFrame bindFrame;

    public Skeleton(int jointCount) {
        this.resetjointCount(jointCount);
    }

    public int findJoint(String name) {
        for (int i = 0; i < this.jointNames.length; ++i) {
            if (!name.equals(this.jointNames[i])) continue;
            return i;
        }
        return -1;
    }

    public void resetjointCount(int numJoints) {
        this.jointCount = numJoints;
        this.jointNames = new String[numJoints];
        this.parents = new int[numJoints];
        this.bindFrame = new SkeletalKeyFrame(this.jointNames.length);
    }

    public SkeletalKeyFrame getBindFrame() {
        return this.bindFrame;
    }

    public void setBindFrame(SkeletalKeyFrame bindFrame) {
        this.bindFrame = bindFrame;
    }

    public String[] getJointNames() {
        return this.jointNames;
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public int[] getParents() {
        return this.parents;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Skeleton)) {
            return false;
        }
        Skeleton s = (Skeleton)o;
        return this.jointCount == s.jointCount && Arrays.equals(this.jointNames, s.jointNames) && Arrays.equals(this.parents, s.parents);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.jointNames = (String[])in.readObject();
        this.jointCount = this.jointNames.length;
        this.parents = (int[])in.readObject();
        this.bindFrame = (SkeletalKeyFrame)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.jointNames);
        out.writeObject(this.parents);
        out.writeObject(this.bindFrame);
    }
}

