/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Vector3f;
import java.util.BitSet;
import model.KeyFrame;
import model.animation.Animation;
import model.animation.FixedLengthAnimator;

public class AnimationAnimator
extends FixedLengthAnimator {
    private static float defaultInterpolationThreshold = 0.01f;
    protected float time;
    protected int timePoint;
    protected float interpolationThreshold = defaultInterpolationThreshold;
    protected Animation animation;

    public AnimationAnimator(Animation animation) {
        if (animation.isSkeletal() != this.isSkeletal()) {
            throw new IllegalArgumentException("Skeletal/non-skeletal mismatch");
        }
        this.animation = animation;
        this.max = animation.last().time;
        this.min = animation.first().time;
        this.cycleType = 1;
        this.time = this.min;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public boolean update(float timeDelta) {
        this.time += timeDelta * this.getSpeed();
        if (this.time < this.min) {
            this.time = this.min;
        }
        if (this.time > this.max) {
            this.animationController.getEventHandler().notify(this, 4, null);
            if (this.cycleType == 1) {
                float len = this.max - this.min;
                if (len > 0.0f) {
                    while (this.time > this.max) {
                        this.time -= len;
                    }
                } else {
                    this.time = this.max;
                }
            } else {
                if (this.cycleType == 3) {
                    return false;
                }
                this.time = this.max;
            }
        }
        this.timePoint = this.animation.findIndex(this.time, this.timePoint);
        return true;
    }

    @Override
    public Vector3f[] getPositions(Vector3f[] positions, BitSet provided) {
        KeyFrame frame;
        if (provided != null) {
            provided.set(0, this.animation.getBaseFrame().positions.length);
        }
        float delta = this.getDelta();
        if (this.animation.size() == 1) {
            return this.populatePositions(positions, this.animation.first());
        }
        if ((double)delta < 0.5) {
            frame = this.animation.getKeyFrame(this.timePoint - 1);
            if (this.time - frame.time < this.interpolationThreshold) {
                return this.populatePositions(positions, frame);
            }
        } else {
            frame = this.animation.getKeyFrame(this.timePoint);
            if (frame.time - this.time < this.interpolationThreshold) {
                return this.populatePositions(positions, frame);
            }
        }
        Vector3f[] base = this.animation.getBaseFrame().positions;
        Vector3f[] prev = this.animation.getKeyFrame((int)(this.timePoint - 1)).positions;
        Vector3f[] next = this.animation.getKeyFrame((int)this.timePoint).positions;
        BitSet set = this.animation.getSuppliedPositions();
        int pos = 0;
        int length = this.animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            if (set.get(i)) {
                positions[i].interpolate(prev[pos], next[pos++], delta);
                continue;
            }
            positions[i].set(base[i]);
        }
        return positions;
    }

    private Vector3f[] populatePositions(Vector3f[] positions, KeyFrame frame) {
        Vector3f[] cur = frame.positions;
        Vector3f[] base = this.animation.getBaseFrame().positions;
        if (cur.length == base.length) {
            return frame.positions;
        }
        BitSet set = this.animation.getSuppliedPositions();
        int pos = 0;
        int length = this.animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            if (set.get(i)) {
                positions[i].set(cur[pos++]);
                continue;
            }
            positions[i].set(base[i]);
        }
        return positions;
    }

    protected float getDelta() {
        float cur;
        float prev = this.animation.time(this.timePoint - 1);
        if (prev == (cur = this.animation.time(this.timePoint))) {
            return 0.0f;
        }
        float distance = (this.time - prev) / (cur - prev);
        if (distance < 0.0f) {
            return 0.0f;
        }
        if (distance > 1.0f) {
            return 1.0f;
        }
        return distance;
    }

    @Override
    public Vector3f getMovementTranslation(Vector3f target) {
        if (target == null) {
            target = new Vector3f(this.animation.getMovementTranslation());
        } else {
            target.set(this.animation.getMovementTranslation());
        }
        return target;
    }

    @Override
    public Vector3f getBasePosition(Vector3f target) {
        Vector3f base = this.animation.getBaseFrame().positions[0];
        if (target == null) {
            return new Vector3f(base);
        }
        return target.set(base);
    }

    public float getInterpolationThreshold() {
        return this.interpolationThreshold;
    }

    public void setInterpolationThreshold(float interpolationThreshold) {
        this.interpolationThreshold = interpolationThreshold;
    }

    @Override
    public void setTime(float time) {
        Float oldTime = new Float(this.time);
        if (time < this.min) {
            time = this.min;
        }
        if (time > this.max) {
            time = this.max;
        }
        this.time = time;
        if (this.animationController != null) {
            this.animationController.getEventHandler().notify(this, 5, oldTime);
        }
    }

    @Override
    public float getTime() {
        return this.time;
    }

    public boolean isSkeletal() {
        return false;
    }

    public static float getDefaultInterpolationThreshold() {
        return defaultInterpolationThreshold;
    }

    public static void setDefaultInterpolationThreshold(float defaultInterpolationThreshold) {
        AnimationAnimator.defaultInterpolationThreshold = defaultInterpolationThreshold;
    }
}

