/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import model.KeyFrame;
import model.SkeletalKeyFrame;
import model.Skeleton;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.SkeletalAnimation;
import model.animation.SkeletalAnimationAnimator;

public class AnimationUtils {
    private AnimationUtils() {
    }

    public static void cleanUnusedFrames(Animation animation, float error) {
        Vector3f transDiff = new Vector3f();
        Quaternion rotDiff = new Quaternion();
        block0: for (int i = 1; i < animation.size() - 1; ++i) {
            KeyFrame last = animation.getKeyFrame(i - 1);
            KeyFrame current = animation.getKeyFrame(i);
            KeyFrame next = animation.getKeyFrame(i + 1);
            float delta = (current.time - last.time) / (next.time - last.time);
            for (int j = 0; j < last.positions.length; ++j) {
                transDiff.interpolate(last.positions[j], next.positions[j], delta);
                transDiff.subtractLocal(current.positions[j]);
                if (transDiff.x + transDiff.y + transDiff.z > error) continue block0;
            }
            if (animation.isSkeletal()) {
                SkeletalKeyFrame lastSkeletal = (SkeletalKeyFrame)last;
                SkeletalKeyFrame nextSkeletal = (SkeletalKeyFrame)next;
                SkeletalKeyFrame currentSkeletal = (SkeletalKeyFrame)current;
                for (int j = 0; j < lastSkeletal.rotations.length; ++j) {
                    rotDiff.slerp(lastSkeletal.rotations[j], nextSkeletal.rotations[j], delta);
                    Quaternion cur = currentSkeletal.rotations[j];
                    if (AnimationUtils.diff(rotDiff.x, cur.x) || AnimationUtils.diff(rotDiff.y, cur.y) || AnimationUtils.diff(rotDiff.z, cur.z)) {
                        cur.negate();
                    }
                    rotDiff.addLocal(cur);
                    if (rotDiff.x + rotDiff.y + rotDiff.z + rotDiff.w > error) continue block0;
                }
            }
            animation.remove(i--);
        }
    }

    private static boolean diff(float f1, float f2) {
        float diff = f1 - f2;
        if ((double)diff < -1.0E-5 || (double)diff > 1.0E-5) {
            return AnimationUtils.sign(f1) != AnimationUtils.sign(f2);
        }
        return false;
    }

    private static float sign(float f) {
        if (f > 0.0f) {
            return 1.0f;
        }
        if (f < -0.0f) {
            return -1.0f;
        }
        return 0.0f;
    }

    public static void globalToLocal(SkeletalAnimation animation) {
        GlobalToLocal gl = new GlobalToLocal(animation);
        for (int i = 0; i < animation.size(); ++i) {
            gl.applyTo(animation.getSkeletal(i));
        }
        gl.resetTo(animation.getSkeleton());
        gl.applyTo(animation.getBaseFrameSkeletal());
    }

    public static void globalToLocal(Skeleton skeleton) {
        GlobalToLocal gl = new GlobalToLocal(skeleton);
        gl.applyTo(skeleton.getBindFrame());
    }

    public static AnimationAnimator createAnimator(Animation animation) {
        if (animation.isSkeletal()) {
            return new SkeletalAnimationAnimator(animation);
        }
        return new AnimationAnimator(animation);
    }

    public static KeyFrame copy(KeyFrame frame) {
        KeyFrame copy = frame.isSkeletal() ? new SkeletalKeyFrame() : new KeyFrame();
        Vector3f[] fromPos = frame.positions;
        Vector3f[] positions = new Vector3f[fromPos.length];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = new Vector3f(fromPos[i]);
        }
        copy.positions = positions;
        if (frame.isSkeletal()) {
            Quaternion[] fromRot = ((SkeletalKeyFrame)frame).rotations;
            Quaternion[] rotations = new Quaternion[fromRot.length];
            for (int i = 0; i < rotations.length; ++i) {
                rotations[i] = new Quaternion(fromRot[i]);
            }
            copy.rotations = rotations;
        }
        return copy;
    }

    public static void addBaseToOffset(Animation animation) {
        if (animation.isSkeletal()) {
            AnimationUtils.addBaseToOffsetSkel((SkeletalAnimation)animation);
        }
        KeyFrame base = animation.getBaseFrame();
        int positions = base.positions.length;
        for (int i = 0; i < animation.size(); ++i) {
            KeyFrame frame = animation.getKeyFrame(i);
            int pos = 0;
            for (int j = 0; j < positions; ++j) {
                if (!animation.getSuppliedPositions().get(j)) continue;
                frame.positions[pos++].addLocal(base.positions[j]);
            }
        }
    }

    private static void addBaseToOffsetSkel(SkeletalAnimation animation) {
        SkeletalKeyFrame base = animation.getBaseFrameSkeletal();
        int rotations = base.rotations.length;
        Quaternion temp = new Quaternion();
        for (int i = 0; i < animation.size(); ++i) {
            SkeletalKeyFrame frame = animation.getSkeletal(i);
            int pos = 0;
            for (int j = 0; j < rotations; ++j) {
                if (!animation.getSuppliedRotations().get(j)) continue;
                frame.rotations[pos].set(temp.set(base.rotations[j]).multLocal(frame.rotations[pos++]));
            }
        }
    }

    public static void fillIn(Animation animation) {
        if (animation.isSkeletal()) {
            AnimationUtils.fillInSkel((SkeletalAnimation)animation);
        }
        AnimationUtils.fillIn(animation.first(), animation.getBaseFrame());
        AnimationUtils.fillIn(animation.last(), animation.getBaseFrame());
        int numPositions = animation.first().positions.length;
        for (int i = 0; i < numPositions; ++i) {
            int prev = 0;
            int next = 0;
            do {
                ++next;
                while (animation.getKeyFrame((int)next).positions[i] == null) {
                    ++next;
                }
                if (next > prev + 1) {
                    KeyFrame prevFrame = animation.getKeyFrame(prev);
                    KeyFrame nextFrame = animation.getKeyFrame(next);
                    while (++prev < next) {
                        KeyFrame cur = animation.getKeyFrame(prev);
                        cur.positions[i] = new Vector3f();
                        float delta = (cur.time - prevFrame.time) / (nextFrame.time - prevFrame.time);
                        cur.positions[i].interpolate(prevFrame.positions[i], nextFrame.positions[i], delta);
                    }
                } else {
                    prev = next;
                }
            } while (next < animation.size() - 1);
        }
    }

    private static void fillInSkel(SkeletalAnimation animation) {
        AnimationUtils.fillInSkel(animation.firstSkeletal(), animation.getBaseFrameSkeletal());
        AnimationUtils.fillInSkel(animation.lastSkeletal(), animation.getBaseFrameSkeletal());
        int numRotations = animation.firstSkeletal().rotations.length;
        for (int i = 0; i < numRotations; ++i) {
            int prev = 0;
            int next = 0;
            do {
                ++next;
                while (animation.getSkeletal((int)next).rotations[i] == null) {
                    ++next;
                }
                if (next > prev + 1) {
                    SkeletalKeyFrame prevFrame = animation.getSkeletal(prev);
                    SkeletalKeyFrame nextFrame = animation.getSkeletal(next);
                    while (++prev < next) {
                        SkeletalKeyFrame cur = animation.getSkeletal(prev);
                        cur.rotations[i] = new Quaternion();
                        float delta = (cur.time - prevFrame.time) / (nextFrame.time - prevFrame.time);
                        cur.rotations[i].slerp(prevFrame.rotations[i], nextFrame.rotations[i], delta);
                    }
                } else {
                    prev = next;
                }
            } while (next < animation.size() - 1);
        }
    }

    private static void fillIn(KeyFrame target, KeyFrame base) {
        for (int i = 0; i < target.positions.length; ++i) {
            if (target.positions[i] != null) continue;
            target.positions[i] = new Vector3f(base.positions[i]);
        }
    }

    private static void fillInSkel(SkeletalKeyFrame target, SkeletalKeyFrame base) {
        for (int i = 0; i < target.rotations.length; ++i) {
            if (target.rotations[i] != null) continue;
            target.rotations[i] = new Quaternion(base.rotations[i]);
        }
    }

    private static class GlobalToLocal {
        Skeleton skeleton;
        SkeletalKeyFrame baseFrame;
        int[] rotIndex;
        int[] transIndex;

        private GlobalToLocal(Skeleton skeleton) {
            this.resetTo(skeleton);
        }

        private GlobalToLocal(SkeletalAnimation animation) {
            this.resetTo(animation);
        }

        void resetTo(Skeleton skeleton) {
            this.skeleton = skeleton;
            this.baseFrame = null;
            this.rotIndex = new int[skeleton.getJointCount()];
            this.transIndex = new int[skeleton.getJointCount()];
            for (int i = 0; i < skeleton.getJointCount(); ++i) {
                this.rotIndex[i] = i;
                this.transIndex[i] = i;
            }
        }

        void resetTo(SkeletalAnimation animation) {
            this.skeleton = animation.getSkeleton();
            this.baseFrame = (SkeletalKeyFrame)animation.getBaseFrame();
            this.rotIndex = new int[this.skeleton.getJointCount()];
            this.transIndex = new int[this.skeleton.getJointCount()];
            int ri = 0;
            int ti = 0;
            for (int i = 0; i < this.skeleton.getJointCount(); ++i) {
                this.rotIndex[i] = animation.getSuppliedRotations().get(i) ? ri++ : -1;
                this.transIndex[i] = animation.getSuppliedPositions().get(i) ? ti++ : -1;
            }
        }

        private Quaternion getRotation(SkeletalKeyFrame frame, int index) {
            if (index < 0) {
                return new Quaternion();
            }
            int ri = this.rotIndex[index];
            if (ri == -1) {
                return this.baseFrame.rotations[index];
            }
            return frame.rotations[ri];
        }

        private Vector3f getTranslation(KeyFrame frame, int index) {
            if (index < 0) {
                return new Vector3f();
            }
            int ti = this.transIndex[index];
            if (ti == -1) {
                return this.baseFrame.positions[index];
            }
            return frame.positions[ti];
        }

        void applyTo(SkeletalKeyFrame frame) {
            for (int i = this.skeleton.getJointCount() - 1; i >= 0; --i) {
                int parent = this.skeleton.getParents()[i];
                int ti = this.transIndex[i];
                int ri = this.rotIndex[i];
                Quaternion roti = this.getRotation(frame, i);
                Quaternion rotp = this.getRotation(frame, parent);
                Vector3f transi = this.getTranslation(frame, i);
                Vector3f transp = this.getTranslation(frame, parent);
                if (ti >= 0 && ri >= 0) {
                    roti.set(rotp.inverse().multLocal(roti));
                    transi.subtractLocal(transp);
                    rotp.inverse().multLocal(transi);
                    continue;
                }
                if (ti >= 0) {
                    rotp.inverse().multLocal(roti);
                    transi.subtractLocal(transp);
                    rotp.inverse().multLocal(transi);
                    continue;
                }
                if (ri < 0) continue;
                roti.set(rotp.inverse().multLocal(roti));
            }
        }
    }
}

