/*
 * Decompiled with CFR 0.152.
 */
package org.md5reader2.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.md5reader2.md5.MD5Joint;
import org.md5reader2.parser.MD5Parser;

public class MD5MeshParser
extends MD5Parser {
    @Override
    protected void parseSections(StreamTokenizer st, int token) throws IOException {
        if (st.sval != null) {
            if (st.sval.equals("MD5Version")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + (int)st.nval);
                this.model.setMd5Version((int)st.nval);
            } else if (st.sval.equals("commandline")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + st.sval);
                this.model.setCommandLine(st.sval);
            } else if (st.sval.equals("numJoints")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + (int)st.nval);
                this.model.setNumJoints((int)st.nval);
            } else if (st.sval.equals("numMeshes")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + (int)st.nval);
                this.model.setNumMeshes((int)st.nval);
            } else if (st.sval.equals("joints")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + st.sval);
                this.parseJoints(st, token);
            } else if (st.sval.equals("mesh")) {
                System.out.print("Key Name: " + st.sval + "; ");
                token = st.nextToken();
                System.out.println("Key Value: " + st.sval);
                this.parseMeshes(st, token);
            }
        }
    }

    private void parseJoints(StreamTokenizer st, int token) throws IOException {
        int jointIndex = 0;
        int pointer = 0;
        token = st.nextToken();
        while (st.ttype != 125) {
            switch (st.ttype) {
                case 34: {
                    System.out.println("Joint name (position " + pointer + "): " + st.sval);
                    this.model.getJoints()[jointIndex] = new MD5Joint(st.sval);
                    ++pointer;
                    break;
                }
                case -2: {
                    if (pointer == 1) {
                        this.model.getJoints()[jointIndex].setParent((int)st.nval);
                    } else if (pointer >= 2 && pointer <= 4) {
                        this.model.getJoints()[jointIndex].getBindPosePos().x = (float)st.nval;
                        System.out.println(" @ (position = " + pointer + ") " + st.nval);
                        token = st.nextToken();
                        this.model.getJoints()[jointIndex].getBindPosePos().y = (float)st.nval;
                        System.out.println(" @ (position = " + ++pointer + ") " + st.nval);
                        token = st.nextToken();
                        this.model.getJoints()[jointIndex].getBindPosePos().z = (float)st.nval;
                        System.out.println(" @ (position = " + ++pointer + ") " + st.nval);
                        System.out.println("Position vector setted to: " + this.model.getJoints()[jointIndex].getBindPosePos().toString());
                    } else if (pointer >= 5) {
                        this.model.getJoints()[jointIndex].getBindPoseOrient().x = (float)st.nval;
                        System.out.println(" @ (position = " + pointer + ") " + st.nval);
                        token = st.nextToken();
                        this.model.getJoints()[jointIndex].getBindPoseOrient().y = (float)st.nval;
                        System.out.println(" @ (position = " + ++pointer + ") " + st.nval);
                        token = st.nextToken();
                        this.model.getJoints()[jointIndex].getBindPoseOrient().z = (float)st.nval;
                        System.out.println(" @ (position = " + ++pointer + ") " + st.nval);
                        this.computeW(this.model.getJoints()[jointIndex].getBindPoseOrient());
                        System.out.println("Rotation quaternion setted to: " + this.model.getJoints()[jointIndex].getBindPoseOrient().toString());
                        this.model.getJoints()[jointIndex].applyBindPose();
                        System.out.println("Position vector setted to: " + this.model.getJoints()[jointIndex].getPos().toString());
                        System.out.println("Position vector setted to: " + this.model.getJoints()[jointIndex].getOrient().toString());
                        ++jointIndex;
                        break;
                    }
                    ++pointer;
                    break;
                }
                case 10: {
                    pointer = 0;
                    break;
                }
            }
            token = st.nextToken();
        }
        System.out.println("\n\nEnd of joints.");
    }

    private void parseMeshes(StreamTokenizer st, int token) {
    }
}

