/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.widget;

import com.jme.math.Vector3f;
import com.jmex.editors.swing.widget.ValuePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VectorPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private ValuePanel xPanel;
    private ValuePanel yPanel;
    private ValuePanel zPanel;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private boolean setting;

    public VectorPanel(float f, float f2, float f3) {
        super(new GridBagLayout());
        this.xPanel = new ValuePanel("X: ", "", f, f2, f3);
        this.xPanel.addChangeListener(this);
        this.yPanel = new ValuePanel("Y: ", "", f, f2, f3);
        this.yPanel.addChangeListener(this);
        this.zPanel = new ValuePanel("Z: ", "", f, f2, f3);
        this.zPanel.addChangeListener(this);
        this.add((Component)this.xPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.yPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.zPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setValue(Vector3f vector3f) {
        this.setting = true;
        this.xPanel.setValue(vector3f.x);
        this.yPanel.setValue(vector3f.y);
        this.zPanel.setValue(vector3f.z);
        this.setting = false;
    }

    public Vector3f getValue() {
        return new Vector3f(this.xPanel.getFloatValue(), this.yPanel.getFloatValue(), this.zPanel.getFloatValue());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.setting) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

