/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.Bone;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class BoneInfluence
implements Serializable,
Savable {
    private static final long serialVersionUID = 5904348001742899839L;
    public float weight;
    public Bone bone;
    public String boneId;
    public Vector3f vOffset;
    public Vector3f nOffset;

    public BoneInfluence() {
    }

    public BoneInfluence(Bone bone, float f) {
        this.bone = bone;
        this.weight = f;
    }

    public void assignBone(Bone bone) {
        if (this.boneId == null || bone == null) {
            return;
        }
        if (this.boneId.equals(bone.getName())) {
            this.bone = bone;
        } else {
            for (int i = 0; i < bone.getQuantity(); ++i) {
                if (!(bone.getChild(i) instanceof Bone)) continue;
                this.assignBone((Bone)bone.getChild(i));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoneInfluence)) {
            return false;
        }
        BoneInfluence boneInfluence = (BoneInfluence)object;
        return !(this.boneId != null ? !this.boneId.equals(boneInfluence.boneId) : boneInfluence.boneId != null);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.weight, "weight", 0.0f);
        outputCapsule.write(this.bone, "bone", null);
        outputCapsule.write(this.boneId, "boneId", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.weight = inputCapsule.readFloat("weight", 0.0f);
        this.bone = (Bone)inputCapsule.readSavable("bone", null);
        this.boneId = inputCapsule.readString("boneId", null);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

