/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.RelativeMouse;
import com.jme.input.thirdperson.ThirdPersonMouseLook;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;
import java.util.HashMap;

public class ChaseCamera
extends InputHandler {
    public static final String PROP_INITIALSPHERECOORDS = "sphereCoords";
    public static final String PROP_DAMPINGK = "dampingK";
    public static final String PROP_SPRINGK = "springK";
    public static final String PROP_TARGETOFFSET = "targetOffset";
    public static final String PROP_WORLDUPVECTOR = "worldUpVec";
    public static final String PROP_ENABLESPRING = "disableSpring";
    public static final String PROP_STAYBEHINDTARGET = "stayBehindTarget";
    public static final String PROP_MAINTAINAZIMUTH = "maintainAzimuth";
    public static final String PROP_MAXDISTANCE = "maxDistance";
    public static final String PROP_MINDISTANCE = "minDistance";
    public static final float DEFAULT_DAMPINGK = 12.0f;
    public static final float DEFAULT_SPRINGK = 36.0f;
    public static final float DEFAULT_MAXDISTANCE = 0.0f;
    public static final float DEFAULT_MINDISTANCE = 0.0f;
    public static final boolean DEFAULT_ENABLESPRING = true;
    public static final boolean DEFAULT_STAYBEHINDTARGET = false;
    public static final boolean DEFAULT_MAINTAINAZIMUTH = false;
    public static final Vector3f DEFAULT_WORLDUPVECTOR = Vector3f.UNIT_Y.clone();
    protected Vector3f idealSphereCoords;
    protected Vector3f idealPosition = new Vector3f();
    protected Camera cam;
    protected Vector3f velocity = new Vector3f();
    protected Spatial target;
    protected float dampingK;
    protected float springK;
    protected float maxDistance;
    protected float minDistance;
    protected boolean enableSpring;
    protected boolean stayBehindTarget;
    protected boolean looking;
    protected boolean maintainAzimuth;
    protected boolean forceAzimuthUpdate = false;
    protected Vector3f dirVec = new Vector3f();
    protected Vector3f worldUpVec = new Vector3f(DEFAULT_WORLDUPVECTOR);
    protected Vector3f upVec = new Vector3f();
    protected Vector3f leftVec = new Vector3f();
    protected Vector3f targetOffset = new Vector3f();
    protected Vector3f targetPos = new Vector3f();
    protected Vector3f oldCameraDir = new Vector3f();
    protected Vector3f compVect = new Vector3f();
    protected ThirdPersonMouseLook mouseLook;
    protected float speed;

    public ChaseCamera(Camera camera, Spatial spatial) {
        this(camera, spatial, null);
    }

    public ChaseCamera(Camera camera, Spatial spatial, HashMap hashMap) {
        this.cam = camera;
        this.target = spatial;
        this.setupMouse();
        this.updateProperties(hashMap);
    }

    protected void setupMouse() {
        RelativeMouse relativeMouse = new RelativeMouse("Mouse Input");
        relativeMouse.registerWithInputHandler(this);
        if (this.mouseLook != null) {
            this.removeAction(this.mouseLook);
        }
        this.mouseLook = new ThirdPersonMouseLook(relativeMouse, this, this.target);
        this.addAction(this.mouseLook);
    }

    public void updateProperties(HashMap hashMap) {
        if (this.mouseLook != null) {
            this.mouseLook.updateProperties(hashMap);
        }
        this.idealSphereCoords = this.idealSphereCoords == null && this.mouseLook != null ? new Vector3f((this.mouseLook.getMaxRollOut() - this.mouseLook.getMinRollOut()) / 2.0f, 0.0f, this.mouseLook.getMaxAscent() * 0.5f) : new Vector3f(0.0f, 0.0f, 0.0f);
        this.idealSphereCoords = (Vector3f)ChaseCamera.getObjectProp(hashMap, PROP_INITIALSPHERECOORDS, this.idealSphereCoords);
        this.worldUpVec = (Vector3f)ChaseCamera.getObjectProp(hashMap, PROP_WORLDUPVECTOR, DEFAULT_WORLDUPVECTOR);
        this.targetOffset = (Vector3f)ChaseCamera.getObjectProp(hashMap, PROP_TARGETOFFSET, new Vector3f());
        this.dampingK = ChaseCamera.getFloatProp(hashMap, PROP_DAMPINGK, 12.0f);
        this.springK = ChaseCamera.getFloatProp(hashMap, PROP_SPRINGK, 36.0f);
        this.maxDistance = ChaseCamera.getFloatProp(hashMap, PROP_MAXDISTANCE, 0.0f);
        this.minDistance = ChaseCamera.getFloatProp(hashMap, PROP_MINDISTANCE, 0.0f);
        this.enableSpring = ChaseCamera.getBooleanProp(hashMap, PROP_ENABLESPRING, true);
        this.stayBehindTarget = ChaseCamera.getBooleanProp(hashMap, PROP_STAYBEHINDTARGET, false);
        this.maintainAzimuth = ChaseCamera.getBooleanProp(hashMap, PROP_MAINTAINAZIMUTH, false);
    }

    public void setCamera(Camera camera) {
        this.cam = camera;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public void update(float f) {
        if (!this.isEnabled()) {
            return;
        }
        super.update(f);
        Vector3f vector3f = this.cam.getLocation();
        this.updateTargetPosition(vector3f);
        if (!Vector3f.isValidVector(vector3f) || !Vector3f.isValidVector(this.targetPos)) {
            return;
        }
        this.updateIdealAzimuth(f, vector3f);
        this.convertIdealSphereToCartesian();
        this.updateCameraPosition(f, vector3f);
        this.enforceMinMaxDistance(vector3f);
        this.cam.lookAt(this.targetPos, this.worldUpVec);
        if (this.maintainAzimuth) {
            this.cam.update();
        }
    }

    protected void updateCameraPosition(float f, Vector3f vector3f) {
        if (!this.enableSpring) {
            vector3f.set(this.idealPosition);
        } else {
            Vector3f vector3f2 = this.compVect;
            vector3f.subtract(this.idealPosition, vector3f2);
            vector3f2.multLocal(-this.springK).subtractLocal(this.velocity.x * this.dampingK, this.velocity.y * this.dampingK, this.velocity.z * this.dampingK);
            this.velocity.addLocal(vector3f2.multLocal(f));
            if (!Vector3f.isValidVector(this.velocity)) {
                this.velocity.zero();
            }
            vector3f.addLocal(this.velocity.x * f, this.velocity.y * f, this.velocity.z * f);
        }
    }

    protected void updateTargetPosition(Vector3f vector3f) {
        this.targetPos.set(this.target.getWorldTranslation());
        if (!Vector3f.isValidVector(vector3f)) {
            vector3f.set(this.targetPos);
        }
        if (!Vector3f.isValidVector(vector3f) || !Vector3f.isValidVector(this.targetPos)) {
            return;
        }
        this.targetPos.addLocal(this.targetOffset);
    }

    protected void enforceMinMaxDistance(Vector3f vector3f) {
        float f;
        if ((this.maxDistance > 0.0f || this.minDistance > 0.0f) && ((f = vector3f.distance(this.targetPos)) > this.maxDistance || f < this.minDistance)) {
            Vector3f vector3f2 = this.targetPos.subtract(vector3f, this.compVect);
            vector3f2.normalizeLocal();
            if (f > this.maxDistance) {
                vector3f2.multLocal(this.maxDistance - f);
                vector3f.subtractLocal(vector3f2);
            } else if (f < this.minDistance) {
                vector3f2.multLocal(f - this.minDistance);
                vector3f.addLocal(vector3f2);
            }
        }
    }

    protected void convertIdealSphereToCartesian() {
        if (this.worldUpVec.y == 1.0f) {
            FastMath.sphericalToCartesian(this.idealSphereCoords, this.idealPosition).addLocal(this.targetPos);
        } else if (this.worldUpVec.z == 1.0f) {
            FastMath.sphericalToCartesianZ(this.idealSphereCoords, this.idealPosition).addLocal(this.targetPos);
        }
    }

    protected void updateIdealAzimuth(float f, Vector3f vector3f) {
        if (!this.maintainAzimuth || this.forceAzimuthUpdate) {
            float f2;
            float f3;
            if (this.stayBehindTarget && !this.looking) {
                Vector3f vector3f2 = this.compVect;
                this.target.getLocalRotation().getRotationColumn(2, vector3f2);
                vector3f2.negateLocal();
                f3 = vector3f2.x;
                f2 = vector3f2.z;
                if (this.worldUpVec.z == 1.0f) {
                    f2 = vector3f2.y;
                }
            } else {
                this.forceAzimuthUpdate = false;
                f3 = vector3f.x - this.targetPos.x;
                f2 = vector3f.z - this.targetPos.z;
                if (this.worldUpVec.z == 1.0f) {
                    f2 = vector3f.y - this.targetPos.y;
                }
            }
            this.idealSphereCoords.y = FastMath.atan2(f2, f3);
        }
    }

    public Vector3f getIdealSphereCoords() {
        return this.idealSphereCoords;
    }

    public Vector3f getIdealPosition() {
        return this.idealPosition;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float f) {
        this.maxDistance = f;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(float f) {
        this.minDistance = f;
    }

    public float getDampingK() {
        return this.dampingK;
    }

    public void setDampingK(float f) {
        this.dampingK = f;
    }

    public float getSpringK() {
        return this.springK;
    }

    public void setSpringK(float f) {
        this.springK = f;
    }

    public Spatial getTarget() {
        return this.target;
    }

    public void setTarget(Spatial spatial) {
        this.target = spatial;
        if (this.mouseLook != null) {
            this.mouseLook.setTarget(spatial);
        }
    }

    public Vector3f getTargetOffset() {
        return this.targetOffset;
    }

    public void setTargetOffset(Vector3f vector3f) {
        this.targetOffset.set(vector3f);
    }

    public void setWorldUpVec(Vector3f vector3f) {
        this.worldUpVec.set(vector3f);
    }

    public ThirdPersonMouseLook getMouseLook() {
        return this.mouseLook;
    }

    public boolean isEnableSpring() {
        return this.enableSpring;
    }

    public void setEnableSpring(boolean bl) {
        this.enableSpring = bl;
    }

    public boolean isStayBehindTarget() {
        return this.stayBehindTarget;
    }

    public void setStayBehindTarget(boolean bl) {
        this.stayBehindTarget = bl;
    }

    public void setActionSpeed(float f) {
        super.setActionSpeed(f);
        this.speed = f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setLooking(boolean bl) {
        this.looking = bl;
    }

    public boolean isLooking() {
        return this.looking;
    }

    public void setMaintainAzimuth(boolean bl) {
        this.maintainAzimuth = bl;
    }

    public boolean isMaintainAzimuth() {
        return this.maintainAzimuth;
    }

    public boolean isForceAzimuthUpdate() {
        return this.forceAzimuthUpdate;
    }

    public void setForceAzimuthUpdate(boolean bl) {
        this.forceAzimuthUpdate = bl;
    }

    public void setIdealSphereCoords(Vector3f vector3f) {
        this.idealSphereCoords = vector3f;
    }
}

