/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.util;

import com.jme.input.InputHandler;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.util.SyntheticButton;
import com.jme.intersection.PickData;
import com.jme.intersection.TrianglePickResults;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import java.util.HashMap;
import java.util.Map;

public class PickDevice {
    private final Spatial root;
    private final InputHandler inputHandler;
    private final Vector2f mousePosition = new Vector2f();
    private final Vector3f pickedScreenPos = new Vector3f();
    private PickAction pickAction;
    private MoveAction moveAction;
    private Geometry picked;
    private SyntheticButton pickedButton;
    private Map<Spatial, SyntheticButton> buttons = new HashMap<Spatial, SyntheticButton>();

    public PickDevice(Spatial spatial, InputHandler inputHandler) {
        this.root = spatial;
        this.inputHandler = new InputHandler();
        inputHandler.addToAttachedHandlers(this.inputHandler);
        this.pickAction = new PickAction();
        this.inputHandler.addAction(this.pickAction, "mouse", 0, -1, false);
        this.moveAction = new MoveAction();
        this.inputHandler.addAction(this.moveAction, "mouse", -1, Integer.MIN_VALUE, false);
    }

    public SyntheticButton createButton(Spatial spatial) {
        SyntheticButton syntheticButton = this.buttons.get(spatial);
        if (syntheticButton == null) {
            syntheticButton = new SyntheticButton(spatial.getName());
            this.buttons.put(spatial, syntheticButton);
        }
        return syntheticButton;
    }

    public SyntheticButton getPickedButton() {
        return this.pickedButton;
    }

    private class MoveAction
    extends InputAction {
        private MoveAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            switch (inputActionEvent.getTriggerIndex()) {
                case 0: {
                    ((PickDevice)PickDevice.this).mousePosition.x = inputActionEvent.getTriggerPosition() * (float)DisplaySystem.getDisplaySystem().getWidth();
                    break;
                }
                case 1: {
                    ((PickDevice)PickDevice.this).mousePosition.y = inputActionEvent.getTriggerPosition() * (float)DisplaySystem.getDisplaySystem().getHeight();
                    break;
                }
                case 2: {
                    if (inputActionEvent.getTriggerDelta() > 0.0f) {
                        ((PickDevice)PickDevice.this).pickedScreenPos.z += (1.0f - ((PickDevice)PickDevice.this).pickedScreenPos.z) / 10.0f;
                        break;
                    }
                    ((PickDevice)PickDevice.this).pickedScreenPos.z = (10.0f * ((PickDevice)PickDevice.this).pickedScreenPos.z - 1.0f) / 9.0f;
                }
            }
        }
    }

    private class PickAction
    extends InputAction {
        private final Ray pickRay = new Ray();
        private final TrianglePickResults pickResults = new TrianglePickResults();

        private PickAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            block5: {
                if (inputActionEvent.getTriggerPressed()) {
                    DisplaySystem.getDisplaySystem().getWorldCoordinates(PickDevice.this.mousePosition, 0.0f, this.pickRay.origin);
                    DisplaySystem.getDisplaySystem().getWorldCoordinates(PickDevice.this.mousePosition, 0.3f, this.pickRay.direction);
                    this.pickRay.direction.subtractLocal(this.pickRay.origin).normalizeLocal();
                    this.pickResults.clear();
                    this.pickResults.setCheckDistance(true);
                    PickDevice.this.root.findPick(this.pickRay, this.pickResults);
                    for (int i = 0; i < this.pickResults.getNumber(); ++i) {
                        Geometry geometry;
                        PickData pickData = this.pickResults.getPickData(i);
                        if (pickData.getTargetTris() == null || pickData.getTargetTris().size() <= 0) continue;
                        for (Spatial spatial = geometry = pickData.getTargetMesh().getParentGeom(); spatial != null; spatial = spatial.getParent()) {
                            SyntheticButton syntheticButton = (SyntheticButton)PickDevice.this.buttons.get(spatial);
                            if (syntheticButton == null) continue;
                            syntheticButton.trigger(0.0f, '\u0000', 0.0f, inputActionEvent.getTriggerPressed(), geometry);
                            PickDevice.this.pickedButton = syntheticButton;
                            PickDevice.this.picked = geometry;
                            break block5;
                        }
                    }
                } else if (PickDevice.this.pickedButton != null) {
                    PickDevice.this.pickedButton.trigger(0.0f, '\u0000', 0.0f, inputActionEvent.getTriggerPressed(), PickDevice.this.picked);
                    PickDevice.this.pickedButton = null;
                }
            }
        }
    }
}

