/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.math.FastMath;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.IntBuffer;

public class Intersection {
    public static final double EPSILON = 1.0E-12;
    private static final Vector3f tempVa = new Vector3f();
    private static final Vector3f tempVb = new Vector3f();
    private static final Vector3f tempVc = new Vector3f();
    private static final Vector3f tempVd = new Vector3f();
    private static final Vector3f tempVe = new Vector3f();
    private static final float[] tempFa = new float[2];
    private static final float[] tempFb = new float[2];
    private static final Vector2f tempV2a = new Vector2f();
    private static final Vector2f tempV2b = new Vector2f();

    public static boolean meshIntersection(TriangleBatch triangleBatch, TriangleBatch triangleBatch2) {
        int n;
        IntBuffer intBuffer = triangleBatch.getIndexBuffer();
        IntBuffer intBuffer2 = triangleBatch2.getIndexBuffer();
        TransformMatrix transformMatrix = new TransformMatrix();
        transformMatrix.setRotationQuaternion(triangleBatch.getParentGeom().getWorldRotation());
        transformMatrix.setTranslation(triangleBatch.getParentGeom().getWorldTranslation());
        transformMatrix.setScale(triangleBatch.getParentGeom().getWorldScale());
        TransformMatrix transformMatrix2 = new TransformMatrix();
        transformMatrix2.setRotationQuaternion(triangleBatch2.getParentGeom().getWorldRotation());
        transformMatrix2.setTranslation(triangleBatch2.getParentGeom().getWorldTranslation());
        transformMatrix2.setScale(triangleBatch2.getParentGeom().getWorldScale());
        Vector3f[] vector3fArray = BufferUtils.getVector3Array(triangleBatch.getVertexBuffer());
        for (int i = 0; i < vector3fArray.length; ++i) {
            transformMatrix.multPoint(vector3fArray[i]);
        }
        Vector3f[] vector3fArray2 = BufferUtils.getVector3Array(triangleBatch2.getVertexBuffer());
        for (n = 0; n < vector3fArray2.length; ++n) {
            transformMatrix2.multPoint(vector3fArray2[n]);
        }
        for (n = 0; n < triangleBatch.getTriangleCount(); ++n) {
            for (int i = 0; i < triangleBatch2.getTriangleCount(); ++i) {
                if (!Intersection.intersection(vector3fArray[intBuffer.get(n * 3 + 0)], vector3fArray[intBuffer.get(n * 3 + 1)], vector3fArray[intBuffer.get(n * 3 + 2)], vector3fArray2[intBuffer2.get(i * 3 + 0)], vector3fArray2[intBuffer2.get(i * 3 + 1)], vector3fArray2[intBuffer2.get(i * 3 + 2)])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersection(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f vector3f6) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        Vector3f vector3f7 = tempVa;
        Vector3f vector3f8 = tempVb;
        Vector3f vector3f9 = tempVc;
        Vector3f vector3f10 = tempVd;
        Vector3f vector3f11 = tempVe;
        float[] fArray = tempFa;
        float[] fArray2 = tempFb;
        vector3f2.subtract(vector3f, vector3f7);
        vector3f3.subtract(vector3f, vector3f8);
        vector3f7.cross(vector3f8, vector3f9);
        float f7 = -vector3f9.dot(vector3f);
        float f8 = vector3f9.dot(vector3f4) + f7;
        float f9 = vector3f9.dot(vector3f5) + f7;
        float f10 = vector3f9.dot(vector3f6) + f7;
        if ((double)FastMath.abs(f8) < 1.0E-12) {
            f8 = 0.0f;
        }
        if ((double)FastMath.abs(f9) < 1.0E-12) {
            f9 = 0.0f;
        }
        if ((double)FastMath.abs(f10) < 1.0E-12) {
            f10 = 0.0f;
        }
        float f11 = f8 * f9;
        float f12 = f8 * f10;
        if (f11 > 0.0f && f12 > 0.0f) {
            return false;
        }
        vector3f5.subtract(vector3f4, vector3f7);
        vector3f6.subtract(vector3f4, vector3f8);
        vector3f7.cross(vector3f8, vector3f10);
        float f13 = -vector3f10.dot(vector3f4);
        float f14 = vector3f10.dot(vector3f) + f13;
        float f15 = vector3f10.dot(vector3f2) + f13;
        float f16 = vector3f10.dot(vector3f3) + f13;
        if ((double)FastMath.abs(f14) < 1.0E-12) {
            f14 = 0.0f;
        }
        if ((double)FastMath.abs(f15) < 1.0E-12) {
            f15 = 0.0f;
        }
        if ((double)FastMath.abs(f16) < 1.0E-12) {
            f16 = 0.0f;
        }
        float f17 = f14 * f15;
        float f18 = f14 * f16;
        if (f17 > 0.0f && f18 > 0.0f) {
            return false;
        }
        vector3f9.cross(vector3f10, vector3f11);
        float f19 = FastMath.abs(vector3f11.x);
        boolean bl = false;
        float f20 = FastMath.abs(vector3f11.y);
        float f21 = FastMath.abs(vector3f11.z);
        if (f20 > f19) {
            f19 = f20;
            bl = true;
        }
        if (f21 > f19) {
            f19 = f21;
            f6 = vector3f.z;
            f5 = vector3f2.z;
            f4 = vector3f3.z;
            f3 = vector3f4.z;
            f2 = vector3f5.z;
            f = vector3f6.z;
        } else if (bl) {
            f6 = vector3f.y;
            f5 = vector3f2.y;
            f4 = vector3f3.y;
            f3 = vector3f4.y;
            f2 = vector3f5.y;
            f = vector3f6.y;
        } else {
            f6 = vector3f.x;
            f5 = vector3f2.x;
            f4 = vector3f3.x;
            f3 = vector3f4.x;
            f2 = vector3f5.x;
            f = vector3f6.x;
        }
        Vector3f vector3f12 = tempVa;
        Vector2f vector2f = tempV2a;
        if (Intersection.newComputeIntervals(f6, f5, f4, f14, f15, f16, f17, f18, vector3f12, vector2f)) {
            return Intersection.coplanarTriTri(vector3f9, vector3f, vector3f2, vector3f3, vector3f4, vector3f5, vector3f6);
        }
        Vector3f vector3f13 = tempVb;
        Vector2f vector2f2 = tempV2b;
        if (Intersection.newComputeIntervals(f3, f2, f, f8, f9, f10, f11, f12, vector3f13, vector2f2)) {
            return Intersection.coplanarTriTri(vector3f9, vector3f, vector3f2, vector3f3, vector3f4, vector3f5, vector3f6);
        }
        float f22 = vector2f.x * vector2f.y;
        float f23 = vector2f2.x * vector2f2.y;
        float f24 = f22 * f23;
        float f25 = vector3f12.x * f24;
        fArray[0] = f25 + vector3f12.y * vector2f.y * f23;
        fArray[1] = f25 + vector3f12.z * vector2f.x * f23;
        f25 = vector3f13.x * f24;
        fArray2[0] = f25 + vector3f13.y * f22 * vector2f2.y;
        fArray2[1] = f25 + vector3f13.z * f22 * vector2f2.x;
        Intersection.sort(fArray);
        Intersection.sort(fArray2);
        return !(fArray[1] < fArray2[0]) && !(fArray2[1] < fArray[0]);
    }

    private static void sort(float[] fArray) {
        if (fArray[0] > fArray[1]) {
            float f = fArray[0];
            fArray[0] = fArray[1];
            fArray[1] = f;
        }
    }

    private static boolean newComputeIntervals(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector3f vector3f, Vector2f vector2f) {
        if (f7 > 0.0f) {
            vector3f.x = f3;
            vector3f.y = (f - f3) * f6;
            vector3f.z = (f2 - f3) * f6;
            vector2f.x = f6 - f4;
            vector2f.y = f6 - f5;
        } else if (f8 > 0.0f) {
            vector3f.x = f2;
            vector3f.y = (f - f2) * f5;
            vector3f.z = (f3 - f2) * f5;
            vector2f.x = f5 - f4;
            vector2f.y = f5 - f6;
        } else if (f5 * f6 > 0.0f || f4 != 0.0f) {
            vector3f.x = f;
            vector3f.y = (f2 - f) * f4;
            vector3f.z = (f3 - f) * f4;
            vector2f.x = f4 - f5;
            vector2f.y = f4 - f6;
        } else if (f5 != 0.0f) {
            vector3f.x = f2;
            vector3f.y = (f - f2) * f5;
            vector3f.z = (f3 - f2) * f5;
            vector2f.x = f5 - f4;
            vector2f.y = f5 - f6;
        } else if (f6 != 0.0f) {
            vector3f.x = f3;
            vector3f.y = (f - f3) * f6;
            vector3f.z = (f2 - f3) * f6;
            vector2f.x = f6 - f4;
            vector2f.y = f6 - f5;
        } else {
            return true;
        }
        return false;
    }

    private static boolean coplanarTriTri(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f vector3f6, Vector3f vector3f7) {
        int n;
        int n2;
        Vector3f vector3f8 = new Vector3f();
        vector3f8.x = FastMath.abs(vector3f.x);
        vector3f8.y = FastMath.abs(vector3f.y);
        vector3f8.z = FastMath.abs(vector3f.z);
        if (vector3f8.x > vector3f8.y) {
            if (vector3f8.x > vector3f8.z) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (vector3f8.z > vector3f8.y) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        float[] fArray = new float[3];
        vector3f2.toArray(fArray);
        float[] fArray2 = new float[3];
        vector3f3.toArray(fArray2);
        float[] fArray3 = new float[3];
        vector3f4.toArray(fArray3);
        float[] fArray4 = new float[3];
        vector3f5.toArray(fArray4);
        float[] fArray5 = new float[3];
        vector3f6.toArray(fArray5);
        float[] fArray6 = new float[3];
        vector3f7.toArray(fArray6);
        if (Intersection.edgeAgainstTriEdges(fArray, fArray2, fArray4, fArray5, fArray6, n2, n)) {
            return true;
        }
        if (Intersection.edgeAgainstTriEdges(fArray2, fArray3, fArray4, fArray5, fArray6, n2, n)) {
            return true;
        }
        if (Intersection.edgeAgainstTriEdges(fArray3, fArray, fArray4, fArray5, fArray6, n2, n)) {
            return true;
        }
        Intersection.pointInTri(fArray, fArray4, fArray5, fArray6, n2, n);
        Intersection.pointInTri(fArray4, fArray, fArray2, fArray3, n2, n);
        return false;
    }

    private static boolean pointInTri(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n, int n2) {
        float f = fArray3[n2] - fArray2[n2];
        float f2 = -(fArray3[n] - fArray2[n]);
        float f3 = -f * fArray2[n] - f2 * fArray2[n2];
        float f4 = f * fArray[n] + f2 * fArray[n2] + f3;
        f = fArray4[n2] - fArray3[n2];
        f2 = -(fArray4[n] - fArray3[n]);
        f3 = -f * fArray3[n] - f2 * fArray3[n2];
        float f5 = f * fArray[n] + f2 * fArray[n2] + f3;
        f = fArray2[n2] - fArray4[n2];
        f2 = -(fArray2[n] - fArray4[n]);
        f3 = -f * fArray4[n] - f2 * fArray4[n2];
        float f6 = f * fArray[n] + f2 * fArray[n2] + f3;
        return (double)(f4 * f5) > 0.0 && (double)(f4 * f6) > 0.0;
    }

    private static boolean edgeAgainstTriEdges(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, int n, int n2) {
        float f = fArray2[n] - fArray[n];
        float f2 = fArray2[n2] - fArray[n2];
        if (Intersection.edgeEdgeTest(fArray, fArray3, fArray4, n, n2, f, f2)) {
            return true;
        }
        if (Intersection.edgeEdgeTest(fArray, fArray4, fArray5, n, n2, f, f2)) {
            return true;
        }
        return Intersection.edgeEdgeTest(fArray, fArray5, fArray3, n, n2, f, f2);
    }

    private static boolean edgeEdgeTest(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, float f, float f2) {
        float f3 = fArray2[n] - fArray3[n];
        float f4 = fArray2[n2] - fArray3[n2];
        float f5 = fArray[n] - fArray2[n];
        float f6 = fArray[n2] - fArray2[n2];
        float f7 = f2 * f3 - f * f4;
        float f8 = f4 * f5 - f3 * f6;
        if (f7 > 0.0f && f8 >= 0.0f && f8 <= f7 || f7 < 0.0f && f8 <= 0.0f && f8 >= f7) {
            float f9 = f * f6 - f2 * f5;
            if (f7 > 0.0f ? f9 >= 0.0f && f9 <= f7 : f9 <= 0.0f && f9 >= f7) {
                return true;
            }
        }
        return false;
    }
}

