/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class LightNode
extends Node {
    private static final long serialVersionUID = 1L;
    private Light light;
    private LightState lightState;

    public LightNode() {
    }

    public LightNode(String string, LightState lightState) {
        super(string);
        this.lightState = lightState;
    }

    public void setLight(Light light) {
        this.light = light;
        this.lightState.detachAll();
        this.lightState.attach(light);
    }

    public Light getLight() {
        return this.light;
    }

    public void setTarget(Spatial spatial) {
        spatial.setRenderState(this.lightState);
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        if (this.light == null) {
            return;
        }
        switch (this.light.getType()) {
            case 0: {
                DirectionalLight directionalLight = (DirectionalLight)this.light;
                directionalLight.getDirection().set(this.worldTranslation).negateLocal();
                break;
            }
            case 1: {
                PointLight pointLight = (PointLight)this.light;
                pointLight.getLocation().set(this.worldTranslation);
                break;
            }
            case 2: {
                SpotLight spotLight = (SpotLight)this.light;
                spotLight.getLocation().set(this.worldTranslation);
                this.worldRotation.getRotationColumn(2, spotLight.getDirection());
                break;
            }
        }
    }

    public String toString() {
        String string = null;
        if (this.getLight() != null) {
            switch (this.getLight().getType()) {
                case 0: {
                    string = "Directional";
                    break;
                }
                case 1: {
                    string = "Point";
                    break;
                }
                case 2: {
                    string = "Spot";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
        }
        return this.getName() + " (" + string + ")";
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.light, "light", null);
        outputCapsule.write(this.lightState, "lightState", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.light = (Light)inputCapsule.readSavable("light", null);
        this.lightState = (LightState)inputCapsule.readSavable("lightState", null);
    }
}

