/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import java.io.Serializable;

public class LineSegment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector3f origin;
    private Vector3f direction;
    private float extent;
    private static final Vector3f compVec1 = new Vector3f();

    public LineSegment() {
        this.origin = new Vector3f();
        this.direction = new Vector3f();
    }

    public LineSegment(LineSegment lineSegment) {
        this.origin = new Vector3f(lineSegment.getOrigin());
        this.direction = new Vector3f(lineSegment.getDirection());
        this.extent = lineSegment.getExtent();
    }

    public LineSegment(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.origin = vector3f;
        this.direction = vector3f2;
        this.extent = f;
    }

    public void set(LineSegment lineSegment) {
        this.origin = new Vector3f(lineSegment.getOrigin());
        this.direction = new Vector3f(lineSegment.getDirection());
        this.extent = lineSegment.getExtent();
    }

    public float distance(Vector3f vector3f) {
        return FastMath.sqrt(this.distanceSquared(vector3f));
    }

    public float distance(LineSegment lineSegment) {
        return FastMath.sqrt(this.distanceSquared(lineSegment));
    }

    public float distance(Ray ray) {
        return FastMath.sqrt(this.distanceSquared(ray));
    }

    public float distanceSquared(Vector3f vector3f) {
        vector3f.subtract(this.origin, compVec1);
        float f = this.direction.dot(compVec1);
        if (-this.extent < f) {
            if (f < this.extent) {
                this.origin.add(this.direction.mult(f, compVec1), compVec1);
            } else {
                this.origin.add(this.direction.mult(this.extent, compVec1), compVec1);
            }
        } else {
            this.origin.subtract(this.direction.mult(this.extent, compVec1), compVec1);
        }
        compVec1.subtractLocal(vector3f);
        return compVec1.lengthSquared();
    }

    public float distanceSquared(LineSegment lineSegment) {
        float f;
        this.origin.subtract(lineSegment.getOrigin(), compVec1);
        float f2 = -this.direction.dot(lineSegment.getDirection());
        float f3 = compVec1.dot(this.direction);
        float f4 = -compVec1.dot(lineSegment.getDirection());
        float f5 = compVec1.lengthSquared();
        float f6 = FastMath.abs(1.0f - f2 * f2);
        if (f6 >= 1.1920929E-7f) {
            float f7 = f2 * f4 - f3;
            float f8 = f2 * f3 - f4;
            float f9 = this.extent * f6;
            float f10 = lineSegment.getExtent() * f6;
            if (f7 >= -f9) {
                if (f7 <= f9) {
                    if (f8 >= -f10) {
                        if (f8 <= f10) {
                            float f11 = 1.0f / f6;
                            f = (f7 *= f11) * (f7 + f2 * (f8 *= f11) + 2.0f * f3) + f8 * (f2 * f7 + f8 + 2.0f * f4) + f5;
                        } else {
                            f8 = lineSegment.getExtent();
                            float f12 = -(f2 * f8 + f3);
                            if (f12 < -this.extent) {
                                f7 = -this.extent;
                                f = f7 * (f7 - 2.0f * f12) + f8 * (f8 + 2.0f * f4) + f5;
                            } else if (f12 <= this.extent) {
                                f7 = f12;
                                f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                            } else {
                                f7 = this.extent;
                                f = f7 * (f7 - 2.0f * f12) + f8 * (f8 + 2.0f * f4) + f5;
                            }
                        }
                    } else {
                        f8 = -lineSegment.getExtent();
                        float f13 = -(f2 * f8 + f3);
                        if (f13 < -this.extent) {
                            f7 = -this.extent;
                            f = f7 * (f7 - 2.0f * f13) + f8 * (f8 + 2.0f * f4) + f5;
                        } else if (f13 <= this.extent) {
                            f7 = f13;
                            f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                        } else {
                            f7 = this.extent;
                            f = f7 * (f7 - 2.0f * f13) + f8 * (f8 + 2.0f * f4) + f5;
                        }
                    }
                } else if (f8 >= -f10) {
                    if (f8 <= f10) {
                        f7 = this.extent;
                        float f14 = -(f2 * f7 + f4);
                        if (f14 < -lineSegment.getExtent()) {
                            f8 = -lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f14) + f7 * (f7 + 2.0f * f3) + f5;
                        } else if (f14 <= lineSegment.getExtent()) {
                            f8 = f14;
                            f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                        } else {
                            f8 = lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f14) + f7 * (f7 + 2.0f * f3) + f5;
                        }
                    } else {
                        f8 = lineSegment.getExtent();
                        float f15 = -(f2 * f8 + f3);
                        if (f15 < -this.extent) {
                            f7 = -this.extent;
                            f = f7 * (f7 - 2.0f * f15) + f8 * (f8 + 2.0f * f4) + f5;
                        } else if (f15 <= this.extent) {
                            f7 = f15;
                            f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                        } else {
                            f7 = this.extent;
                            float f16 = -(f2 * f7 + f4);
                            if (f16 < -lineSegment.getExtent()) {
                                f8 = -lineSegment.getExtent();
                                f = f8 * (f8 - 2.0f * f16) + f7 * (f7 + 2.0f * f3) + f5;
                            } else if (f16 <= lineSegment.getExtent()) {
                                f8 = f16;
                                f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                            } else {
                                f8 = lineSegment.getExtent();
                                f = f8 * (f8 - 2.0f * f16) + f7 * (f7 + 2.0f * f3) + f5;
                            }
                        }
                    }
                } else {
                    f8 = -lineSegment.getExtent();
                    float f17 = -(f2 * f8 + f3);
                    if (f17 < -this.extent) {
                        f7 = -this.extent;
                        f = f7 * (f7 - 2.0f * f17) + f8 * (f8 + 2.0f * f4) + f5;
                    } else if (f17 <= this.extent) {
                        f7 = f17;
                        f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                    } else {
                        f7 = this.extent;
                        float f18 = -(f2 * f7 + f4);
                        if (f18 > lineSegment.getExtent()) {
                            f8 = lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f18) + f7 * (f7 + 2.0f * f3) + f5;
                        } else if (f18 >= -lineSegment.getExtent()) {
                            f8 = f18;
                            f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                        } else {
                            f8 = -lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f18) + f7 * (f7 + 2.0f * f3) + f5;
                        }
                    }
                }
            } else if (f8 >= -f10) {
                if (f8 <= f10) {
                    f7 = -this.extent;
                    float f19 = -(f2 * f7 + f4);
                    if (f19 < -lineSegment.getExtent()) {
                        f8 = -lineSegment.getExtent();
                        f = f8 * (f8 - 2.0f * f19) + f7 * (f7 + 2.0f * f3) + f5;
                    } else if (f19 <= lineSegment.getExtent()) {
                        f8 = f19;
                        f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                    } else {
                        f8 = lineSegment.getExtent();
                        f = f8 * (f8 - 2.0f * f19) + f7 * (f7 + 2.0f * f3) + f5;
                    }
                } else {
                    f8 = lineSegment.getExtent();
                    float f20 = -(f2 * f8 + f3);
                    if (f20 > this.extent) {
                        f7 = this.extent;
                        f = f7 * (f7 - 2.0f * f20) + f8 * (f8 + 2.0f * f4) + f5;
                    } else if (f20 >= -this.extent) {
                        f7 = f20;
                        f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                    } else {
                        f7 = -this.extent;
                        float f21 = -(f2 * f7 + f4);
                        if (f21 < -lineSegment.getExtent()) {
                            f8 = -lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f21) + f7 * (f7 + 2.0f * f3) + f5;
                        } else if (f21 <= lineSegment.getExtent()) {
                            f8 = f21;
                            f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                        } else {
                            f8 = lineSegment.getExtent();
                            f = f8 * (f8 - 2.0f * f21) + f7 * (f7 + 2.0f * f3) + f5;
                        }
                    }
                }
            } else {
                f8 = -lineSegment.getExtent();
                float f22 = -(f2 * f8 + f3);
                if (f22 > this.extent) {
                    f7 = this.extent;
                    f = f7 * (f7 - 2.0f * f22) + f8 * (f8 + 2.0f * f4) + f5;
                } else if (f22 >= -this.extent) {
                    f7 = f22;
                    f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                } else {
                    f7 = -this.extent;
                    float f23 = -(f2 * f7 + f4);
                    if (f23 < -lineSegment.getExtent()) {
                        f8 = -lineSegment.getExtent();
                        f = f8 * (f8 - 2.0f * f23) + f7 * (f7 + 2.0f * f3) + f5;
                    } else if (f23 <= lineSegment.getExtent()) {
                        f8 = f23;
                        f = -f8 * f8 + f7 * (f7 + 2.0f * f3) + f5;
                    } else {
                        f8 = lineSegment.getExtent();
                        f = f8 * (f8 - 2.0f * f23) + f7 * (f7 + 2.0f * f3) + f5;
                    }
                }
            }
        } else {
            float f24;
            float f25 = f2 > 0.0f ? -1.0f : 1.0f;
            float f26 = 0.5f * (f3 - f25 * f4);
            float f27 = -f26;
            if (f27 < -(f24 = this.extent + lineSegment.getExtent())) {
                f27 = -f24;
            } else if (f27 > f24) {
                f27 = f24;
            }
            f = f27 * (f27 + 2.0f * f26) + f5;
        }
        return FastMath.abs(f);
    }

    public float distanceSquared(Ray ray) {
        float f;
        Vector3f vector3f = ray.getOrigin().subtract(this.origin);
        float f2 = -ray.getDirection().dot(this.direction);
        float f3 = vector3f.dot(ray.getDirection());
        float f4 = -vector3f.dot(this.direction);
        float f5 = vector3f.lengthSquared();
        float f6 = FastMath.abs(1.0f - f2 * f2);
        if (f6 >= 1.1920929E-7f) {
            float f7 = f2 * f4 - f3;
            float f8 = f2 * f3 - f4;
            float f9 = this.extent * f6;
            if (f7 >= 0.0f) {
                if (f8 >= -f9) {
                    if (f8 <= f9) {
                        float f10 = 1.0f / f6;
                        f = (f7 *= f10) * (f7 + f2 * (f8 *= f10) + 2.0f * f3) + f8 * (f2 * f7 + f8 + 2.0f * f4) + f5;
                    } else {
                        f8 = this.extent;
                        f7 = -(f2 * f8 + f3);
                        if (f7 > 0.0f) {
                            f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                        } else {
                            f7 = 0.0f;
                            f = f8 * (f8 + 2.0f * f4) + f5;
                        }
                    }
                } else {
                    f8 = -this.extent;
                    f7 = -(f2 * f8 + f3);
                    if (f7 > 0.0f) {
                        f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                    } else {
                        f7 = 0.0f;
                        f = f8 * (f8 + 2.0f * f4) + f5;
                    }
                }
            } else if (f8 <= -f9) {
                f7 = -(-f2 * this.extent + f3);
                if (f7 > 0.0f) {
                    f8 = -this.extent;
                    f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                } else {
                    f7 = 0.0f;
                    f8 = -f4;
                    if (f8 < -this.extent) {
                        f8 = -this.extent;
                    } else if (f8 > this.extent) {
                        f8 = this.extent;
                    }
                    f = f8 * (f8 + 2.0f * f4) + f5;
                }
            } else if (f8 <= f9) {
                f7 = 0.0f;
                f8 = -f4;
                if (f8 < -this.extent) {
                    f8 = -this.extent;
                } else if (f8 > this.extent) {
                    f8 = this.extent;
                }
                f = f8 * (f8 + 2.0f * f4) + f5;
            } else {
                f7 = -(f2 * this.extent + f3);
                if (f7 > 0.0f) {
                    f8 = this.extent;
                    f = -f7 * f7 + f8 * (f8 + 2.0f * f4) + f5;
                } else {
                    f7 = 0.0f;
                    f8 = -f4;
                    if (f8 < -this.extent) {
                        f8 = -this.extent;
                    } else if (f8 > this.extent) {
                        f8 = this.extent;
                    }
                    f = f8 * (f8 + 2.0f * f4) + f5;
                }
            }
        } else {
            float f11 = f2 > 0.0f ? -this.extent : this.extent;
            float f12 = -(f2 * f11 + f3);
            if (f12 > 0.0f) {
                f = -f12 * f12 + f11 * (f11 + 2.0f * f4) + f5;
            } else {
                f12 = 0.0f;
                f = f11 * (f11 + 2.0f * f4) + f5;
            }
        }
        return FastMath.abs(f);
    }

    public Object clone() {
        return new LineSegment(this);
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
    }

    public float getExtent() {
        return this.extent;
    }

    public void setExtent(float f) {
        this.extent = f;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3f vector3f) {
        this.origin = vector3f;
    }

    public Vector3f getPositiveEnd(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        return this.origin.add(this.direction.mult(this.extent, vector3f), vector3f);
    }

    public Vector3f getNegativeEnd(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        return this.origin.subtract(this.direction.mult(this.extent, vector3f), vector3f);
    }
}

