/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.curve.Curve;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.renderer.RenderQueue;
import com.jme.renderer.Renderer;
import com.jme.renderer.lwjgl.LWJGLCamera;
import com.jme.renderer.lwjgl.LWJGLFont;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.VBOInfo;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.LineBatch;
import com.jme.scene.batch.PointBatch;
import com.jme.scene.batch.QuadBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.AttributeState;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.ColorMaskState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.DitherState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.FragmentProgramState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ShadeState;
import com.jme.scene.state.StencilState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.VertexProgramState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.scene.state.lwjgl.LWJGLAlphaState;
import com.jme.scene.state.lwjgl.LWJGLAttributeState;
import com.jme.scene.state.lwjgl.LWJGLClipState;
import com.jme.scene.state.lwjgl.LWJGLColorMaskState;
import com.jme.scene.state.lwjgl.LWJGLCullState;
import com.jme.scene.state.lwjgl.LWJGLDitherState;
import com.jme.scene.state.lwjgl.LWJGLFogState;
import com.jme.scene.state.lwjgl.LWJGLFragmentProgramState;
import com.jme.scene.state.lwjgl.LWJGLLightState;
import com.jme.scene.state.lwjgl.LWJGLMaterialState;
import com.jme.scene.state.lwjgl.LWJGLShadeState;
import com.jme.scene.state.lwjgl.LWJGLShaderObjectsState;
import com.jme.scene.state.lwjgl.LWJGLStencilState;
import com.jme.scene.state.lwjgl.LWJGLTextureState;
import com.jme.scene.state.lwjgl.LWJGLVertexProgramState;
import com.jme.scene.state.lwjgl.LWJGLWireframeState;
import com.jme.scene.state.lwjgl.LWJGLZBufferState;
import com.jme.scene.state.lwjgl.records.LineRecord;
import com.jme.scene.state.lwjgl.records.RendererRecord;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.WeakIdentityCache;
import com.jme.util.export.Savable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EXTCompiledVertexArray;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import org.lwjgl.opengl.glu.GLU;

public class LWJGLRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(LWJGLRenderer.class.getName());
    private Vector3f vRot = new Vector3f();
    private LWJGLFont font;
    private boolean supportsVBO = false;
    private boolean indicesVBO = false;
    private boolean inOrthoMode;
    private Vector3f tempVa = new Vector3f();
    private FloatBuffer prevVerts;
    private FloatBuffer prevNorms;
    private FloatBuffer prevColor;
    private FloatBuffer[] prevTex;
    private int prevNormMode = 0;
    protected ContextCapabilities capabilities;
    private int prevTextureNumber = 0;
    private boolean generatingDisplayList = false;
    protected WeakIdentityCache<Buffer, Integer> vboMap = new WeakIdentityCache();

    public LWJGLRenderer(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            logger.warning("Invalid width and/or height values.");
            throw new JmeException("Invalid width and/or height values.");
        }
        this.width = n;
        this.height = n2;
        logger.info("LWJGLRenderer created. W:  " + n + "H: " + n2);
        this.capabilities = GLContext.getCapabilities();
        this.queue = new RenderQueue(this);
        if (TextureState.getNumberOfTotalUnits() == -1) {
            this.createTextureState();
        }
        this.prevTex = new FloatBuffer[TextureState.getNumberOfTotalUnits()];
        this.supportsVBO = this.capabilities.GL_ARB_vertex_buffer_object;
    }

    public void reinit(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            logger.warning("Invalid width and/or height values.");
            throw new JmeException("Invalid width and/or height values.");
        }
        this.width = n;
        this.height = n2;
        if (this.camera != null) {
            this.camera.resize(n, n2);
            this.camera.apply();
        }
        this.capabilities = GLContext.getCapabilities();
    }

    public void setCamera(Camera camera) {
        if (camera instanceof LWJGLCamera) {
            this.camera = (LWJGLCamera)camera;
        }
    }

    public Camera createCamera(int n, int n2) {
        return new LWJGLCamera(n, n2, this);
    }

    public AlphaState createAlphaState() {
        return new LWJGLAlphaState();
    }

    public AttributeState createAttributeState() {
        return new LWJGLAttributeState();
    }

    public CullState createCullState() {
        return new LWJGLCullState();
    }

    public DitherState createDitherState() {
        return new LWJGLDitherState();
    }

    public FogState createFogState() {
        return new LWJGLFogState();
    }

    public LightState createLightState() {
        return new LWJGLLightState();
    }

    public MaterialState createMaterialState() {
        return new LWJGLMaterialState();
    }

    public ShadeState createShadeState() {
        return new LWJGLShadeState();
    }

    public TextureState createTextureState() {
        return new LWJGLTextureState();
    }

    public WireframeState createWireframeState() {
        return new LWJGLWireframeState();
    }

    public ZBufferState createZBufferState() {
        return new LWJGLZBufferState();
    }

    public VertexProgramState createVertexProgramState() {
        return new LWJGLVertexProgramState();
    }

    public FragmentProgramState createFragmentProgramState() {
        return new LWJGLFragmentProgramState();
    }

    public GLSLShaderObjectsState createGLSLShaderObjectsState() {
        return new LWJGLShaderObjectsState();
    }

    public StencilState createStencilState() {
        return new LWJGLStencilState();
    }

    public ClipState createClipState() {
        return new LWJGLClipState();
    }

    public ColorMaskState createColorMaskState() {
        return new LWJGLColorMaskState();
    }

    public void setBackgroundColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.backgroundColor.a = 1.0f;
            this.backgroundColor.b = 1.0f;
            this.backgroundColor.g = 1.0f;
            this.backgroundColor.r = 1.0f;
        } else {
            this.backgroundColor = colorRGBA;
        }
        GL11.glClearColor((float)this.backgroundColor.r, (float)this.backgroundColor.g, (float)this.backgroundColor.b, (float)this.backgroundColor.a);
    }

    public void clearZBuffer() {
        if (Renderer.defaultStateList[8] != null) {
            Renderer.defaultStateList[8].apply();
        }
        GL11.glClear((int)256);
    }

    public void clearColorBuffer() {
        GL11.glClear((int)16384);
    }

    public void clearStencilBuffer() {
        GL11.glClearStencil((int)0);
        GL11.glStencilMask((int)-1);
        GL11.glDisable((int)3024);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GL11.glClear((int)1024);
        GL11.glDisable((int)3089);
    }

    public void clearBuffers() {
        if (Renderer.defaultStateList[8] != null) {
            Renderer.defaultStateList[8].apply();
        }
        GL11.glClear((int)16640);
    }

    public void clearStrictBuffers() {
        GL11.glDisable((int)3024);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glClear((int)16640);
        GL11.glDisable((int)3089);
        GL11.glEnable((int)3024);
    }

    public void displayBackBuffer() {
        this.renderQueue();
        Renderer.defaultStateList[15].apply();
        this.reset();
        GL11.glFlush();
        if (!this.isHeadless()) {
            Display.update();
        }
        this.vboMap.expunge();
    }

    public void reset() {
        this.prevVerts = null;
        this.prevNorms = null;
        this.prevColor = null;
        Arrays.fill(this.prevTex, null);
    }

    public boolean isInOrthoMode() {
        return this.inOrthoMode;
    }

    public void setOrtho() {
        if (this.inOrthoMode) {
            throw new JmeException("Already in Orthographic mode.");
        }
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)this.width, (float)0.0f, (float)this.height);
        rendererRecord.switchMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        this.inOrthoMode = true;
    }

    public void setOrthoCenter() {
        if (this.inOrthoMode) {
            throw new JmeException("Already in Orthographic mode.");
        }
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)(-this.width / 2), (float)(this.width / 2), (float)(-this.height / 2), (float)(this.height / 2));
        rendererRecord.switchMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        this.inOrthoMode = true;
    }

    public void unsetOrtho() {
        if (!this.inOrthoMode) {
            throw new JmeException("Not in Orthographic mode.");
        }
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5889);
        GL11.glPopMatrix();
        rendererRecord.switchMode(5888);
        GL11.glPopMatrix();
        this.inOrthoMode = false;
    }

    public boolean takeScreenShot(String string) {
        if (null == string) {
            throw new JmeException("Screenshot filename cannot be null");
        }
        logger.info("Taking screenshot: " + string + ".png");
        IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        this.grabScreenContents(intBuffer, 0, 0, this.width, this.height);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                bufferedImage.setRGB(i, j, intBuffer.get((this.height - j - 1) * this.width + i));
            }
        }
        try {
            File file = new File(string + ".png");
            return ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            logger.warning("Could not create file: " + string + ".png");
            return false;
        }
    }

    public void grabScreenContents(IntBuffer intBuffer, int n, int n2, int n3, int n4) {
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)32993, (int)5121, (IntBuffer)intBuffer);
    }

    public void draw(Curve curve) {
        Quaternion quaternion = curve.getWorldRotation();
        Vector3f vector3f = curve.getWorldTranslation();
        Vector3f vector3f2 = curve.getWorldScale();
        float f = quaternion.toAngleAxis(this.vRot) * 57.295776f;
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5888);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
        GL11.glRotatef((float)f, (float)this.vRot.x, (float)this.vRot.y, (float)this.vRot.z);
        GL11.glScalef((float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
        this.applyStates(curve.states, null);
        GL11.glBegin((int)3);
        FloatBuffer floatBuffer = curve.getColorBuffer(0);
        if (floatBuffer != null) {
            floatBuffer.rewind();
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        if (null != floatBuffer) {
            rendererRecord.setCurrentColor(floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
            f3 = f2 = 4.0f / (float)floatBuffer.limit();
            n = 0;
            floatBuffer.rewind();
        }
        float f4 = 1.0f + 1.0f / (float)curve.getSteps();
        for (float f5 = 0.0f; f5 <= f4; f5 += 1.0f / (float)curve.getSteps()) {
            if (f5 >= f2 && floatBuffer != null) {
                f2 += f3;
                rendererRecord.setCurrentColor(floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
                ++n;
            }
            Vector3f vector3f3 = curve.getPoint(f5, this.tempVa);
            GL11.glVertex3f((float)vector3f3.x, (float)vector3f3.y, (float)vector3f3.z);
        }
        if (this.statisticsOn) {
            this.stats.numberOfVerts = (long)((float)this.stats.numberOfVerts + f4);
        }
        GL11.glEnd();
        this.undoTransforms(curve);
    }

    public void draw(LineBatch lineBatch) {
        if (!lineBatch.predraw(this)) {
            return;
        }
        if (this.statisticsOn) {
            this.stats.numberOfLines += (long)(lineBatch.getVertexCount() >> 1);
            this.stats.numberOfVerts += (long)lineBatch.getVertexCount();
            ++this.stats.numberOfMesh;
        }
        if (lineBatch.getDisplayListID() != -1) {
            this.renderDisplayList(lineBatch);
            ((LineRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getLineRecord()).invalidate();
            return;
        }
        if (!this.generatingDisplayList) {
            this.applyStates(lineBatch.states, lineBatch);
        }
        this.doTransforms(lineBatch.getParentGeom());
        if (lineBatch.isEnabled()) {
            int n = 1;
            switch (lineBatch.getMode()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 3;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
            LineRecord lineRecord = (LineRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getLineRecord();
            lineRecord.applyLineWidth(lineBatch.getLineWidth());
            lineRecord.applyLineStipple(lineBatch.getStippleFactor(), lineBatch.getStipplePattern());
            lineRecord.applyLineSmooth(lineBatch.isAntialiased());
            if (!lineRecord.isValid()) {
                lineRecord.validate();
            }
            if (!this.predrawGeometry(lineBatch)) {
                IntBuffer intBuffer = lineBatch.getIndexBuffer();
                intBuffer.rewind();
                intBuffer.limit(lineBatch.getVertexCount());
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)lineBatch.getVertexCount());
                }
                GL11.glDrawElements((int)n, (IntBuffer)intBuffer);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
                intBuffer.clear();
            } else {
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)lineBatch.getVertexCount());
                }
                GL11.glDrawElements((int)n, (int)lineBatch.getIndexBuffer().limit(), (int)5125, (long)0L);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
            }
            this.postdrawGeometry(lineBatch);
        }
        this.undoTransforms(lineBatch.getParentGeom());
        lineBatch.postdraw(this);
    }

    public void draw(PointBatch pointBatch) {
        if (!pointBatch.predraw(this)) {
            return;
        }
        if (this.statisticsOn) {
            this.stats.numberOfPoints += (long)pointBatch.getVertexCount();
            this.stats.numberOfVerts += (long)pointBatch.getVertexCount();
            ++this.stats.numberOfMesh;
        }
        if (pointBatch.getDisplayListID() != -1) {
            this.renderDisplayList(pointBatch);
            return;
        }
        if (!this.generatingDisplayList) {
            this.applyStates(pointBatch.states, pointBatch);
        }
        this.doTransforms(pointBatch.getParentGeom());
        if (pointBatch.isEnabled()) {
            GL11.glPointSize((float)pointBatch.getPointSize());
            if (pointBatch.isAntialiased()) {
                GL11.glEnable((int)2832);
                GL11.glHint((int)3153, (int)4354);
            }
            if (!this.predrawGeometry(pointBatch)) {
                IntBuffer intBuffer = pointBatch.getIndexBuffer();
                intBuffer.rewind();
                intBuffer.limit(pointBatch.getVertexCount());
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)pointBatch.getVertexCount());
                }
                GL11.glDrawElements((int)0, (IntBuffer)intBuffer);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
                intBuffer.clear();
            } else {
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)pointBatch.getVertexCount());
                }
                GL11.glDrawElements((int)0, (int)pointBatch.getIndexBuffer().limit(), (int)5125, (long)0L);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
            }
            if (pointBatch.isAntialiased()) {
                GL11.glDisable((int)2832);
            }
            this.postdrawGeometry(pointBatch);
        }
        this.undoTransforms(pointBatch.getParentGeom());
        pointBatch.postdraw(this);
    }

    public void draw(QuadBatch quadBatch) {
        if (!quadBatch.predraw(this)) {
            return;
        }
        if (this.statisticsOn) {
            this.stats.numberOfQuads += (long)quadBatch.getQuadCount();
            this.stats.numberOfVerts += (long)quadBatch.getVertexCount();
            ++this.stats.numberOfMesh;
        }
        if (quadBatch.getDisplayListID() != -1) {
            this.renderDisplayList(quadBatch);
            return;
        }
        if (!this.generatingDisplayList) {
            this.applyStates(quadBatch.states, quadBatch);
        }
        this.doTransforms(quadBatch.getParentGeom());
        if (quadBatch.isEnabled()) {
            int n;
            int n2 = quadBatch.getMode();
            switch (n2) {
                case 1: {
                    n = 7;
                    break;
                }
                case 2: {
                    n = 8;
                    break;
                }
                default: {
                    throw new JmeException("Unknown triangle mode " + n2);
                }
            }
            if (!this.predrawGeometry(quadBatch)) {
                IntBuffer intBuffer = quadBatch.getIndexBuffer();
                intBuffer.rewind();
                intBuffer.limit(quadBatch.getMaxIndex());
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)quadBatch.getVertexCount());
                }
                GL11.glDrawElements((int)n, (IntBuffer)intBuffer);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
                intBuffer.clear();
            } else {
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)quadBatch.getVertexCount());
                }
                GL11.glDrawElements((int)n, (int)quadBatch.getIndexBuffer().limit(), (int)5125, (long)0L);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
            }
            this.postdrawGeometry(quadBatch);
        }
        this.undoTransforms(quadBatch.getParentGeom());
        quadBatch.postdraw(this);
    }

    public void draw(TriangleBatch triangleBatch) {
        if (!triangleBatch.predraw(this)) {
            return;
        }
        if (this.statisticsOn) {
            this.stats.numberOfTris += (long)triangleBatch.getTriangleCount();
            this.stats.numberOfVerts += (long)triangleBatch.getVertexCount();
            ++this.stats.numberOfMesh;
        }
        if (triangleBatch.getDisplayListID() != -1) {
            this.renderDisplayList(triangleBatch);
            return;
        }
        if (!this.generatingDisplayList) {
            this.applyStates(triangleBatch.states, triangleBatch);
        }
        this.doTransforms(triangleBatch.getParentGeom());
        if (triangleBatch.isEnabled()) {
            int n;
            int n2 = triangleBatch.getMode();
            switch (n2) {
                case 1: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 5;
                    break;
                }
                case 3: {
                    n = 6;
                    break;
                }
                default: {
                    throw new JmeException("Unknown triangle mode " + n2);
                }
            }
            if (!this.predrawGeometry(triangleBatch)) {
                IntBuffer intBuffer = triangleBatch.getIndexBuffer();
                if (intBuffer == null) {
                    logger.severe("missing indices on geometry object: " + triangleBatch.toString());
                } else {
                    intBuffer.rewind();
                    intBuffer.limit(triangleBatch.getMaxIndex());
                    if (this.capabilities.GL_EXT_compiled_vertex_array) {
                        EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)triangleBatch.getVertexCount());
                    }
                    GL11.glDrawElements((int)n, (IntBuffer)intBuffer);
                    if (this.capabilities.GL_EXT_compiled_vertex_array) {
                        EXTCompiledVertexArray.glUnlockArraysEXT();
                    }
                    intBuffer.clear();
                }
            } else {
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glLockArraysEXT((int)0, (int)triangleBatch.getVertexCount());
                }
                GL11.glDrawElements((int)n, (int)triangleBatch.getIndexBuffer().limit(), (int)5125, (long)0L);
                if (this.capabilities.GL_EXT_compiled_vertex_array) {
                    EXTCompiledVertexArray.glUnlockArraysEXT();
                }
            }
            this.postdrawGeometry(triangleBatch);
        }
        this.undoTransforms(triangleBatch.getParentGeom());
        triangleBatch.postdraw(this);
    }

    private synchronized void renderDisplayList(GeomBatch geomBatch) {
        this.applyStates(geomBatch.states, geomBatch);
        if ((geomBatch.getLocks() & 4) == 0) {
            this.doTransforms(geomBatch.getParentGeom());
            GL11.glCallList((int)geomBatch.getDisplayListID());
            this.undoTransforms(geomBatch.getParentGeom());
        } else {
            GL11.glCallList((int)geomBatch.getDisplayListID());
        }
        ((LineRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getLineRecord()).invalidate();
        this.reset();
    }

    public void prepVBO(GeomBatch geomBatch) {
        int n;
        int n2;
        Serializable serializable;
        if (!this.supportsVBO()) {
            return;
        }
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        VBOInfo vBOInfo = geomBatch.getVBOInfo();
        if (vBOInfo.isVBOVertexEnabled() && vBOInfo.getVBOVertexID() <= 0 && geomBatch.getVertexBuffer() != null) {
            serializable = this.vboMap.get(geomBatch.getVertexBuffer());
            if (serializable != null) {
                vBOInfo.setVBOVertexID((Integer)serializable);
            } else {
                geomBatch.getVertexBuffer().rewind();
                n2 = rendererRecord.makeVBOId();
                vBOInfo.setVBOVertexID(n2);
                this.vboMap.put(geomBatch.getVertexBuffer(), n2);
                rendererRecord.invalidateVBO();
                rendererRecord.setBoundVBO(vBOInfo.getVBOVertexID());
                ARBBufferObject.glBindBufferARB((int)34962, (int)vBOInfo.getVBOVertexID());
                ARBBufferObject.glBufferDataARB((int)34962, (FloatBuffer)geomBatch.getVertexBuffer(), (int)35044);
            }
        }
        if ((geomBatch.getType() & 0x200) != 0 && vBOInfo.isVBOIndexEnabled() && vBOInfo.getVBOIndexID() <= 0 && ((TriangleBatch)(serializable = (TriangleBatch)geomBatch)).getIndexBuffer() != null) {
            Integer n3 = this.vboMap.get(((TriangleBatch)serializable).getIndexBuffer());
            if (n3 != null) {
                vBOInfo.setVBOIndexID(n3);
            } else {
                ((TriangleBatch)serializable).getIndexBuffer().rewind();
                n = rendererRecord.makeVBOId();
                vBOInfo.setVBOIndexID(n);
                this.vboMap.put(((TriangleBatch)serializable).getIndexBuffer(), n);
                rendererRecord.invalidateVBO();
                rendererRecord.setBoundElementVBO(vBOInfo.getVBOIndexID());
                ARBBufferObject.glBufferDataARB((int)34963, (IntBuffer)((TriangleBatch)serializable).getIndexBuffer(), (int)35044);
            }
        }
        if (vBOInfo.isVBONormalEnabled() && vBOInfo.getVBONormalID() <= 0 && geomBatch.getNormalBuffer() != null) {
            serializable = this.vboMap.get(geomBatch.getNormalBuffer());
            if (serializable != null) {
                vBOInfo.setVBONormalID((Integer)serializable);
            } else {
                geomBatch.getNormalBuffer().rewind();
                n2 = rendererRecord.makeVBOId();
                vBOInfo.setVBONormalID(n2);
                this.vboMap.put(geomBatch.getNormalBuffer(), n2);
                rendererRecord.invalidateVBO();
                rendererRecord.setBoundVBO(vBOInfo.getVBONormalID());
                ARBBufferObject.glBufferDataARB((int)34962, (FloatBuffer)geomBatch.getNormalBuffer(), (int)35044);
            }
        }
        if (vBOInfo.isVBOColorEnabled() && vBOInfo.getVBOColorID() <= 0 && geomBatch.getColorBuffer() != null) {
            serializable = this.vboMap.get(geomBatch.getColorBuffer());
            if (serializable != null) {
                vBOInfo.setVBOColorID((Integer)serializable);
            } else {
                geomBatch.getColorBuffer().rewind();
                n2 = rendererRecord.makeVBOId();
                vBOInfo.setVBOColorID(n2);
                this.vboMap.put(geomBatch.getColorBuffer(), n2);
                rendererRecord.invalidateVBO();
                rendererRecord.setBoundVBO(vBOInfo.getVBOColorID());
                ARBBufferObject.glBufferDataARB((int)34962, (FloatBuffer)geomBatch.getColorBuffer(), (int)35044);
            }
        }
        if (vBOInfo.isVBOTextureEnabled()) {
            for (int i = 0; i < geomBatch.getNumberOfUnits(); ++i) {
                if (vBOInfo.getVBOTextureID(i) > 0 || geomBatch.getTextureBuffer(i) == null) continue;
                Integer n4 = this.vboMap.get(geomBatch.getTextureBuffer(i));
                if (n4 != null) {
                    vBOInfo.setVBOTextureID(i, n4);
                    continue;
                }
                geomBatch.getTextureBuffer(i).rewind();
                n = rendererRecord.makeVBOId();
                vBOInfo.setVBOTextureID(i, n);
                this.vboMap.put(geomBatch.getTextureBuffer(i), n);
                rendererRecord.invalidateVBO();
                rendererRecord.setBoundVBO(vBOInfo.getVBOTextureID(i));
                ARBBufferObject.glBufferDataARB((int)34962, (FloatBuffer)geomBatch.getTextureBuffer(i), (int)35044);
            }
        }
    }

    public void draw(Spatial spatial) {
        this.getCamera().apply();
        if (spatial != null) {
            spatial.onDraw(this);
        }
    }

    public void draw(Text text) {
        if (this.font == null) {
            this.font = new LWJGLFont();
        }
        this.font.setColor(text.getTextColor());
        this.applyStates(text.states, null);
        this.font.print(this, (int)text.getWorldTranslation().x, (int)text.getWorldTranslation().y, text.getWorldScale(), text.getText(), 0);
    }

    public boolean checkAndAdd(SceneElement sceneElement) {
        int n = sceneElement.getRenderQueueMode();
        if (n != 1) {
            this.getQueue().addToQueue(sceneElement, n);
            return true;
        }
        return false;
    }

    public boolean supportsVBO() {
        return this.supportsVBO;
    }

    protected void postdrawGeometry(GeomBatch geomBatch) {
    }

    public void flush() {
        GL11.glFlush();
    }

    public void finish() {
        GL11.glFinish();
    }

    protected boolean predrawGeometry(GeomBatch geomBatch) {
        Savable savable;
        FloatBuffer floatBuffer;
        int n;
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        RendererRecord rendererRecord = (RendererRecord)renderContext.getRendererRecord();
        VBOInfo vBOInfo = geomBatch.getVBOInfo();
        if (vBOInfo != null && this.supportsVBO()) {
            this.prepVBO(geomBatch);
        }
        this.indicesVBO = false;
        int n2 = -1;
        FloatBuffer floatBuffer2 = geomBatch.getVertexBuffer();
        if (floatBuffer2 != null) {
            n2 = floatBuffer2.limit();
            floatBuffer2.limit(geomBatch.getVertexCount() * 3);
        }
        if (this.supportsVBO && vBOInfo != null && vBOInfo.getVBOVertexID() > 0) {
            GL11.glEnableClientState((int)32884);
            rendererRecord.setBoundVBO(vBOInfo.getVBOVertexID());
            GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        } else if (floatBuffer2 == null) {
            GL11.glDisableClientState((int)32884);
        } else if (this.prevVerts != floatBuffer2) {
            GL11.glEnableClientState((int)32884);
            if (this.supportsVBO) {
                rendererRecord.setBoundVBO(0);
            }
            floatBuffer2.rewind();
            GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)floatBuffer2);
        }
        if (n2 != -1) {
            floatBuffer2.limit(n2);
        }
        this.prevVerts = floatBuffer2;
        if ((geomBatch.getType() & 0x200) != 0) {
            if (this.supportsVBO && vBOInfo != null && vBOInfo.getVBOIndexID() > 0) {
                this.indicesVBO = true;
                rendererRecord.setBoundElementVBO(vBOInfo.getVBOIndexID());
            } else if (this.supportsVBO) {
                rendererRecord.setBoundElementVBO(0);
            }
        }
        if ((n = geomBatch.getNormalsMode()) != 4) {
            this.applyNormalMode(n, geomBatch);
            floatBuffer = geomBatch.getNormalBuffer();
            n2 = -1;
            if (floatBuffer != null) {
                n2 = floatBuffer.limit();
                floatBuffer.limit(geomBatch.getVertexCount() * 3);
            }
            if (this.supportsVBO && vBOInfo != null && vBOInfo.getVBONormalID() > 0) {
                GL11.glEnableClientState((int)32885);
                rendererRecord.setBoundVBO(vBOInfo.getVBONormalID());
                GL11.glNormalPointer((int)5126, (int)0, (long)0L);
            } else if (floatBuffer == null) {
                GL11.glDisableClientState((int)32885);
            } else if (this.prevNorms != floatBuffer) {
                GL11.glEnableClientState((int)32885);
                if (this.supportsVBO) {
                    rendererRecord.setBoundVBO(0);
                }
                floatBuffer.rewind();
                GL11.glNormalPointer((int)0, (FloatBuffer)floatBuffer);
            }
            if (n2 != -1) {
                floatBuffer.limit(n2);
            }
            this.prevNorms = floatBuffer;
        } else {
            if (this.prevNormMode == 32826) {
                GL11.glDisable((int)32826);
                this.prevNormMode = 0;
            } else if (this.prevNormMode == 2977) {
                GL11.glDisable((int)2977);
                this.prevNormMode = 0;
            }
            n2 = -1;
            GL11.glDisableClientState((int)32885);
            this.prevNorms = null;
        }
        floatBuffer = geomBatch.getColorBuffer();
        n2 = -1;
        if (floatBuffer != null) {
            n2 = floatBuffer.limit();
            floatBuffer.limit(geomBatch.getVertexCount() * 4);
        }
        if (this.supportsVBO && vBOInfo != null && vBOInfo.getVBOColorID() > 0) {
            GL11.glEnableClientState((int)32886);
            rendererRecord.setBoundVBO(vBOInfo.getVBOColorID());
            GL11.glColorPointer((int)4, (int)5126, (int)0, (long)0L);
        } else if (floatBuffer == null) {
            GL11.glDisableClientState((int)32886);
            savable = geomBatch.getDefaultColor();
            if (savable != null) {
                rendererRecord.setCurrentColor((ColorRGBA)savable);
            } else {
                rendererRecord.setCurrentColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (this.prevColor != floatBuffer) {
            GL11.glEnableClientState((int)32886);
            if (this.supportsVBO) {
                rendererRecord.setBoundVBO(0);
            }
            floatBuffer.rewind();
            GL11.glColorPointer((int)4, (int)0, (FloatBuffer)floatBuffer);
        }
        if (n2 != -1) {
            floatBuffer.limit(n2);
        }
        this.prevColor = floatBuffer;
        savable = (TextureState)renderContext.currentStates[6];
        int n3 = 0;
        if (savable != null) {
            int n4;
            n3 = ((TextureState)savable).getTextureCoordinateOffset();
            for (n4 = 0; n4 < ((TextureState)savable).getNumberOfSetTextures() && n4 < TextureState.getNumberOfFragmentTexCoordUnits(); ++n4) {
                FloatBuffer floatBuffer3 = geomBatch.getTextureBuffer(n4 + n3);
                n2 = -1;
                if (floatBuffer3 != null) {
                    n2 = floatBuffer3.limit();
                    floatBuffer3.limit(geomBatch.getVertexCount() * 2);
                }
                if (this.capabilities.GL_ARB_multitexture) {
                    ARBMultitexture.glClientActiveTextureARB((int)(33984 + n4));
                }
                if (this.supportsVBO && vBOInfo != null && vBOInfo.getVBOTextureID(n4) > 0) {
                    GL11.glEnableClientState((int)32888);
                    rendererRecord.setBoundVBO(vBOInfo.getVBOTextureID(n4));
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
                } else if (floatBuffer3 == null) {
                    GL11.glDisableClientState((int)32888);
                } else if (this.prevTex[n4] != floatBuffer3) {
                    GL11.glEnableClientState((int)32888);
                    if (this.supportsVBO) {
                        rendererRecord.setBoundVBO(0);
                    }
                    floatBuffer3.rewind();
                    GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)floatBuffer3);
                } else {
                    GL11.glEnableClientState((int)32888);
                }
                this.prevTex[n4] = floatBuffer3;
                if (n2 == -1) continue;
                floatBuffer3.limit(n2);
            }
            if (((TextureState)savable).getNumberOfSetTextures() < this.prevTextureNumber) {
                for (n4 = ((TextureState)savable).getNumberOfSetTextures(); n4 < this.prevTextureNumber; ++n4) {
                    if (this.capabilities.GL_ARB_multitexture) {
                        ARBMultitexture.glClientActiveTextureARB((int)(33984 + n4));
                    }
                    GL11.glDisableClientState((int)32888);
                }
            }
            this.prevTextureNumber = ((TextureState)savable).getNumberOfSetTextures() < TextureState.getNumberOfFixedUnits() ? ((TextureState)savable).getNumberOfSetTextures() : TextureState.getNumberOfFixedUnits();
        }
        return this.indicesVBO;
    }

    private void applyNormalMode(int n, GeomBatch geomBatch) {
        switch (n) {
            case 3: {
                Vector3f vector3f = geomBatch.getParentGeom().getWorldScale();
                if (!vector3f.equals(Vector3f.UNIT_XYZ)) {
                    if (vector3f.x == vector3f.y && vector3f.y == vector3f.z && this.capabilities.OpenGL12 && this.prevNormMode != 32826) {
                        if (this.prevNormMode == 2977) {
                            GL11.glDisable((int)2977);
                        }
                        GL11.glEnable((int)32826);
                        this.prevNormMode = 32826;
                        break;
                    }
                    if (this.prevNormMode == 2977) break;
                    if (this.prevNormMode == 32826) {
                        GL11.glDisable((int)32826);
                    }
                    GL11.glEnable((int)2977);
                    this.prevNormMode = 2977;
                    break;
                }
                if (this.prevNormMode == 32826) {
                    GL11.glDisable((int)32826);
                    this.prevNormMode = 0;
                    break;
                }
                if (this.prevNormMode != 2977) break;
                GL11.glDisable((int)2977);
                this.prevNormMode = 0;
                break;
            }
            case 2: {
                if (this.prevNormMode == 2977) break;
                if (this.prevNormMode == 32826) {
                    GL11.glDisable((int)32826);
                }
                GL11.glEnable((int)2977);
                this.prevNormMode = 2977;
                break;
            }
            default: {
                if (this.prevNormMode == 32826) {
                    GL11.glDisable((int)32826);
                    this.prevNormMode = 0;
                    break;
                }
                if (this.prevNormMode != 2977) break;
                GL11.glDisable((int)2977);
                this.prevNormMode = 0;
            }
        }
    }

    protected void doTransforms(Spatial spatial) {
        if (!this.generatingDisplayList || (spatial.getLocks() & 4) != 0) {
            Vector3f vector3f;
            Quaternion quaternion;
            RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
            rendererRecord.switchMode(5888);
            GL11.glPushMatrix();
            Vector3f vector3f2 = spatial.getWorldTranslation();
            if (!vector3f2.equals(Vector3f.ZERO)) {
                GL11.glTranslatef((float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
            }
            if (!(quaternion = spatial.getWorldRotation()).isIdentity()) {
                float f = quaternion.toAngleAxis(this.vRot) * 57.295776f;
                GL11.glRotatef((float)f, (float)this.vRot.x, (float)this.vRot.y, (float)this.vRot.z);
            }
            if (!(vector3f = spatial.getWorldScale()).equals(Vector3f.UNIT_XYZ)) {
                GL11.glScalef((float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
            }
        }
    }

    protected void undoTransforms(Spatial spatial) {
        if (!this.generatingDisplayList || (spatial.getLocks() & 4) != 0) {
            RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
            rendererRecord.switchMode(5888);
            GL11.glPopMatrix();
        }
    }

    public int createDisplayList(GeomBatch geomBatch) {
        int n = GL11.glGenLists((int)1);
        this.generatingDisplayList = true;
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        renderContext.invalidateStates();
        RenderState renderState = renderContext.currentStates[6];
        renderContext.currentStates[6] = geomBatch.states[6];
        GL11.glNewList((int)n, (int)4864);
        if (geomBatch instanceof TriangleBatch) {
            this.draw((TriangleBatch)geomBatch);
        } else if (geomBatch instanceof QuadBatch) {
            this.draw((QuadBatch)geomBatch);
        } else if (geomBatch instanceof LineBatch) {
            this.draw((LineBatch)geomBatch);
        } else if (geomBatch instanceof PointBatch) {
            this.draw((PointBatch)geomBatch);
        }
        GL11.glEndList();
        renderContext.currentStates[6] = renderState;
        this.generatingDisplayList = false;
        return n;
    }

    public void releaseDisplayList(int n) {
        GL11.glDeleteLists((int)n, (int)1);
    }

    public void setPolygonOffset(float f, float f2) {
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)f, (float)f2);
    }

    public void clearPolygonOffset() {
        GL11.glDisable((int)32823);
    }

    public void deleteVBO(Buffer buffer) {
        Integer n = this.removeFromVBOCache(buffer);
        if (n != null) {
            this.deleteVBO(n);
        }
    }

    public void deleteVBO(int n) {
        if (n < 1 || !this.supportsVBO()) {
            return;
        }
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.deleteVBOId(n);
    }

    public void clearVBOCache() {
        this.vboMap.clear();
    }

    public Integer removeFromVBOCache(Buffer buffer) {
        return this.vboMap.remove(buffer);
    }

    public void applyStates(RenderState[] renderStateArray, GeomBatch geomBatch) {
        RenderState renderState;
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        if (geomBatch != null && (renderState = (GLSLShaderObjectsState)(renderContext.enforcedStateList[14] != null ? renderContext.enforcedStateList[14] : renderStateArray[14])) != null && renderState != defaultStateList[14]) {
            ((GLSLShaderObjectsState)renderState).setBatch(geomBatch);
            renderState.setNeedsRefresh(true);
        }
        renderState = null;
        for (int i = 0; i < renderStateArray.length; ++i) {
            RenderState renderState2 = renderState = renderContext.enforcedStateList[i] != null ? renderContext.enforcedStateList[i] : renderStateArray[i];
            if (renderState == null || RenderState.QUICK_COMPARE[i] && !renderState.needsRefresh() && renderState == renderContext.currentStates[i]) continue;
            renderState.apply();
            renderState.setNeedsRefresh(false);
        }
    }

    public StateRecord createLineRecord() {
        return new LineRecord();
    }

    public StateRecord createRendererRecord() {
        return new RendererRecord();
    }

    public void checkCardError() throws JmeException {
        try {
            Util.checkGLError();
        }
        catch (OpenGLException openGLException) {
            throw new JmeException("Error in opengl: " + openGLException.getMessage(), openGLException);
        }
    }

    public void cleanup() {
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.cleanupVBOs();
        if (this.font != null) {
            this.font.deleteFont();
            this.font = null;
        }
    }
}

