/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.pass;

import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.system.DisplaySystem;

public class OutlinePass
extends RenderPass {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_LINE_WIDTH = 3.0f;
    public static final ColorRGBA DEFAULT_OUTLINE_COLOR = ColorRGBA.black.clone();
    private WireframeState wireframeState = DisplaySystem.getDisplaySystem().getRenderer().createWireframeState();
    private LightState noLights;
    private TextureState noTexture;
    private AlphaState alphaState;

    public OutlinePass() {
        this.wireframeState.setFace(0);
        this.wireframeState.setLineWidth(3.0f);
        this.wireframeState.setEnabled(true);
        if (DisplaySystem.getDisplaySystem().getMinSamples() > 0) {
            this.wireframeState.setAntialiased(true);
        } else {
            this.wireframeState.setAntialiased(false);
        }
        this.noLights = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        this.noLights.setGlobalAmbient(DEFAULT_OUTLINE_COLOR);
        this.noLights.setEnabled(true);
        this.noTexture = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        this.noTexture.setEnabled(true);
        this.alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        this.alphaState.setSrcFunction(4);
        this.alphaState.setDstFunction(5);
        this.alphaState.setBlendEnabled(true);
        this.alphaState.setEnabled(true);
    }

    public void doRender(Renderer renderer) {
        if (this.spatials.size() == 0) {
            return;
        }
        super.doRender(renderer);
        CullState.setFlippedCulling(true);
        this.context.enforceState(this.wireframeState);
        this.context.enforceState(this.noLights);
        this.context.enforceState(this.noTexture);
        this.context.enforceState(this.alphaState);
        super.doRender(renderer);
        CullState.setFlippedCulling(false);
        this.context.clearEnforcedStates();
    }

    public void setOutlineWidth(float f) {
        this.wireframeState.setLineWidth(f);
    }

    public float getOutlineWidth() {
        return this.wireframeState.getLineWidth();
    }

    public void setOutlineColor(ColorRGBA colorRGBA) {
        this.noLights.setGlobalAmbient(colorRGBA);
    }

    public ColorRGBA getOutlineColor() {
        return this.noLights.getGlobalAmbient();
    }

    public AlphaState getAlphaState() {
        return this.alphaState;
    }

    public void setAlphaState(AlphaState alphaState) {
        this.alphaState = alphaState;
    }
}

