/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GeoSphere
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int maxlevels;
    private boolean useIkosa = true;

    public GeoSphere(String string, boolean bl, int n) {
        super(string);
        this.maxlevels = n;
        this.useIkosa = bl;
        this.setGeometry();
    }

    public GeoSphere() {
    }

    public float getRadius() {
        return 1.0f;
    }

    private void setGeometry() {
        Triangle[] triangleArray;
        int n;
        Object object;
        boolean bl = this.useIkosa;
        int n2 = bl ? 20 : 8;
        int n3 = bl ? 12 : 6;
        TriangleBatch triangleBatch = this.getBatch(0);
        int n4 = n2 << (this.maxlevels - 1) * 2;
        triangleBatch.setTriangleQuantity(n4);
        int n5 = n2 * (((1 << this.maxlevels * 2) - 1) / 3 - 1) + n3;
        triangleBatch.setVertexCount(n5);
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        floatBuffer = BufferUtils.createVector3Buffer(floatBuffer, n5);
        triangleBatch.setVertexBuffer(floatBuffer);
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), n5));
        triangleBatch.setTextureBuffer(BufferUtils.createVector3Buffer(triangleBatch.getTextureBuffer(0), n5), 0);
        int n6 = 0;
        if (bl) {
            object = new int[]{n6 + 0, n6 + 1, n6 + 2, n6 + 0, n6 + 2, n6 + 3, n6 + 0, n6 + 3, n6 + 4, n6 + 0, n6 + 4, n6 + 5, n6 + 0, n6 + 5, n6 + 1, n6 + 1, n6 + 10, n6 + 6, n6 + 2, n6 + 6, n6 + 7, n6 + 3, n6 + 7, n6 + 8, n6 + 4, n6 + 8, n6 + 9, n6 + 5, n6 + 9, n6 + 10, n6 + 6, n6 + 2, n6 + 1, n6 + 7, n6 + 3, n6 + 2, n6 + 8, n6 + 4, n6 + 3, n6 + 9, n6 + 5, n6 + 4, n6 + 10, n6 + 1, n6 + 5, n6 + 11, n6 + 7, n6 + 6, n6 + 11, n6 + 8, n6 + 7, n6 + 11, n6 + 9, n6 + 8, n6 + 11, n6 + 10, n6 + 9, n6 + 11, n6 + 6, n6 + 10};
            float f = 0.4472f;
            float f2 = 0.8944f;
            float f3 = 0.2764f;
            float f4 = 0.7236f;
            float f5 = 0.8507f;
            float f6 = 0.5257f;
            ++n6;
            this.put(new Vector3f(0.0f, 1.0f, 0.0f));
            ++n6;
            this.put(new Vector3f(f2, f, 0.0f));
            ++n6;
            this.put(new Vector3f(f3, f, -f5));
            ++n6;
            this.put(new Vector3f(-f4, f, -f6));
            ++n6;
            this.put(new Vector3f(-f4, f, f6));
            ++n6;
            this.put(new Vector3f(f3, f, f5));
            ++n6;
            this.put(new Vector3f(f4, -f, -f6));
            ++n6;
            this.put(new Vector3f(-f3, -f, -f5));
            ++n6;
            this.put(new Vector3f(-f2, -f, 0.0f));
            ++n6;
            this.put(new Vector3f(-f3, -f, f5));
            ++n6;
            this.put(new Vector3f(f4, -f, f6));
            ++n6;
            this.put(new Vector3f(0.0f, -1.0f, 0.0f));
            Triangle[] triangleArray22 = new Triangle[((Object)object).length / 3];
            for (n = 0; n < triangleArray22.length; ++n) {
                Triangle triangle = triangleArray22[n] = new Triangle();
                triangle.pt[0] = (int)object[n * 3];
                triangle.pt[1] = (int)object[n * 3 + 1];
                triangle.pt[2] = (int)object[n * 3 + 2];
            }
            triangleArray = triangleArray22;
        } else {
            Triangle[] triangleArray2;
            object = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f vector3f = new Vector3f(-1.0f, 0.0f, 0.0f);
            Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f vector3f3 = new Vector3f(0.0f, -1.0f, 0.0f);
            Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, 1.0f);
            Vector3f vector3f5 = new Vector3f(0.0f, 0.0f, -1.0f);
            int n7 = n6++;
            this.put((Vector3f)object);
            int n8 = n6++;
            this.put(vector3f);
            n = n6++;
            this.put(vector3f2);
            int n9 = n6++;
            this.put(vector3f3);
            int n10 = n6++;
            this.put(vector3f4);
            int n11 = n6++;
            this.put(vector3f5);
            triangleArray = triangleArray2 = new Triangle[]{new Triangle(n, n10, n7), new Triangle(n8, n10, n), new Triangle(n9, n10, n8), new Triangle(n7, n10, n9), new Triangle(n11, n, n7), new Triangle(n11, n8, n), new Triangle(n11, n9, n8), new Triangle(n11, n7, n9)};
        }
        object = new Vector3f();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        for (int i = 1; i < this.maxlevels; ++i) {
            int n12;
            Triangle[] triangleArray4 = new Triangle[triangleArray.length * 4];
            for (n12 = 0; n12 < triangleArray4.length; ++n12) {
                triangleArray4[n12] = new Triangle();
            }
            for (n12 = 0; n12 < triangleArray.length; ++n12) {
                int n13 = n12 * 4;
                Triangle triangle = triangleArray[n12];
                Triangle triangle2 = triangleArray4[n13];
                BufferUtils.populateFromBuffer((Vector3f)object, floatBuffer, triangle.pt[0]);
                BufferUtils.populateFromBuffer(vector3f, floatBuffer, triangle.pt[1]);
                BufferUtils.populateFromBuffer(vector3f6, floatBuffer, triangle.pt[2]);
                Vector3f vector3f2 = this.createMidpoint((Vector3f)object, vector3f6).normalizeLocal();
                Vector3f vector3f3 = this.createMidpoint((Vector3f)object, vector3f).normalizeLocal();
                Vector3f vector3f4 = this.createMidpoint(vector3f, vector3f6).normalizeLocal();
                int n14 = n6++;
                this.put(vector3f2);
                int n15 = n6++;
                this.put(vector3f3);
                int n16 = n6++;
                this.put(vector3f4);
                triangle2.pt[0] = triangle.pt[0];
                triangle2.pt[1] = n15;
                triangle2.pt[2] = n14;
                triangle2 = triangleArray4[++n13];
                triangle2.pt[0] = n15;
                triangle2.pt[1] = triangle.pt[1];
                triangle2.pt[2] = n16;
                triangle2 = triangleArray4[++n13];
                triangle2.pt[0] = n14;
                triangle2.pt[1] = n15;
                triangle2.pt[2] = n16;
                triangle2 = triangleArray4[++n13];
                triangle2.pt[0] = n14;
                triangle2.pt[1] = n16;
                triangle2.pt[2] = triangle.pt[2];
            }
            triangleArray = triangleArray4;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n4 * 3);
        triangleBatch.setIndexBuffer(intBuffer);
        for (Triangle triangle : triangleArray) {
            for (int n11 : triangle.pt) {
                intBuffer.put(n11);
            }
        }
    }

    private void put(Vector3f vector3f) {
        TriangleBatch triangleBatch = this.getBatch(0);
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        floatBuffer.put(vector3f.x);
        floatBuffer.put(vector3f.y);
        floatBuffer.put(vector3f.z);
        float f = vector3f.length();
        FloatBuffer floatBuffer2 = triangleBatch.getNormalBuffer();
        float f2 = vector3f.x / f;
        floatBuffer2.put(f2);
        float f3 = vector3f.y / f;
        floatBuffer2.put(f3);
        float f4 = vector3f.z / f;
        floatBuffer2.put(f4);
        FloatBuffer floatBuffer3 = triangleBatch.getTextureBuffer(0);
        floatBuffer3.put((FastMath.atan2(f3, f2) / ((float)Math.PI * 2) + 1.0f) % 1.0f);
        floatBuffer3.put(f4 / 2.0f + 0.5f);
    }

    Vector3f createMidpoint(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f((vector3f.x + vector3f2.x) * 0.5f, (vector3f.y + vector3f2.y) * 0.5f, (vector3f.z + vector3f2.z) * 0.5f);
    }

    static class Triangle {
        int[] pt = new int[3];

        public Triangle() {
        }

        public Triangle(int n, int n2, int n3) {
            this.pt[0] = n;
            this.pt[1] = n2;
            this.pt[2] = n3;
        }
    }
}

