/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl.records;

import com.jme.scene.state.lwjgl.records.StateRecord;
import org.lwjgl.opengl.GL11;

public class LineRecord
extends StateRecord {
    public boolean smoothed = false;
    public boolean stippled = false;
    public int smoothHint = -1;
    public float width = -1.0f;
    public int stippleFactor = -1;
    public short stipplePattern = (short)-1;

    public void applyLineWidth(float f) {
        if (!this.isValid() || this.width != f) {
            GL11.glLineWidth((float)f);
            this.width = f;
        }
    }

    public void applyLineSmooth(boolean bl) {
        if (bl) {
            if (!this.isValid() || !this.smoothed) {
                GL11.glEnable((int)2848);
                this.smoothed = true;
            }
            if (!this.isValid() || this.smoothHint != 4354) {
                GL11.glHint((int)3154, (int)4354);
                this.smoothHint = 4354;
            }
        } else if (!this.isValid() || this.smoothed) {
            GL11.glDisable((int)2848);
            this.smoothed = false;
        }
    }

    public void applyLineStipple(int n, short s) {
        if (s != -1) {
            if (!this.isValid() || !this.stippled) {
                GL11.glEnable((int)2852);
                this.stippled = true;
            }
            if (!this.isValid() || n != this.stippleFactor || s != this.stipplePattern) {
                GL11.glLineStipple((int)n, (short)s);
                this.stippleFactor = n;
                this.stipplePattern = s;
            }
        } else if (!this.isValid() || this.stippled) {
            GL11.glDisable((int)2852);
            this.stippled = false;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.smoothed = false;
        this.stippled = false;
        this.smoothHint = -1;
        this.width = -1.0f;
        this.stippleFactor = -1;
        this.stipplePattern = (short)-1;
    }
}

