/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.motiontools.poseEditor;

import com.jme.image.Texture;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.effects.glsl.BloomRenderPass;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.motiontools.Messages;
import jp.sourceforge.akjrcp.motiontools.PoseEditor;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseBoneInfoDataHashContainer;
import jp.sourceforge.akjrcp.motiontools.utils.MotionToolsUtils;
import jp.sourceforge.akjrcp.swing.FileChoicer;
import jp.sourceforge.akjrcp.swing.NumberValueChanger;
import org.apache.commons.lang.SystemUtils;

public class PoseEditorSettingSwingWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Spatial backgroundTarget;
    private Spatial bodyBrightTarget;
    private JTextField exportDir;
    private JTextField exportImageDir;
    private BloomRenderPass bloomRenderPass;
    public static final float bodyBrightDefault = 80.0f;
    public static final float blurSizeDefault = 0.02f;
    public static final float expowDefault = 10.0f;
    public static final float excutOffDefault = 0.0f;
    public static final float bimDefault = 0.6f;
    public static final float throttleDefault = 0.015f;
    private NumberValueChanger bodyBright;
    private NumberValueChanger throttle;
    private PoseBoneInfoDataHashContainer poseBoneInfoDataHashContainer;
    private NumberValueChanger bim;
    private NumberValueChanger excutOff;
    private NumberValueChanger expow;
    private NumberValueChanger blurSize;
    private JCheckBox bluarOnOff;
    private JCheckBox startAnimeFromAnime;
    private JCheckBox abaAnime;
    private FileChoicer animeFileChoicer;
    private FileChoicer randomFileChoicer;
    private JCheckBox backgroundOnOff;

    public String getExportPath() {
        return this.exportDir.getText();
    }

    public String getExportImagePath() {
        return this.exportImageDir.getText();
    }

    public float getBodyBright() {
        return this.bodyBright.getValue();
    }

    public PoseEditorSettingSwingWindow() {
        this.setLayout(new FlowLayout());
        this.setSize(400, 680);
        this.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.add(jPanel);
        FileChoicer fileChoicer = new FileChoicer(Messages.getString("background")){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    if (PoseEditorSettingSwingWindow.this.backgroundTarget != null) {
                        PoseEditorSettingSwingWindow.this.backgroundTarget.clearRenderState(6);
                        PoseEditorSettingSwingWindow.this.backgroundTarget.updateRenderState();
                        PoseEditorSettingSwingWindow.this.backgroundOnOff.setSelected(false);
                        PoseEditorSettingSwingWindow.this.backgroundTarget.setCullMode(2);
                    }
                } else {
                    try {
                        if (PoseEditorSettingSwingWindow.this.backgroundTarget != null) {
                            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                            Texture texture = TextureManager.loadTexture((Image)ImageIO.read(new File(string)), (int)0, (int)0, (float)1.0f, (boolean)true);
                            textureState.setTexture(texture);
                            PoseEditorSettingSwingWindow.this.backgroundTarget.setRenderState((RenderState)textureState);
                            PoseEditorSettingSwingWindow.this.backgroundTarget.updateRenderState();
                            PoseEditorSettingSwingWindow.this.backgroundOnOff.setSelected(true);
                            PoseEditorSettingSwingWindow.this.backgroundTarget.setCullMode(3);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Images (*.png;*.jpg;*.gif)", "png", "jpg", "gif");
        fileChoicer.setFileFilter(fileNameExtensionFilter);
        jPanel.add(fileChoicer);
        this.backgroundOnOff = new JCheckBox(Messages.getString("show_background"));
        this.backgroundOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    PoseEditorSettingSwingWindow.this.backgroundTarget.setCullMode(3);
                } else {
                    PoseEditorSettingSwingWindow.this.backgroundTarget.setCullMode(2);
                }
            }
        });
        jPanel.add(this.backgroundOnOff);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton(Messages.getString("export"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.chooseEexportDir((Component)actionEvent.getSource());
                PoseEditorSettingSwingWindow.this.animeFileChoicer.setDir(PoseEditorSettingSwingWindow.this.exportDir.getText());
                PoseEditorSettingSwingWindow.this.randomFileChoicer.setDir(PoseEditorSettingSwingWindow.this.exportDir.getText());
            }
        });
        jPanel2.add(jButton);
        this.exportDir = new JTextField();
        this.exportDir.setColumns(16);
        this.exportDir.setEditable(false);
        if (new File("poses").exists()) {
            this.exportDir.setText(new File("poses").getAbsolutePath());
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.exportDir.setText(FileNameUtils.getMyDocumentsPath());
        } else {
            this.exportDir.setText(System.getProperty("user.home"));
        }
        jPanel2.add(this.exportDir);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton2 = new JButton(Messages.getString("export_image"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.chooseEexportDir((Component)actionEvent.getSource());
            }
        });
        jPanel3.add(jButton2);
        this.exportImageDir = new JTextField();
        this.exportImageDir.setColumns(16);
        this.exportImageDir.setEditable(false);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.exportImageDir.setText(FileNameUtils.getMyPicturesPath());
        } else {
            this.exportImageDir.setText(System.getProperty("user.home"));
        }
        jPanel3.add(this.exportImageDir);
        jPanel.add(jPanel3);
        this.randomFileChoicer = new FileChoicer(Messages.getString("random_pose")){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    PoseEditorSettingSwingWindow.this.poseBoneInfoDataHashContainer.setRandomPose(null);
                } else {
                    PoseEditorSettingSwingWindow.this.poseBoneInfoDataHashContainer.setRandomPose(PoseEditor.loadDataHash(new File(string)));
                }
            }
        };
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter("Pose Data (*.txt)", "txt");
        this.randomFileChoicer.setFileFilter(fileNameExtensionFilter2);
        this.randomFileChoicer.setDir(this.exportDir.getText());
        jPanel.add(this.randomFileChoicer);
        this.animeFileChoicer = new FileChoicer(Messages.getString("anime_pose")){

            @Override
            public void fileChanged(String string) {
                if (string.equals("")) {
                    PoseEditorSettingSwingWindow.this.poseBoneInfoDataHashContainer.setAnimePose(null);
                } else {
                    PoseEditorSettingSwingWindow.this.poseBoneInfoDataHashContainer.setAnimePose(PoseEditor.loadDataHash(new File(string)));
                }
            }
        };
        this.animeFileChoicer.setDir(this.exportDir.getText());
        this.randomFileChoicer.setFileFilter(fileNameExtensionFilter2);
        jPanel.add(this.animeFileChoicer);
        JPanel jPanel4 = new JPanel();
        jPanel.add(jPanel4);
        this.startAnimeFromAnime = new JCheckBox(Messages.getString("start_anime"));
        this.startAnimeFromAnime.setSelected(false);
        this.startAnimeFromAnime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel4.add(this.startAnimeFromAnime);
        this.abaAnime = new JCheckBox(Messages.getString("ABA_anime"));
        this.abaAnime.setToolTipText(Messages.getString("ABA_anime_tooltip"));
        this.abaAnime.setSelected(true);
        this.abaAnime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel4.add(this.abaAnime);
        this.bluarOnOff = new JCheckBox(Messages.getString("use_bluar"));
        this.bluarOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jPanel.add(this.bluarOnOff);
        this.blurSize = new NumberValueChanger("BlurSize", 0.0f, 1.0f, 0.02f, 0.001f, 0.01f);
        this.blurSize.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setBlurSize(numberValueChanger.getValue());
            }
        });
        this.add(this.blurSize);
        this.expow = new NumberValueChanger("Expow", 0.0f, 100.0f, 10.0f, 1.0f, 5.0f);
        this.expow.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setExposurePow(numberValueChanger.getValue());
            }
        });
        this.add(this.expow);
        this.excutOff = new NumberValueChanger("ExCOff", -100.0f, 1.0f, 0.0f, 0.01f, 0.1f);
        this.excutOff.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setExposureCutoff(numberValueChanger.getValue());
            }
        });
        this.add(this.excutOff);
        this.bim = new NumberValueChanger("BIM", 0.0f, 100.0f, 0.6f, 0.1f, 1.0f);
        this.bim.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setBlurIntensityMultiplier(numberValueChanger.getValue());
            }
        });
        this.add(this.bim);
        this.throttle = new NumberValueChanger("throttle", 0.0f, 100.0f, 0.015f, 0.01f, 0.25f);
        this.throttle.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setThrottle(numberValueChanger.getValue());
            }
        });
        this.add(this.throttle);
        this.bodyBright = new NumberValueChanger(Messages.getString("body_bright"), 0.0f, 255.0f, 80.0f, 1.0f, 5.0f);
        this.bodyBright.setToolTipText(Messages.getString("body_bright_tooltip"));
        this.bodyBright.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberValueChanger numberValueChanger = (NumberValueChanger)actionEvent.getSource();
                float f = numberValueChanger.getValue();
                MotionToolsUtils.setEmissiveState(PoseEditorSettingSwingWindow.this.bodyBrightTarget, (int)f, (int)f, (int)f);
                PoseEditorSettingSwingWindow.this.bodyBrightTarget.updateRenderState();
            }
        });
        this.add(this.bodyBright);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 4));
        this.add(jPanel5);
        JButton jButton3 = new JButton(Messages.getString("bluar_default"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSettingSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(0.6f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel5.add(jButton3);
        JButton jButton4 = new JButton(Messages.getString("bluar_natural"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSettingSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(0.6f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton4);
        JButton jButton5 = new JButton(Messages.getString("bluar_real"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel5.add(jButton5);
        JButton jButton6 = new JButton(Messages.getString("bluar_comic"));
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(255.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(false);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(false);
            }
        });
        jPanel5.add(jButton6);
        JButton jButton7 = new JButton(Messages.getString("bluar_warm"));
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSettingSwingWindow.this.expow.setValue(30.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(0.8f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton7);
        JButton jButton8 = new JButton(Messages.getString("bluar_light"));
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSettingSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(3.6f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton8);
        JButton jButton9 = new JButton(Messages.getString("bluar_aura"));
        jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.02f);
                PoseEditorSettingSwingWindow.this.expow.setValue(50.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(7.0f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton9);
        JButton jButton10 = new JButton(Messages.getString("bluar_fire"));
        jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.15f);
                PoseEditorSettingSwingWindow.this.expow.setValue(10.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(4.0f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton10);
        JButton jButton11 = new JButton(Messages.getString("bluar_fog"));
        jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.42f);
                PoseEditorSettingSwingWindow.this.expow.setValue(2.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bim.setValue(3.4f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(0.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton11);
        JButton jButton12 = new JButton(Messages.getString("bluar_fairy"));
        jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditorSettingSwingWindow.this.blurSize.setValue(0.03f);
                PoseEditorSettingSwingWindow.this.expow.setValue(2.0f);
                PoseEditorSettingSwingWindow.this.excutOff.setValue(-0.52f);
                PoseEditorSettingSwingWindow.this.bim.setValue(1.0f);
                PoseEditorSettingSwingWindow.this.throttle.setValue(0.015f);
                PoseEditorSettingSwingWindow.this.bodyBright.setValue(80.0f);
                PoseEditorSettingSwingWindow.this.bluarOnOff.setSelected(true);
                PoseEditorSettingSwingWindow.this.bloomRenderPass.setEnabled(true);
            }
        });
        jPanel5.add(jButton12);
    }

    public void loadSettings(InputStream inputStream) {
    }

    public void saveSettings(File file) {
    }

    public Spatial getBackgroundTarget() {
        return this.backgroundTarget;
    }

    public void setBackgroundTarget(Spatial spatial) {
        this.backgroundTarget = spatial;
    }

    private void chooseEexportDir(Component component) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.exportDir.getText());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setVisible(true);
        if (jFileChooser.showOpenDialog(component) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.exportDir.setText(file.getAbsolutePath());
        }
    }

    public boolean isABAAnimation() {
        return this.abaAnime.isSelected();
    }

    public boolean isStartAnimationFromAnimePose() {
        return this.startAnimeFromAnime.isSelected();
    }

    public void setStartAnimationFromAnimePose(boolean bl) {
        this.startAnimeFromAnime.setSelected(bl);
    }

    public Spatial getBodyBrightTarget() {
        return this.bodyBrightTarget;
    }

    public void setBodyBrightTarget(Spatial spatial) {
        this.bodyBrightTarget = spatial;
    }

    public BloomRenderPass getBloomRenderPass() {
        return this.bloomRenderPass;
    }

    public void setBloomRenderPass(BloomRenderPass bloomRenderPass) {
        this.bloomRenderPass = bloomRenderPass;
    }

    public PoseBoneInfoDataHashContainer getPoseBoneInfoDataHashContainer() {
        return this.poseBoneInfoDataHashContainer;
    }

    public void setPoseBoneInfoDataHashContainer(PoseBoneInfoDataHashContainer poseBoneInfoDataHashContainer) {
        this.poseBoneInfoDataHashContainer = poseBoneInfoDataHashContainer;
    }
}

