/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.scene;

import com.jme.scene.Controller;

public abstract class TimedLifeController
extends Controller {
    private float lifeInSeconds;
    private float current;

    public TimedLifeController(float f) {
        this.lifeInSeconds = f;
        this.current = -1.0f;
    }

    public void update(float f) {
        if (this.current == -1.0f) {
            this.current = 0.0f;
        } else {
            this.current += f;
            float f2 = this.current / this.lifeInSeconds;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.updatePercentage(f2);
            if (f2 == 1.0f) {
                this.remove();
            }
        }
    }

    public void remove() {
        this.setActive(false);
    }

    public void reset() {
        this.current = -1.0f;
        this.setActive(true);
    }

    public void setPercentage(float f) {
        this.current = this.lifeInSeconds * f;
    }

    public abstract void updatePercentage(float var1);
}

