/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import jp.sourceforge.mergedoc.pleiades.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationResult;
import junit.framework.TestCase;

public class TranslationDictionaryTest
extends TestCase {
    private TranslationDictionary target = new TranslationDictionary();

    public void testLookup() {
        TranslationResult result = null;
        String input = "... undefined string in dictionary ...";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "\n" + result.getValue() + "\n");
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
        input = "Label";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "\n" + result.getValue() + "\n");
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "L&abel";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "\n" + result.getValue() + "\n");
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb(&A)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Search results for {0}:";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "\n" + result.getValue() + "\n");
        TranslationDictionaryTest.assertEquals((String)"{0} \u306e\u691c\u7d22\u7d50\u679c:", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
    }

    public void testLookupIgnoreMnemonic() {
        TranslationResult result = null;
        result = this.target.lookupIgnoreMnemonic("Label");
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        String input = "L&abel";
        result = this.target.lookupIgnoreMnemonic(input);
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
    }
}

