/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaDuration;
import com.jmex.xml.types.SchemaTypeCalendar;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class SchemaCalendarBase
implements SchemaTypeCalendar {
    public static final int TZ_MISSING = 0;
    public static final int TZ_UTC = 1;
    public static final int TZ_OFFSET = 2;
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected double partsecond;
    protected int hasTZ;
    protected int offsetTZ;
    protected boolean isempty;
    protected final int DateTimePart_Year = 1;
    protected final int DateTimePart_Month = 2;
    protected final int DateTimePart_Day = 4;
    protected final int DateTimePart_Date = 7;
    protected final int DateTimePart_Time = 8;
    static int[] monthStart = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    static int[] monthStartLeap = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};

    public SchemaCalendarBase() {
        this.setEmpty();
    }

    public void setNull() {
        this.setEmpty();
    }

    public void setEmpty() {
        this.setInternalValues(1, 1, 1, 0, 0, 0, 0.0, 0, 0);
        this.isempty = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaCalendarBase)) {
            return false;
        }
        SchemaCalendarBase schemaCalendarBase = (SchemaCalendarBase)object;
        if (this.year != schemaCalendarBase.year) {
            return false;
        }
        if (this.month != schemaCalendarBase.month) {
            return false;
        }
        if (this.day != schemaCalendarBase.day) {
            return false;
        }
        if (this.hour != schemaCalendarBase.hour) {
            return false;
        }
        if (this.minute != schemaCalendarBase.minute) {
            return false;
        }
        if (this.second != schemaCalendarBase.second) {
            return false;
        }
        if (this.partsecond != schemaCalendarBase.partsecond) {
            return false;
        }
        if (this.hasTZ != schemaCalendarBase.hasTZ) {
            return false;
        }
        return this.offsetTZ == schemaCalendarBase.offsetTZ;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.getApproximatedTotal());
    }

    public String toDateString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("0000").format(this.year));
        stringBuffer.append("-");
        stringBuffer.append(new DecimalFormat("00").format(this.month));
        stringBuffer.append("-");
        stringBuffer.append(new DecimalFormat("00").format(this.day));
        return stringBuffer.toString();
    }

    public String toTimeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("00").format(this.hour));
        stringBuffer.append(":");
        stringBuffer.append(new DecimalFormat("00").format(this.minute));
        stringBuffer.append(":");
        stringBuffer.append(new DecimalFormat("00").format(this.second));
        if (this.partsecond > 0.0 && this.partsecond < 1.0) {
            String string = new DecimalFormat("0.0###############").format(this.partsecond);
            stringBuffer.append(".");
            stringBuffer.append(string.substring(2, string.length()));
        }
        if (this.hasTZ == 1) {
            stringBuffer.append("Z");
        } else if (this.hasTZ == 2) {
            int n = this.offsetTZ;
            if (this.offsetTZ < 0) {
                stringBuffer.append("-");
                n = -this.offsetTZ;
            } else {
                stringBuffer.append("+");
            }
            stringBuffer.append(new DecimalFormat("00").format(n / 60));
            stringBuffer.append(":");
            stringBuffer.append(new DecimalFormat("00").format(n % 60));
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return true;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isEmpty();
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaCalendarBase)object);
    }

    public int compareTo(SchemaCalendarBase schemaCalendarBase) {
        return (int)(this.getApproximatedTotal() - schemaCalendarBase.getApproximatedTotal());
    }

    protected void parseDate(String string) throws StringParseException {
        if (string.length() == 0) {
            this.isempty = true;
        } else {
            if (string.length() < 10) {
                throw new StringParseException("date-part of string is too short", 0);
            }
            try {
                int n = 0;
                if (string.substring(0, 1).equals("-")) {
                    n = 1;
                }
                this.year = Integer.parseInt(string.substring(0, n + 4));
                if (!string.substring(n + 4, n + 5).equals("-")) {
                    throw new StringParseException("invalid date format", 2);
                }
                this.month = Integer.parseInt(string.substring(n + 5, n + 7));
                if (!string.substring(n + 7, n + 8).equals("-")) {
                    throw new StringParseException("invalid date format", 2);
                }
                this.day = Integer.parseInt(string.substring(n + 8, string.length()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException("invalid date format", 2);
            }
            this.isempty = false;
        }
    }

    protected void parseTime(String string) throws StringParseException {
        if (string.length() < 8) {
            throw new StringParseException("time-part of string is too short", 0);
        }
        try {
            int n = 0;
            this.hour = Integer.parseInt(string.substring(n, n + 2));
            if (!string.substring(n + 2, n + 3).equals(":")) {
                throw new StringParseException("invalid date format", 2);
            }
            this.minute = Integer.parseInt(string.substring(n + 3, n + 5));
            if (!string.substring(n + 5, n + 6).equals(":")) {
                throw new StringParseException("invalid date format", 2);
            }
            this.second = Integer.parseInt(string.substring(n + 6, n + 8));
            int n2 = n + 8;
            this.partsecond = 0.0;
            if (string.length() > n + 8) {
                n = n2;
                int n3 = string.length();
                int n4 = string.indexOf("Z", n);
                if (n4 > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string.indexOf("+", n)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string.indexOf("-", n)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                n2 = n3;
                this.partsecond = Double.parseDouble("0" + string.substring(n, n3));
            }
            this.hasTZ = 0;
            this.offsetTZ = 0;
            if (string.length() > n2 && string.substring(n2, n2 + 1).equals("Z")) {
                this.hasTZ = 1;
            } else if (string.length() == n2 + 6) {
                this.hasTZ = 2;
                this.offsetTZ = Integer.parseInt(string.substring(n2 + 1, n2 + 3)) * 60 + Integer.parseInt(string.substring(n2 + 4, n2 + 6));
                if (string.substring(n2, n2 + 1).equals("-")) {
                    this.offsetTZ = -this.offsetTZ;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new StringParseException("invalid number format", 2);
        }
        this.isempty = false;
    }

    protected boolean parseDateTime(String string, int n) {
        RefInt refInt;
        int n2;
        int n3;
        ParseContext parseContext = new ParseContext(string);
        boolean bl = (n & 7) != 0;
        boolean bl2 = (n & 8) != 0;
        RefInt refInt2 = new RefInt(0);
        RefInt refInt3 = new RefInt(0);
        RefInt refInt4 = new RefInt(0);
        RefInt refInt5 = new RefInt(0);
        RefInt refInt6 = new RefInt(0);
        double d = 0.0;
        this.hasTZ = 0;
        this.offsetTZ = 0;
        if (bl) {
            n3 = parseContext.checkAndAdvance('-');
            if ((n & 1) != 0) {
                n2 = 0;
                refInt = new RefInt(0);
                while (parseContext.readDigitAndAdvance(refInt, 1, 9)) {
                    refInt2.value = refInt2.value * 10 + refInt.value;
                    refInt.value = 0;
                    if (++n2 < 8) continue;
                    return false;
                }
                if (n2 < 4) {
                    return false;
                }
                if (n2 > 4 && refInt2.value < 10000) {
                    return false;
                }
                if (n3 != 0) {
                    refInt2.value = -refInt2.value;
                }
            }
            if ((n & 6) != 0) {
                if (!parseContext.checkAndAdvance('-')) {
                    return false;
                }
                if ((n & 2) != 0) {
                    if (!parseContext.readDigitAndAdvance(refInt3, 10, 1)) {
                        return false;
                    }
                    if (!parseContext.readDigitAndAdvance(refInt3, 1, refInt3.value < 10 ? 9 : 2)) {
                        return false;
                    }
                    if (refInt3.value == 0) {
                        return false;
                    }
                }
                if ((n & 4) != 0) {
                    if (!parseContext.checkAndAdvance('-')) {
                        return false;
                    }
                    int n4 = n2 = refInt3.value != 2 ? 3 : 2;
                    if (!parseContext.readDigitAndAdvance(refInt4, 10, n2)) {
                        return false;
                    }
                    if (!parseContext.readDigitAndAdvance(refInt4, 1, 9)) {
                        return false;
                    }
                    if (refInt4.value == 0 || refInt4.value > 31) {
                        return false;
                    }
                    if ((n & 2) != 0) {
                        boolean bl3;
                        boolean bl4 = refInt3.value <= 7;
                        boolean bl5 = bl3 = (refInt3.value & 1) == 0;
                        if (bl4 == bl3 && refInt4.value > 30) {
                            return false;
                        }
                        if (refInt3.value == 2 && refInt4.value > 29) {
                            return false;
                        }
                        if (refInt3.value == 2 && (n & 1) != 0 && (refInt2.value % 4 != 0 || refInt2.value % 100 == 0) && refInt2.value % 400 != 0 && refInt4.value > 28) {
                            return false;
                        }
                    }
                }
            }
            if (bl2 && !parseContext.checkAndAdvance('T')) {
                return false;
            }
        }
        if (bl2) {
            if (!parseContext.readDigitAndAdvance(refInt5, 10, 2)) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt5, 1, refInt5.value < 20 ? 9 : 4)) {
                return false;
            }
            if (!parseContext.checkAndAdvance(':')) {
                return false;
            }
            n3 = refInt5.value == 24 ? 0 : 5;
            int n5 = n2 = refInt5.value == 24 ? 0 : 9;
            if (!parseContext.readDigitAndAdvance(refInt6, 10, n3)) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt6, 1, n2)) {
                return false;
            }
            if (!parseContext.checkAndAdvance(':')) {
                return false;
            }
            refInt = new RefInt(0);
            if (!parseContext.readDigitAndAdvance(refInt, 10, n3)) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt, 1, n2)) {
                return false;
            }
            d = refInt.value;
            if (parseContext.checkAndAdvance('.')) {
                RefInt refInt7 = new RefInt(0);
                int n6 = 0;
                while (parseContext.readDigitAndAdvance(refInt7, 1, 9)) {
                    refInt7.value *= 10;
                    if (++n6 < 8) continue;
                }
                if (n6 == 0) {
                    return false;
                }
                d += (double)refInt7.value * Math.pow(10.0, -n6 - 1);
                while (parseContext.readDigitAndAdvance(refInt7, 0, 9)) {
                }
            }
        }
        if (parseContext.checkAndAdvance('Z')) {
            this.hasTZ = 1;
            this.offsetTZ = 0;
        } else if (parseContext.check('+') || parseContext.check('-')) {
            n3 = parseContext.check('-');
            parseContext.advance();
            RefInt refInt8 = new RefInt(0);
            if (!parseContext.readDigitAndAdvance(refInt8, 600, 9)) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt8, 60, 9)) {
                return false;
            }
            if (!parseContext.checkAndAdvance(':')) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt8, 10, 5)) {
                return false;
            }
            if (!parseContext.readDigitAndAdvance(refInt8, 1, 9)) {
                return false;
            }
            this.hasTZ = 2;
            int n7 = this.offsetTZ = n3 != 0 ? -refInt8.value : refInt8.value;
        }
        if (parseContext.isValid()) {
            return false;
        }
        this.setInternalValues(refInt2.value, refInt3.value, refInt4.value, refInt5.value, refInt6.value, (int)d, d * 1000.0 % 1000.0 / 1000.0, this.hasTZ, this.offsetTZ);
        return true;
    }

    public double getApproximatedTotal() {
        return (double)this.second + 60.0 * ((double)this.minute + 60.0 * ((double)this.hour + 24.0 * ((double)this.day + 31.0 * ((double)this.month + 12.0 * (double)this.year)))) + this.partsecond;
    }

    public long getTimeValue() {
        int n;
        int n2;
        long l = 0L;
        int n3 = this.year;
        int n4 = (this.month - 1) % 12;
        if (n4 < 0) {
            n4 += 12;
        }
        if ((n2 = (n = (n3 += (this.month - n4 - 1) / 12) - 1) % 400) < 0) {
            n2 += 400;
        }
        l += (long)((n - n2) / 400 * 146097);
        l += (long)(n2 / 100 * 36524);
        l += (long)((n2 %= 100) / 4 * 1461);
        l += (long)((n2 %= 4) * 365);
        l = n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0) ? (l += (long)monthStartLeap[n4]) : (l += (long)monthStart[n4]);
        l += (long)(this.day - 1);
        l = l * 24L + (long)this.hour;
        l = l * 60L + (long)this.minute - (long)this.offsetTZ;
        l = (long)(((double)(l * 60L + (long)this.second) + this.partsecond) * 1000.0);
        return l;
    }

    public void setTimeFromTimeValue(long l) {
        if ((l %= 86400000L) < 0L) {
            l += 86400000L;
        }
        this.partsecond = (double)(l % 1000L) / 1000.0;
        this.second = (int)((l /= 1000L) % 60L);
        this.minute = (int)((l /= 60L) % 60L);
        this.hour = (int)((l /= 60L) % 24L);
    }

    public void setDateFromTimeValue(long l) {
        long l2 = l % 86400000L;
        int n = (int)(l / 86400000L);
        if (l2 < 0L) {
            --n;
        }
        this.year = n < 0 ? -1 : 1;
        this.month = 1;
        this.day = 1;
        this.year += 400 * (n / 146097);
        if ((n %= 146097) == 146096) {
            this.year += 399;
            n = 365;
        } else {
            this.year += 100 * (n / 36524);
            this.year += 4 * ((n %= 36524) / 1461);
            if ((n %= 1461) == 1460) {
                this.year += 3;
                n = 365;
            } else {
                this.year += n / 365;
                n %= 365;
            }
        }
        if (n < 0) {
            n += 365;
        }
        int[] nArray = this.year % 4 == 0 && (this.year % 100 != 0 || this.year % 400 == 0) ? monthStartLeap : monthStart;
        while (n >= nArray[this.month]) {
            ++this.month;
        }
        this.day = n - nArray[this.month - 1] + 1;
    }

    public Date getDate() {
        String string = this.toDateString() + " " + this.toTimeString();
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string);
        }
        catch (ParseException parseException) {
            throw new StringParseException("Could not convert to date.", 0);
        }
    }

    protected void setInternalValues(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.partsecond = d;
        this.hasTZ = n7;
        this.offsetTZ = n8;
        this.isempty = false;
    }

    public SchemaDuration durationValue() {
        throw new TypesIncompatibleException(this, new SchemaDuration("PT"));
    }

    class ParseContext {
        String source;
        int index;

        public ParseContext(String string) {
            this.source = string;
            this.index = 0;
        }

        public boolean isValid() {
            return this.index < this.source.length();
        }

        public boolean check(char c) {
            if (!this.isValid()) {
                return false;
            }
            return this.source.charAt(this.index) == c;
        }

        public boolean checkAndAdvance(char c) {
            if (!this.check(c)) {
                return false;
            }
            this.advance();
            return true;
        }

        public void advance() {
            ++this.index;
        }

        public boolean readDigitAndAdvance(RefInt refInt, int n, int n2) {
            if (!this.isValid()) {
                return false;
            }
            char c = this.source.charAt(this.index);
            if (c < '0' || c > '9') {
                return false;
            }
            int n3 = c - 48;
            if (n3 > n2) {
                return false;
            }
            refInt.value += n3 * n;
            this.advance();
            return true;
        }
    }

    class RefInt {
        public int value;

        RefInt(int n) {
            this.value = n;
        }
    }
}

