/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeNumber;
import com.jmex.xml.types.TypesIncompatibleException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaShort
implements SchemaTypeNumber {
    protected short value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaShort() {
        this.setEmpty();
    }

    public SchemaShort(SchemaShort schemaShort) {
        this.value = schemaShort.value;
        this.isempty = schemaShort.isempty;
        this.isnull = schemaShort.isnull;
    }

    public SchemaShort(short s) {
        this.setValue(s);
    }

    public SchemaShort(int n) {
        this.setValue((short)n);
    }

    public SchemaShort(String string) {
        this.parse(string);
    }

    public SchemaShort(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaShort(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short s) {
        this.value = s;
        this.isempty = false;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            this.value = Short.parseShort(string2);
            this.isempty = false;
            this.isnull = false;
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = (short)((SchemaTypeNumber)schemaType).intValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaShort)) {
            return false;
        }
        return this.value == ((SchemaShort)object).value;
    }

    public Object clone() {
        return new SchemaShort(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return Short.toString(this.value);
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaShort)object);
    }

    public int compareTo(SchemaShort schemaShort) {
        return new Short(this.value).compareTo(new Short(schemaShort.value));
    }

    public int numericType() {
        return 1;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }
}

