/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import java.io.IOException;

public class SwarmInfluence
extends ParticleInfluence {
    private float swarmRangeSQ;
    private Vector3f swarmOffset;
    private Vector3f swarmPoint = new Vector3f();
    public static final float DEFAULT_SWARM_RANGE_SQ = 0.01f;
    public static final float DEFAULT_DEVIANCE = 0.2617994f;
    public static final float DEFAULT_TURN_SPEED = (float)Math.PI;
    public static final float DEFAULT_SPEED_BUMP = 0.1f;
    public static final float DEFAULT_MAX_SPEED = 0.2f;
    private float deviance = 0.2617994f;
    private float turnSpeed = (float)Math.PI;
    private float speedBump = 0.1f;
    private float maxSpeed = 0.2f;
    private transient float maxSpeedSQ = 0.040000003f;
    private static final Vector3f workVect = new Vector3f();
    private static final Vector3f workVect2 = new Vector3f();
    private static final Quaternion workQuat = new Quaternion();

    public SwarmInfluence() {
        this.swarmRangeSQ = 0.01f;
        this.swarmOffset = new Vector3f();
    }

    public SwarmInfluence(Vector3f vector3f, float f) {
        this.swarmRangeSQ = f * f;
        this.swarmOffset = vector3f;
    }

    public void prepare(ParticleGeometry particleGeometry) {
        super.prepare(particleGeometry);
        this.swarmPoint.set(particleGeometry.getOriginCenter()).addLocal(this.swarmOffset);
    }

    public void apply(float f, Particle particle, int n) {
        Vector3f vector3f = particle.getVelocity();
        float f2 = particle.getPosition().distanceSquared(this.swarmPoint);
        workVect.set(this.swarmPoint).subtractLocal(particle.getPosition()).normalizeLocal();
        workVect2.set(vector3f).normalizeLocal();
        if (f2 > this.swarmRangeSQ) {
            float f3 = workVect.angleBetween(workVect2);
            if (f3 < this.deviance) {
                if (vector3f.lengthSquared() < this.maxSpeedSQ) {
                    float f4 = this.speedBump * f;
                    workVect2.multLocal(f4);
                    vector3f.addLocal(workVect2);
                }
            } else {
                Vector3f vector3f2 = workVect2.crossLocal(workVect);
                if ((Float.floatToIntBits(vector3f.lengthSquared()) & 0x1F) != 0) {
                    workQuat.fromAngleAxis(this.turnSpeed * f, vector3f2);
                } else {
                    workQuat.fromAngleAxis(-this.turnSpeed * f, vector3f2);
                }
                workQuat.multLocal(vector3f);
            }
        } else {
            Vector3f vector3f3 = workVect2.crossLocal(workVect);
            if ((n & 0x1F) != 0) {
                workQuat.fromAngleAxis(this.turnSpeed * f, vector3f3);
            } else {
                workQuat.fromAngleAxis(-this.turnSpeed * f, vector3f3);
            }
            workQuat.multLocal(vector3f);
        }
    }

    public float getSwarmRange() {
        return FastMath.sqrt((float)this.swarmRangeSQ);
    }

    public void setSwarmRange(float f) {
        this.swarmRangeSQ = f * f;
    }

    public Vector3f getSwarmOffset() {
        return this.swarmOffset;
    }

    public void setSwarmOffset(Vector3f vector3f) {
        this.swarmPoint = vector3f;
    }

    public float getDeviance() {
        return this.deviance;
    }

    public void setDeviance(float f) {
        this.deviance = f;
    }

    public float getSpeedBump() {
        return this.speedBump;
    }

    public void setSpeedBump(float f) {
        this.speedBump = f;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float f) {
        this.turnSpeed = f;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
        this.maxSpeedSQ = f * f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.swarmRangeSQ, "swarmRangeSQ", 0.01f);
        outputCapsule.write(this.deviance, "deviance", 0.2617994f);
        outputCapsule.write(this.turnSpeed, "turnSpeed", (float)Math.PI);
        outputCapsule.write(this.speedBump, "speedBump", 0.1f);
        outputCapsule.write(this.maxSpeed, "maxSpeed", 0.2f);
        outputCapsule.write((Savable)this.swarmOffset, "swarmOffset", (Savable)new Vector3f());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.swarmRangeSQ = inputCapsule.readFloat("swarmRangeSQ", 0.01f);
        this.deviance = inputCapsule.readFloat("deviance", 0.2617994f);
        this.turnSpeed = inputCapsule.readFloat("turnSpeed", (float)Math.PI);
        this.speedBump = inputCapsule.readFloat("speedBump", 0.1f);
        this.maxSpeed = inputCapsule.readFloat("maxSpeed", 0.2f);
        this.swarmOffset = (Vector3f)inputCapsule.readSavable("swarmOffset", (Savable)new Vector3f());
    }
}

