/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.animation;

import com.jme.scene.Controller;
import com.jme.scene.TriMesh;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class KeyframeController
extends Controller {
    private static final Logger logger = Logger.getLogger(KeyframeController.class.getName());
    private static final long serialVersionUID = 1L;
    public transient ArrayList<PointInTime> keyframes;
    private transient ArrayList<PointInTime> prevKeyframes;
    private TriMesh morphMesh;
    private transient float curTime;
    private transient int curFrame;
    private transient int nextFrame;
    private transient PointInTime before;
    private transient PointInTime after;
    private transient boolean movingForward;
    private transient boolean isSmooth;
    private transient float tempNewBeginTime;
    private transient float tempNewEndTime;
    private boolean updatePerFrame;
    private float blendTime = 0.0f;

    public KeyframeController() {
        this.setSpeed(1.0f);
        this.keyframes = new ArrayList();
        this.curFrame = 0;
        this.setRepeatType(1);
        this.movingForward = true;
        this.setMinTime(0.0f);
        this.setMaxTime(0.0f);
        this.updatePerFrame = true;
    }

    public float getCurrentTime() {
        return this.curTime;
    }

    public int getCurrentFrame() {
        return this.curFrame;
    }

    public float getCurTime() {
        return this.curTime;
    }

    public void setCurTime(float f) {
        this.curTime = f;
    }

    public void setMorphingMesh(TriMesh triMesh) {
        this.morphMesh = triMesh;
        this.keyframes.clear();
        this.keyframes.add(new PointInTime(0.0f, null));
    }

    public void shallowSetMorphMesh(TriMesh triMesh) {
        this.morphMesh = triMesh;
    }

    public void setKeyframe(float f, TriMesh triMesh) {
        if (this.morphMesh == null || f < 0.0f || triMesh.getVertexBuffer(0).capacity() != this.morphMesh.getVertexBuffer(0).capacity()) {
            return;
        }
        for (int i = 0; i < this.keyframes.size(); ++i) {
            PointInTime pointInTime = this.keyframes.get(i);
            if (pointInTime.time == f) {
                pointInTime.newShape = triMesh;
                return;
            }
            if (!(pointInTime.time > f)) continue;
            this.keyframes.add(i, new PointInTime(f, triMesh));
            return;
        }
        this.keyframes.add(new PointInTime(f, triMesh));
        if (f > this.getMaxTime()) {
            this.setMaxTime(f);
        }
        if (f < this.getMinTime()) {
            this.setMinTime(f);
        }
    }

    public void setSmoothTranslation(float f, float f2, float f3, float f4) {
        if (!this.isActive() || this.isSmooth) {
            return;
        }
        if (f3 < 0.0f || f3 > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid begintime:" + f3);
            return;
        }
        if (f4 < 0.0f || f4 > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid endtime:" + f4);
            return;
        }
        TriMesh triMesh = null;
        TriMesh triMesh2 = null;
        if (this.prevKeyframes == null) {
            this.prevKeyframes = new ArrayList();
            triMesh = new TriMesh();
            triMesh2 = new TriMesh();
        } else {
            triMesh = this.prevKeyframes.get((int)0).newShape;
            triMesh2 = this.prevKeyframes.get((int)1).newShape;
            this.prevKeyframes.clear();
        }
        this.getCurrent(triMesh);
        this.curTime = f;
        this.curFrame = 0;
        this.setMinTime(0.0f);
        this.setMaxTime(this.keyframes.get((int)(this.keyframes.size() - 1)).time);
        this.update(0.0f);
        this.getCurrent(triMesh2);
        this.swapKeyframeSets();
        this.curTime = 0.0f;
        this.curFrame = 0;
        this.setMinTime(0.0f);
        this.setMaxTime(f2);
        this.setKeyframe(0.0f, triMesh);
        this.setKeyframe(f2, triMesh2);
        this.isSmooth = true;
        this.tempNewBeginTime = f3;
        this.tempNewEndTime = f4;
    }

    private void swapKeyframeSets() {
        ArrayList<PointInTime> arrayList = this.keyframes;
        this.keyframes = this.prevKeyframes;
        this.prevKeyframes = arrayList;
    }

    public void setNewAnimationTimes(float f, float f2) {
        if (this.isSmooth) {
            return;
        }
        if (f < 0.0f || f > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid begintime:" + f);
            return;
        }
        if (f2 < 0.0f || f2 > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid endtime:" + f2);
            return;
        }
        this.setMinTime(f);
        this.setMaxTime(f2);
        this.setActive(true);
        if (f <= f2) {
            this.movingForward = true;
            this.curTime = f;
            if (f == f2) {
                this.update(0.0f);
                this.setActive(false);
            }
        } else {
            this.movingForward = false;
            this.curTime = f2;
        }
    }

    private void getCurrent(TriMesh triMesh) {
        Buffer buffer;
        Buffer buffer2;
        if (this.morphMesh.getColorBuffer(0) != null) {
            buffer2 = triMesh.getColorBuffer(0);
            if (buffer2 != null) {
                ((FloatBuffer)buffer2).clear();
            }
            buffer = this.morphMesh.getColorBuffer(0);
            ((FloatBuffer)buffer).clear();
            if (buffer2 == null || buffer2.capacity() != buffer.capacity()) {
                buffer2 = BufferUtils.createFloatBuffer((int)buffer.capacity());
                ((FloatBuffer)buffer2).clear();
                triMesh.setColorBuffer(0, (FloatBuffer)buffer2);
            }
            ((FloatBuffer)buffer2).put((FloatBuffer)buffer);
            ((FloatBuffer)buffer2).flip();
        }
        if (this.morphMesh.getVertexBuffer(0) != null) {
            buffer2 = triMesh.getVertexBuffer(0);
            if (buffer2 != null) {
                ((FloatBuffer)buffer2).clear();
            }
            buffer = this.morphMesh.getVertexBuffer(0);
            ((FloatBuffer)buffer).clear();
            if (buffer2 == null || buffer2.capacity() != buffer.capacity()) {
                buffer2 = BufferUtils.createFloatBuffer((int)buffer.capacity());
                ((FloatBuffer)buffer2).clear();
                triMesh.setVertexBuffer(0, (FloatBuffer)buffer2);
            }
            ((FloatBuffer)buffer2).put((FloatBuffer)buffer);
            ((FloatBuffer)buffer2).flip();
        }
        if (this.morphMesh.getNormalBuffer(0) != null) {
            buffer2 = triMesh.getNormalBuffer(0);
            if (buffer2 != null) {
                ((FloatBuffer)buffer2).clear();
            }
            buffer = this.morphMesh.getNormalBuffer(0);
            ((FloatBuffer)buffer).clear();
            if (buffer2 == null || buffer2.capacity() != buffer.capacity()) {
                buffer2 = BufferUtils.createFloatBuffer((int)buffer.capacity());
                ((FloatBuffer)buffer2).clear();
                triMesh.setNormalBuffer(0, (FloatBuffer)buffer2);
            }
            ((FloatBuffer)buffer2).put((FloatBuffer)buffer);
            ((FloatBuffer)buffer2).flip();
        }
        if (this.morphMesh.getIndexBuffer(0) != null) {
            buffer2 = triMesh.getIndexBuffer(0);
            if (buffer2 != null) {
                ((IntBuffer)buffer2).clear();
            }
            buffer = this.morphMesh.getIndexBuffer(0);
            ((IntBuffer)buffer).clear();
            if (buffer2 == null || buffer2.capacity() != buffer.capacity()) {
                buffer2 = BufferUtils.createIntBuffer((int)buffer.capacity());
                ((IntBuffer)buffer2).clear();
                triMesh.setIndexBuffer(0, (IntBuffer)buffer2);
            }
            ((IntBuffer)buffer2).put((IntBuffer)buffer);
            ((IntBuffer)buffer2).flip();
        }
        if (this.morphMesh.getTextureBuffer(0, 0) != null) {
            buffer2 = triMesh.getTextureBuffer(0, 0);
            if (buffer2 != null) {
                ((FloatBuffer)buffer2).clear();
            }
            buffer = this.morphMesh.getTextureBuffer(0, 0);
            ((FloatBuffer)buffer).clear();
            if (buffer2 == null || buffer2.capacity() != buffer.capacity()) {
                buffer2 = BufferUtils.createFloatBuffer((int)buffer.capacity());
                ((FloatBuffer)buffer2).clear();
                triMesh.setTextureBuffer(0, (FloatBuffer)buffer2, 0);
            }
            ((FloatBuffer)buffer2).put((FloatBuffer)buffer);
            ((FloatBuffer)buffer2).flip();
        }
    }

    public void update(float f) {
        if (this.easyQuit()) {
            return;
        }
        this.curTime = this.movingForward ? (this.curTime += f * this.getSpeed()) : (this.curTime -= f * this.getSpeed());
        this.findFrame();
        this.before = this.keyframes.get(this.curFrame);
        this.after = this.keyframes.get(this.nextFrame);
        float f2 = (this.curTime - this.before.time) / (this.after.time - this.before.time);
        if (this.nextFrame < this.curFrame) {
            f2 = this.blendTime - (this.getMinTime() - this.curTime);
        }
        TriMesh triMesh = this.before.newShape;
        TriMesh triMesh2 = this.after.newShape;
        FloatBuffer floatBuffer = this.morphMesh.getVertexBuffer(0);
        FloatBuffer floatBuffer2 = this.morphMesh.getNormalBuffer(0);
        FloatBuffer floatBuffer3 = this.morphMesh.getTextureBuffer(0, 0);
        FloatBuffer floatBuffer4 = this.morphMesh.getColorBuffer(0);
        FloatBuffer floatBuffer5 = triMesh.getVertexBuffer(0);
        FloatBuffer floatBuffer6 = triMesh.getNormalBuffer(0);
        FloatBuffer floatBuffer7 = triMesh.getTextureBuffer(0, 0);
        FloatBuffer floatBuffer8 = triMesh.getColorBuffer(0);
        FloatBuffer floatBuffer9 = triMesh2.getVertexBuffer(0);
        FloatBuffer floatBuffer10 = triMesh2.getNormalBuffer(0);
        FloatBuffer floatBuffer11 = triMesh2.getTextureBuffer(0, 0);
        FloatBuffer floatBuffer12 = triMesh2.getColorBuffer(0);
        int n = floatBuffer.capacity() / 3;
        if (floatBuffer == null || floatBuffer5 == null || floatBuffer9 == null) {
            return;
        }
        floatBuffer.rewind();
        floatBuffer5.rewind();
        floatBuffer9.rewind();
        if (floatBuffer2 != null) {
            floatBuffer2.rewind();
        }
        if (floatBuffer6 != null) {
            floatBuffer6.rewind();
        }
        if (floatBuffer10 != null) {
            floatBuffer10.rewind();
        }
        if (floatBuffer3 != null) {
            floatBuffer3.rewind();
        }
        if (floatBuffer7 != null) {
            floatBuffer7.rewind();
        }
        if (floatBuffer11 != null) {
            floatBuffer11.rewind();
        }
        if (floatBuffer4 != null) {
            floatBuffer4.rewind();
        }
        if (floatBuffer8 != null) {
            floatBuffer8.rewind();
        }
        if (floatBuffer12 != null) {
            floatBuffer12.rewind();
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < 3; ++n2) {
                floatBuffer.put(i * 3 + n2, (1.0f - f2) * floatBuffer5.get(i * 3 + n2) + f2 * floatBuffer9.get(i * 3 + n2));
            }
            if (floatBuffer2 != null && floatBuffer6 != null && floatBuffer10 != null) {
                for (n2 = 0; n2 < 3; ++n2) {
                    floatBuffer2.put(i * 3 + n2, (1.0f - f2) * floatBuffer6.get(i * 3 + n2) + f2 * floatBuffer10.get(i * 3 + n2));
                }
            }
            if (floatBuffer3 != null && floatBuffer7 != null && floatBuffer11 != null) {
                for (n2 = 0; n2 < 2; ++n2) {
                    floatBuffer3.put(i * 2 + n2, (1.0f - f2) * floatBuffer7.get(i * 2 + n2) + f2 * floatBuffer11.get(i * 2 + n2));
                }
            }
            if (floatBuffer4 == null || floatBuffer8 == null || floatBuffer12 == null) continue;
            for (n2 = 0; n2 < 4; ++n2) {
                floatBuffer4.put(i * 4 + n2, (1.0f - f2) * floatBuffer8.get(i * 4 + n2) + f2 * floatBuffer12.get(i * 4 + n2));
            }
        }
        if (this.updatePerFrame) {
            this.morphMesh.updateModelBound();
        }
    }

    private boolean easyQuit() {
        if (this.getMaxTime() == this.getMinTime() && this.curTime != this.getMinTime()) {
            return true;
        }
        if (this.getRepeatType() == 0 && (this.curTime > this.getMaxTime() || this.curTime < this.getMinTime())) {
            return true;
        }
        return this.keyframes.size() < 2;
    }

    public void setModelUpdate(boolean bl) {
        this.updatePerFrame = bl;
    }

    public boolean getModelUpdate() {
        return this.updatePerFrame;
    }

    public void setBlendTime(float f) {
        this.blendTime = f;
    }

    public float getBlendTime() {
        return this.blendTime;
    }

    private void findFrame() {
        if (this.curTime < this.getMinTime() && this.nextFrame < this.curFrame) {
            return;
        }
        if (this.curTime > this.getMaxTime()) {
            if (this.isSmooth) {
                this.swapKeyframeSets();
                this.isSmooth = false;
                this.curTime = this.tempNewBeginTime;
                this.curFrame = 0;
                this.nextFrame = 1;
                this.setNewAnimationTimes(this.tempNewBeginTime, this.tempNewEndTime);
                return;
            }
            if (this.getRepeatType() == 1) {
                float f = this.blendTime;
                this.curTime = this.getMinTime() - f;
                this.curFrame = Math.min(this.curFrame + 1, this.keyframes.size() - 1);
                this.nextFrame = 0;
                while (this.nextFrame < this.keyframes.size() - 1 && !(this.getMinTime() <= this.keyframes.get((int)this.nextFrame).time)) {
                    ++this.nextFrame;
                }
                return;
            }
            if (this.getRepeatType() == 0) {
                return;
            }
            this.movingForward = false;
            this.curTime = this.getMaxTime();
        } else if (this.curTime < this.getMinTime()) {
            if (this.getRepeatType() == 1) {
                this.curTime = this.getMaxTime();
                this.curFrame = 0;
            } else {
                if (this.getRepeatType() == 0) {
                    return;
                }
                this.movingForward = true;
                this.curTime = this.getMinTime();
            }
        }
        this.nextFrame = this.curFrame + 1;
        if (this.curTime > this.keyframes.get((int)this.curFrame).time) {
            if (this.curTime < this.keyframes.get((int)(this.curFrame + 1)).time) {
                this.nextFrame = this.curFrame + 1;
                return;
            }
            while (this.curFrame < this.keyframes.size() - 1) {
                if (this.curTime <= this.keyframes.get((int)(this.curFrame + 1)).time) {
                    this.nextFrame = this.curFrame + 1;
                    return;
                }
                ++this.curFrame;
            }
            this.curTime = this.getMinTime();
            this.curFrame = 0;
            this.nextFrame = this.curFrame + 1;
            return;
        }
        while (this.curFrame >= 0) {
            if (this.curTime >= this.keyframes.get((int)this.curFrame).time) {
                this.nextFrame = this.curFrame + 1;
                return;
            }
            --this.curFrame;
        }
        this.curFrame = 0;
        this.nextFrame = this.curFrame + 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyframes = (ArrayList)objectInputStream.readObject();
        this.movingForward = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.isSmooth) {
            objectOutputStream.writeObject(this.prevKeyframes);
        } else {
            objectOutputStream.writeObject(this.keyframes);
        }
    }

    public TriMesh getMorphMesh() {
        return this.morphMesh;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.updatePerFrame, "updatePerFrame", true);
        outputCapsule.write((Savable)this.morphMesh, "morphMesh", null);
        outputCapsule.writeSavableArrayList(this.keyframes, "keyframes", new ArrayList());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.updatePerFrame = inputCapsule.readBoolean("updatePerFrame", true);
        this.morphMesh = (TriMesh)inputCapsule.readSavable("morphMesh", null);
        this.keyframes = inputCapsule.readSavableArrayList("keyframes", new ArrayList());
        this.movingForward = true;
    }

    public static class PointInTime
    implements Serializable,
    Savable {
        private static final long serialVersionUID = 1L;
        public TriMesh newShape;
        public float time;

        public PointInTime() {
        }

        public PointInTime(float f, TriMesh triMesh) {
            this.time = f;
            this.newShape = triMesh;
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
            this.time = inputCapsule.readFloat("time", 0.0f);
            this.newShape = (TriMesh)inputCapsule.readSavable("newShape", null);
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
            outputCapsule.write(this.time, "time", 0.0f);
            outputCapsule.write((Savable)this.newShape, "newShape", null);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }
}

