/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jme.math.Vector3f;
import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;

class SpotLightChunk
extends ChunkerClass {
    Vector3f target;
    float hotSpot;
    float fallOff;
    boolean shadowed;
    float roll;
    short shadowSize;
    float lightBias;
    float filter;
    float shadowBias;

    public SpotLightChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.target = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        this.hotSpot = this.myIn.readFloat();
        this.fallOff = this.myIn.readFloat();
        this.decrHeaderLen(20);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 18006: {
                this.readSpotlightRollAngles();
                return true;
            }
            case 17968: {
                this.shadowed = true;
                return true;
            }
            case 18008: {
                this.readLightBias();
                return true;
            }
            case 17985: {
                this.readLightShadow();
                return true;
            }
            case 18000: {
                return true;
            }
            case 18002: {
                return true;
            }
        }
        return false;
    }

    private void readLightShadow() throws IOException {
        this.shadowBias = this.myIn.readFloat();
        this.filter = this.myIn.readFloat();
        this.shadowSize = this.myIn.readShort();
    }

    private void readLightBias() throws IOException {
        this.lightBias = this.myIn.readFloat();
    }

    private void readSpotlightRollAngles() throws IOException {
        this.roll = this.myIn.readFloat();
    }
}

